/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.PhysicalPageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfGraphics2D;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfLogicalPageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PdfDocumentWriter {
    private static final Log logger = LogFactory.getLog(PdfDocumentWriter.class);
    private static final String CREATOR = ClassicEngineInfo.getInstance().getName() + " version " + ClassicEngineInfo.getInstance().getVersion();
    private static final byte[] PDF_PASSWORD_PAD = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private Document document;
    private PdfOutputProcessorMetaData metaData;
    private OutputStream out;
    private PdfWriter writer;
    private boolean awaitOpenDocument;
    private Configuration config;
    private ResourceManager resourceManager;
    private LFUMap<ResourceKey, Image> imageCache;
    private char version;

    public PdfDocumentWriter(PdfOutputProcessorMetaData metaData, OutputStream out, ResourceManager resourceManager) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        if (out == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.imageCache = new LFUMap(50);
        this.resourceManager = resourceManager;
        this.metaData = metaData;
        this.out = out;
        this.config = metaData.getConfiguration();
    }

    private Document getDocument() {
        return this.document;
    }

    public void open() throws DocumentException {
        this.document = new Document();
        this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.out);
        this.writer.setLinearPageMode();
        this.version = this.getVersion();
        this.writer.setPdfVersion(this.version);
        this.writer.setViewerPreferences(this.getViewerPreferences());
        String encrypt = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Encryption");
        if (encrypt != null && (encrypt.equals("128bit") || encrypt.equals("40bit"))) {
            String userpassword = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.UserPassword");
            String ownerpassword = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.OwnerPassword");
            byte[] userpasswordbytes = DocWriter.getISOBytes((String)userpassword);
            byte[] ownerpasswordbytes = DocWriter.getISOBytes((String)ownerpassword);
            if (ownerpasswordbytes == null) {
                ownerpasswordbytes = PDF_PASSWORD_PAD;
            }
            int encryptionType = encrypt.equals("128bit") ? 1 : 0;
            this.writer.setEncryption(userpasswordbytes, ownerpasswordbytes, this.getPermissions(), encryptionType);
        }
        String title = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Title", this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Title"));
        String subject = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Description", this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Description"));
        String author = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Author", this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Author"));
        String keyWords = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Keywords", this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Keywords"));
        if (title != null) {
            this.document.addTitle(title);
        }
        if (author != null) {
            this.document.addAuthor(author);
        }
        if (keyWords != null) {
            this.document.addKeywords(keyWords);
        }
        if (keyWords != null) {
            this.document.addSubject(subject);
        }
        this.document.addCreator(CREATOR);
        this.document.addCreationDate();
        this.awaitOpenDocument = true;
    }

    private int getViewerPreferences() {
        String pageLayout = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PageLayout");
        String pageMode = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PageMode");
        String fullScreenMode = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.FullScreenMode");
        boolean hideToolBar = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.HideToolBar"));
        boolean hideMenuBar = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.HideMenuBar"));
        boolean hideWindowUI = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.HideWindowUI"));
        boolean fitWindow = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.FitWindow"));
        boolean centerWindow = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.CenterWindow"));
        boolean displayDocTitle = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.DisplayDocTitle"));
        boolean printScalingNone = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PrintScalingNone"));
        String direction = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Direction");
        int viewerPreferences = 0;
        if ("PageLayoutOneColumn".equals(pageLayout)) {
            viewerPreferences = 2;
        } else if ("PageLayoutSinglePage".equals(pageLayout)) {
            viewerPreferences = 1;
        } else if ("PageLayoutTwoColumnLeft".equals(pageLayout)) {
            viewerPreferences = 4;
        } else if ("PageLayoutTwoColumnRight".equals(pageLayout)) {
            viewerPreferences = 8;
        } else if ("PageLayoutTwoPageLeft".equals(pageLayout)) {
            viewerPreferences = 16;
        } else if ("PageLayoutTwoPageRight".equals(pageLayout)) {
            viewerPreferences = 32;
        }
        if ("PageModeUseNone".equals(pageMode)) {
            viewerPreferences |= 0x40;
        } else if ("PageModeUseOutlines".equals(pageMode)) {
            viewerPreferences |= 0x80;
        } else if ("PageModeUseThumbs".equals(pageMode)) {
            viewerPreferences |= 0x100;
        } else if ("PageModeFullScreen".equals(pageMode)) {
            viewerPreferences |= 0x200;
            if ("NonFullScreenPageModeUseNone".equals(fullScreenMode)) {
                viewerPreferences = 262144;
            } else if ("NonFullScreenPageModeUseOC".equals(fullScreenMode)) {
                viewerPreferences |= 0x200000;
            } else if ("NonFullScreenPageModeUseOutlines".equals(fullScreenMode)) {
                viewerPreferences |= 0x80000;
            } else if ("NonFullScreenPageModeUseThumbs".equals(fullScreenMode)) {
                viewerPreferences |= 0x100000;
            }
        } else if ("PageModeUseOC".equals(pageMode)) {
            viewerPreferences |= 0x400;
        } else if ("PageModeUseAttachments".equals(pageMode)) {
            viewerPreferences |= 0x800;
        }
        if (hideToolBar) {
            viewerPreferences |= 0x1000;
        }
        if (hideMenuBar) {
            viewerPreferences |= 0x2000;
        }
        if (hideWindowUI) {
            viewerPreferences |= 0x4000;
        }
        if (fitWindow) {
            viewerPreferences |= 0x8000;
        }
        if (centerWindow) {
            viewerPreferences |= 0x10000;
        }
        if (displayDocTitle) {
            viewerPreferences |= 0x20000;
        }
        if (printScalingNone) {
            viewerPreferences |= 0x1000000;
        }
        if ("DirectionL2R".equals(direction)) {
            viewerPreferences |= 0x400000;
        } else if ("DirectionR2L".equals(direction)) {
            viewerPreferences |= 0x800000;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("viewerPreferences = 0b" + Integer.toBinaryString(viewerPreferences)));
        }
        return viewerPreferences;
    }

    public void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) throws DocumentException {
        PhysicalPageBox page = pageGrid.getPage(row, col);
        if (page == null) {
            return;
        }
        float width = (float)StrictGeomUtility.toExternalValue(page.getWidth());
        float height = (float)StrictGeomUtility.toExternalValue(page.getHeight());
        Rectangle pageSize = new Rectangle(width, height);
        float marginLeft = (float)StrictGeomUtility.toExternalValue(page.getImageableX());
        float marginRight = (float)StrictGeomUtility.toExternalValue(page.getWidth() - page.getImageableWidth() - page.getImageableX());
        float marginTop = (float)StrictGeomUtility.toExternalValue(page.getImageableY());
        float marginBottom = (float)StrictGeomUtility.toExternalValue(page.getHeight() - page.getImageableHeight() - page.getImageableY());
        Document document = this.getDocument();
        document.setPageSize(pageSize);
        document.setMargins(marginLeft, marginRight, marginTop, marginBottom);
        if (this.awaitOpenDocument) {
            document.open();
            this.awaitOpenDocument = false;
        }
        PdfContentByte directContent = this.writer.getDirectContent();
        PdfGraphics2D graphics = new PdfGraphics2D(directContent, width, height, this.metaData);
        PdfLogicalPageDrawable logicalPageDrawable = this.createLogicalPageDrawable(logicalPage, page);
        PhysicalPageDrawable drawable = this.createPhysicalPageDrawable(logicalPageDrawable, page);
        drawable.draw(graphics, new Rectangle2D.Double(0.0, 0.0, width, height));
        ((Graphics)graphics).dispose();
        document.newPage();
    }

    protected PhysicalPageDrawable createPhysicalPageDrawable(PdfLogicalPageDrawable logicalPageDrawable, PhysicalPageBox page) {
        return new PhysicalPageDrawable(logicalPageDrawable, page);
    }

    public void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) throws DocumentException {
        float width = (float)StrictGeomUtility.toExternalValue(logicalPage.getPageWidth());
        float height = (float)StrictGeomUtility.toExternalValue(logicalPage.getPageHeight());
        Rectangle pageSize = new Rectangle(width, height);
        Document document = this.getDocument();
        document.setPageSize(pageSize);
        document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.awaitOpenDocument) {
            document.open();
            this.awaitOpenDocument = false;
        }
        PdfGraphics2D graphics = new PdfGraphics2D(this.writer.getDirectContent(), width, height, this.metaData);
        PdfLogicalPageDrawable logicalPageDrawable = this.createLogicalPageDrawable(logicalPage, null);
        logicalPageDrawable.draw(graphics, new Rectangle2D.Double(0.0, 0.0, width, height));
        ((Graphics)graphics).dispose();
        document.newPage();
    }

    protected PdfOutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    protected PdfWriter getWriter() {
        return this.writer;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public LFUMap<ResourceKey, Image> getImageCache() {
        return this.imageCache;
    }

    protected PdfLogicalPageDrawable createLogicalPageDrawable(LogicalPageBox logicalPage, PhysicalPageBox page) {
        PdfLogicalPageDrawable drawable = new PdfLogicalPageDrawable(this.getWriter(), this.getImageCache(), this.getVersion());
        drawable.init(logicalPage, this.getMetaData(), this.getResourceManager(), page);
        return drawable;
    }

    public void close() {
        this.getDocument().close();
        try {
            this.out.flush();
        }
        catch (IOException e) {
            logger.info((Object)"Flushing the PDF-Export-Stream failed.");
        }
        this.document = null;
        this.writer = null;
    }

    protected char getVersion() {
        String version = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Version");
        if (version == null) {
            return '5';
        }
        if (version.length() < 3) {
            logger.warn((Object)"PDF version specification is invalid, using default version '1.4'.");
            return '5';
        }
        char retval = version.charAt(2);
        if (retval < '2' || retval > '9') {
            logger.warn((Object)"PDF version specification is invalid, using default version '1.4'.");
            return '5';
        }
        return retval;
    }

    private int getPermissions() {
        String printLevel = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PrintLevel");
        boolean allowPrinting = !"none".equals(printLevel);
        boolean allowDegradedPrinting = "degraded".equals(printLevel);
        boolean allowModifyContents = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowModifyContents"));
        boolean allowModifyAnn = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowModifyAnnotations"));
        boolean allowCopy = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowCopy"));
        boolean allowFillIn = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowFillIn"));
        boolean allowScreenReaders = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowScreenReader"));
        boolean allowAssembly = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowAssembly"));
        int permissions = 0;
        if (allowPrinting) {
            permissions |= 0x804;
        }
        if (allowModifyContents) {
            permissions |= 8;
        }
        if (allowModifyAnn) {
            permissions |= 0x20;
        }
        if (allowCopy) {
            permissions |= 0x10;
        }
        if (allowFillIn) {
            permissions |= 0x100;
        }
        if (allowScreenReaders) {
            permissions |= 0x200;
        }
        if (allowAssembly) {
            permissions |= 0x400;
        }
        if (allowDegradedPrinting) {
            permissions |= 4;
        }
        return permissions;
    }
}

