/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.base;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.AbstractRenderer;
import org.pentaho.reporting.engine.classic.core.layout.ModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.CleanPaginatedBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CountBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.FillPhysicalPagesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.OrphanStep;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationStep;
import org.pentaho.reporting.engine.classic.core.layout.process.WidowStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationResult;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;

public class PageableRenderer
extends AbstractRenderer {
    private static final Log logger = LogFactory.getLog(PageableRenderer.class);
    private PaginationStep paginationStep = new PaginationStep();
    private OrphanStep orphanStep;
    private WidowStep widowStep;
    private FillPhysicalPagesStep fillPhysicalPagesStep = new FillPhysicalPagesStep();
    private CleanPaginatedBoxesStep cleanPaginatedBoxesStep = new CleanPaginatedBoxesStep();
    private int pageCount;
    private boolean pageStartPending;
    private CountBoxesStep countBoxesStep = new CountBoxesStep();
    private boolean widowsEnabled;

    public PageableRenderer(OutputProcessor outputProcessor) {
        super(outputProcessor);
        this.orphanStep = new OrphanStep();
        this.widowStep = new WidowStep();
        this.initialize();
    }

    @Override
    public void startReport(ReportDefinition report, ProcessingContext processingContext, PerformanceMonitorContext performanceMonitorContext) {
        super.startReport(report, processingContext, performanceMonitorContext);
        this.pageCount = 0;
        this.widowsEnabled = !ClassicEngineBoot.isEnforceCompatibilityFor(processingContext.getCompatibilityLevel(), 3, 8);
    }

    @Override
    protected void debugPrint(LogicalPageBox pageBox) {
    }

    protected void printConditional(int page, LogicalPageBox pageBox) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug((Object)("Printing a page: " + this.pageCount));
        if (this.pageCount == page) {
            logger.debug((Object)("1: **** Start Printing Page: " + this.pageCount));
            ModelPrinter.INSTANCE.print(pageBox);
            logger.debug((Object)("1: **** Stop  Printing Page: " + this.pageCount));
        }
    }

    @Override
    protected boolean preparePagination(LogicalPageBox pageBox) {
        if (!this.widowsEnabled) {
            return true;
        }
        if (!this.isWidowOrphanDefinitionsEncountered()) {
            return true;
        }
        if (this.orphanStep.processOrphanAnnotation(pageBox)) {
            return false;
        }
        return !this.widowStep.processWidowAnnotation(pageBox);
    }

    @Override
    protected boolean isPageFinished() {
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (pageBreak.isOverflow() || !pageBox.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Detected pagebreak : " + pageBreak.getLastVisibleState()));
            }
            this.setLastStateKey(pageBreak.getLastVisibleState());
            return true;
        }
        return false;
    }

    @Override
    protected boolean performPagination(LayoutPagebreakHandler layoutPagebreakHandler, boolean performOutput) throws ContentProcessingException {
        boolean repeat;
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (pageBox.isOpen() && !pageBreak.isOverflow()) {
            return false;
        }
        this.setLastStateKey(pageBreak.getLastVisibleState());
        this.setPagebreaks(this.getPagebreaks() + 1);
        pageBox.setAllVerticalBreaks(pageBreak.getAllBreaks());
        ++this.pageCount;
        this.debugPrint(pageBox);
        OutputProcessor outputProcessor = this.getOutputProcessor();
        long nextOffset = pageBreak.getLastPosition();
        long pageOffset = pageBox.getPageOffset();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PageableRenderer: pageOffset=" + pageOffset + "; nextOffset=" + nextOffset));
        }
        if (performOutput) {
            if (outputProcessor.isNeedAlignedPage()) {
                LogicalPageBox box = this.fillPhysicalPagesStep.compute(pageBox, pageOffset, nextOffset);
                outputProcessor.processContent(box);
            } else {
                outputProcessor.processContent(pageBox);
            }
        } else {
            outputProcessor.processRecomputedContent(pageBox);
        }
        boolean bl = repeat = pageBox.isOpen() || pageBox.getHeight() > nextOffset;
        if (repeat) {
            pageBox.setPageOffset(nextOffset);
            this.countBoxesStep.process(pageBox);
            this.cleanPaginatedBoxesStep.compute(pageBox);
            pageBox.resetCacheState(true);
            if (pageBreak.isNextPageContainsContent()) {
                if (layoutPagebreakHandler != null) {
                    layoutPagebreakHandler.pageStarted();
                }
                return true;
            }
            this.pageStartPending = true;
            return false;
        }
        pageBox.setPageOffset(nextOffset);
        outputProcessor.processingFinished();
        return false;
    }

    @Override
    public boolean clearPendingPageStart(LayoutPagebreakHandler layoutPagebreakHandler) {
        if (!this.pageStartPending) {
            return false;
        }
        if (layoutPagebreakHandler != null) {
            layoutPagebreakHandler.pageStarted();
        }
        this.pageStartPending = false;
        return true;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public boolean isCurrentPageEmpty() {
        LogicalPageBox logicalPageBox = this.getPageBox();
        if (logicalPageBox == null) {
            throw new IllegalStateException("LogicalPageBox being null? You messed it up again!");
        }
        PageBreakPositionList breakPositionList = logicalPageBox.getAllVerticalBreaks();
        long masterBreak = breakPositionList.getLastMasterBreak();
        boolean nextPageContainsContent = logicalPageBox.getHeight() > masterBreak;
        return !nextPageContainsContent;
    }

    @Override
    public boolean isPageStartPending() {
        return this.pageStartPending;
    }

    @Override
    public boolean isPendingPageHack() {
        return true;
    }

    @Override
    protected void initializeRendererOnStartReport(ProcessingContext processingContext) {
        super.initializeRendererOnStartReport(processingContext);
        this.paginationStep.initializePerformanceMonitoring(this.getPerformanceMonitorContext());
        this.fillPhysicalPagesStep.initializePerformanceMonitoring(this.getPerformanceMonitorContext());
    }

    @Override
    protected void close() {
        super.close();
        this.paginationStep.close();
        this.fillPhysicalPagesStep.close();
    }
}

