/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DynamicStyleKey {
    private InstanceID rootBandId;
    private Map<InstanceID, StyleInfoCollection> dynamicStylePerElement;
    private Integer hashCode;

    private DynamicStyleKey(InstanceID rootBandId, Map<InstanceID, StyleInfoCollection> dynamicStylePerElement) {
        this.rootBandId = rootBandId;
        this.dynamicStylePerElement = dynamicStylePerElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicStyleKey that = (DynamicStyleKey)o;
        if (!ObjectUtilities.equal((Object)this.hashCode, (Object)that.hashCode)) {
            return false;
        }
        if (!this.dynamicStylePerElement.equals(that.dynamicStylePerElement)) {
            return false;
        }
        return this.rootBandId.equals(that.rootBandId);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = this.rootBandId.hashCode();
            result = 31 * result + this.dynamicStylePerElement.hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public static DynamicStyleKey create(Band band, ExpressionRuntime runtime) {
        Map<InstanceID, StyleInfoCollection> style = new DynamicStyleKeyProducer().collect(band, runtime);
        return new DynamicStyleKey(band.getObjectID(), style);
    }

    private static class DynamicStyleKeyProducer
    extends AbstractStructureVisitor {
        private HashMap<InstanceID, StyleKey[]> dynamicTemplateInfo;
        private HashMap<InstanceID, StyleInfoCollection> styleInfo;
        private ExpressionRuntime runtime;

        private DynamicStyleKeyProducer() {
        }

        public Map<InstanceID, StyleInfoCollection> collect(Band band, ExpressionRuntime runtime) {
            ArgumentNullException.validate((String)"band", (Object)band);
            ArgumentNullException.validate((String)"runtime", (Object)runtime);
            this.runtime = runtime;
            this.dynamicTemplateInfo = (HashMap)band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "fast-export-dynamic-style-stash");
            if (this.dynamicTemplateInfo == null) {
                return Collections.emptyMap();
            }
            this.styleInfo = new HashMap();
            this.inspectElement(band);
            this.traverseSection(band);
            return this.styleInfo;
        }

        @Override
        protected void traverseSection(Section section) {
            this.traverseSectionWithoutSubReports(section);
        }

        @Override
        protected void inspectElement(ReportElement element) {
            StyleKey[] styleIndex = this.dynamicTemplateInfo.get(element.getObjectID());
            if (styleIndex == null || styleIndex.length == 0) {
                return;
            }
            Object value = element.getElementType().getValue(this.runtime, element);
            boolean empty = this.isEmpty(value);
            StyleInfoCollection lastCollection = (StyleInfoCollection)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "fast-export-element-style-stash");
            SimpleStyleSheet computedStyle = element.getComputedStyle();
            if (lastCollection != null && lastCollection.getStyleChangeTracker() == computedStyle.getChangeTrackerHash() && lastCollection.nullValue == empty) {
                this.styleInfo.put(element.getObjectID(), lastCollection);
                return;
            }
            StyleInfoCollection collection = new StyleInfoCollection(styleIndex.length, empty);
            collection.setStyleChangeTracker(computedStyle.getChangeTrackerHash());
            for (StyleKey styleKey : styleIndex) {
                collection.add(styleKey, computedStyle.getStyleProperty(styleKey));
            }
            this.styleInfo.put(element.getObjectID(), collection);
        }

        private boolean isEmpty(Object o) {
            if (o == null) {
                return true;
            }
            return "".equals(o);
        }
    }

    private static class StyleInfoCollection {
        private ArrayList<StyleInfo> styleInfo;
        private Integer hashCode;
        private long styleChangeTracker;
        private boolean nullValue;

        private StyleInfoCollection(int length, boolean nullValue) {
            this.styleInfo = new ArrayList(length);
            this.nullValue = nullValue;
        }

        public void add(StyleKey k, Object o) {
            this.styleInfo.add(new StyleInfo(k.getIdentifier(), o));
        }

        public long getStyleChangeTracker() {
            return this.styleChangeTracker;
        }

        private void setStyleChangeTracker(long styleChangeTracker) {
            this.styleChangeTracker = styleChangeTracker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StyleInfoCollection that = (StyleInfoCollection)o;
            if (!ObjectUtilities.equal((Object)this.hashCode, (Object)that.hashCode)) {
                return false;
            }
            if (!this.styleInfo.equals(that.styleInfo)) {
                return false;
            }
            return this.nullValue == that.nullValue;
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = this.styleInfo.hashCode() + 23 * (this.nullValue ? 1 : 0);
            }
            return this.hashCode;
        }

        private static class StyleInfo {
            private int styleKeyIndex;
            private Object styleValue;

            private StyleInfo(int styleKeyIndex, Object styleValue) {
                this.styleKeyIndex = styleKeyIndex;
                this.styleValue = styleValue;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                StyleInfo styleInfo = (StyleInfo)o;
                if (this.styleKeyIndex != styleInfo.styleKeyIndex) {
                    return false;
                }
                return !(this.styleValue != null ? !this.styleValue.equals(styleInfo.styleValue) : styleInfo.styleValue != null);
            }

            public int hashCode() {
                int result = this.styleKeyIndex;
                result = 31 * result + (this.styleValue != null ? this.styleValue.hashCode() : 0);
                return result;
            }
        }
    }
}

