/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.configstore.filesystem;

import java.io.File;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.filesystem.FileConfigStorage;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializer;

public class FileConfigStoreModuleInitializer
implements ModuleInitializer {
    public static final String USER_BASEDIR_CONFIG_KEY = "org.pentaho.reporting.engine.classic.core.modules.misc.configstore.filesystem.UserTargetDir";
    public static final String SYSTEM_BASEDIR_CONFIG_KEY = "org.pentaho.reporting.engine.classic.core.modules.misc.configstore.filesystem.SystemTargetDir";

    public void performInit() throws ModuleInitializeException {
        String userBaseDirectory = ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(USER_BASEDIR_CONFIG_KEY, "~/.pentaho/classic-engine/user");
        String systemBaseDirectory = ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(SYSTEM_BASEDIR_CONFIG_KEY, "~/.pentaho/classic-engine/system");
        ConfigFactory factory = ConfigFactory.getInstance();
        factory.defineUserStorage(new FileConfigStorage(this.getStoragePath(userBaseDirectory)));
        factory.defineSystemStorage(new FileConfigStorage(this.getStoragePath(systemBaseDirectory)));
    }

    private File getStoragePath(String baseDirectory) throws ModuleInitializeException {
        File baseDirectoryFile;
        if (baseDirectory == null) {
            throw new IllegalArgumentException("The base directory must not be null");
        }
        if (!baseDirectory.startsWith("~/")) {
            baseDirectoryFile = new File(baseDirectory);
        } else {
            try {
                String homeDirectory = System.getProperty("user.home");
                if ("~/".equals(baseDirectory)) {
                    baseDirectoryFile = new File(homeDirectory);
                } else {
                    baseDirectory = baseDirectory.substring(2);
                    baseDirectoryFile = new File(homeDirectory, baseDirectory);
                }
            }
            catch (Exception e) {
                throw new ModuleInitializeException("Failed to create the file config storage.", (Throwable)e);
            }
        }
        if (!baseDirectoryFile.exists()) {
            if (!baseDirectoryFile.mkdirs()) {
                throw new ModuleInitializeException("Unable to create the specified directory.");
            }
        } else if (!baseDirectoryFile.canRead() || !baseDirectoryFile.canWrite()) {
            throw new ModuleInitializeException("Unable to access the specified directory.");
        }
        return baseDirectoryFile;
    }
}

