/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.GuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PageFormatPreviewPane;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class PageSetupDialog
extends CommonDialog {
    private JComboBox pageFormatBox;
    private JTextField pageHeightField;
    private JTextField pageWidthField;
    private JCheckBox portraitModeBox;
    private JCheckBox landscapeModeBox;
    private JTextField spanHorizontalField;
    private JTextField spanVerticalField;
    private JTextField marginTopField;
    private JTextField marginLeftField;
    private JTextField marginBottomField;
    private JTextField marginRightField;
    private GuiContext guiContext;
    private JCheckBox preDefinedPageSizeBox;
    private JCheckBox userDefinedPageSizeBox;
    private PageFormatPreviewPane previewPane;
    private ResourceBundleSupport messages;
    private static final String MESSAGES = "org.pentaho.reporting.engine.classic.core.modules.gui.print.messages.messages";

    public PageSetupDialog(GuiContext guiContext) {
        this.init(guiContext);
    }

    public PageSetupDialog(GuiContext guiContext, Frame owner) {
        super(owner);
        this.init(guiContext);
    }

    public PageSetupDialog(GuiContext guiContext, Dialog owner) {
        super(owner);
        this.init(guiContext);
    }

    protected void init(GuiContext guiContext) {
        this.messages = new ResourceBundleSupport(Locale.getDefault(), MESSAGES, ObjectUtilities.getClassLoader(PageSetupDialog.class));
        this.guiContext = guiContext;
        RevalidateListener revalidateListener = new RevalidateListener();
        this.previewPane = new PageFormatPreviewPane();
        this.pageFormatBox = new JComboBox<String>(new DefaultComboBoxModel<String>(PageFormatFactory.getInstance().getPageFormats()));
        this.pageHeightField = new JTextField();
        this.pageHeightField.setColumns(5);
        this.pageHeightField.getDocument().addDocumentListener(revalidateListener);
        this.pageWidthField = new JTextField();
        this.pageWidthField.setColumns(5);
        this.pageWidthField.getDocument().addDocumentListener(revalidateListener);
        this.landscapeModeBox = new JCheckBox();
        this.landscapeModeBox.addActionListener(new OrientationChangeListener());
        this.portraitModeBox = new JCheckBox();
        this.portraitModeBox.addActionListener(new OrientationChangeListener());
        this.preDefinedPageSizeBox = new JCheckBox();
        this.preDefinedPageSizeBox.addChangeListener(new PageSizeCheckBoxSelectionAction());
        this.userDefinedPageSizeBox = new JCheckBox();
        this.userDefinedPageSizeBox.addChangeListener(new PageSizeCheckBoxSelectionAction());
        ButtonGroup pageSizeGroup = new ButtonGroup();
        pageSizeGroup.add(this.preDefinedPageSizeBox);
        pageSizeGroup.add(this.userDefinedPageSizeBox);
        this.spanHorizontalField = new JTextField();
        this.spanHorizontalField.setColumns(5);
        this.spanHorizontalField.getDocument().addDocumentListener(revalidateListener);
        this.spanVerticalField = new JTextField();
        this.spanVerticalField.setColumns(5);
        this.spanVerticalField.getDocument().addDocumentListener(revalidateListener);
        this.marginTopField = new JTextField();
        this.marginTopField.setColumns(5);
        this.marginTopField.getDocument().addDocumentListener(revalidateListener);
        this.marginLeftField = new JTextField();
        this.marginLeftField.setColumns(5);
        this.marginLeftField.getDocument().addDocumentListener(revalidateListener);
        this.marginBottomField = new JTextField();
        this.marginBottomField.setColumns(5);
        this.marginBottomField.getDocument().addDocumentListener(revalidateListener);
        this.marginRightField = new JTextField();
        this.marginRightField.setColumns(5);
        this.marginRightField.getDocument().addDocumentListener(revalidateListener);
        ButtonGroup orientationGroup = new ButtonGroup();
        orientationGroup.add(this.portraitModeBox);
        orientationGroup.add(this.landscapeModeBox);
        this.pageFormatBox.addActionListener(new PageSizeSelectionAction());
        this.setDefaultCloseOperation(2);
        super.init();
    }

    protected String getDialogId() {
        return "core.PageSetup";
    }

    protected boolean validateInputs(boolean onConfirm) {
        if (this.validateFields()) {
            this.previewPane.setPageDefinition(this.createPageDefinition());
            return true;
        }
        return false;
    }

    private boolean validateFields() {
        try {
            if (ParserUtil.parseFloat((String)this.pageHeightField.getText(), (float)-1.0f) <= 0.0f) {
                return false;
            }
            if (ParserUtil.parseFloat((String)this.pageWidthField.getText(), (float)-1.0f) <= 0.0f) {
                return false;
            }
            if (ParserUtil.parseInt((String)this.spanHorizontalField.getText(), (int)-1) <= 0) {
                return false;
            }
            if (ParserUtil.parseInt((String)this.spanVerticalField.getText(), (int)-1) <= 0) {
                return false;
            }
            if (ParserUtil.parseFloat((String)this.marginTopField.getText(), (float)-1.0f) < 0.0f) {
                return false;
            }
            if (ParserUtil.parseFloat((String)this.marginLeftField.getText(), (float)-1.0f) < 0.0f) {
                return false;
            }
            if (ParserUtil.parseFloat((String)this.marginBottomField.getText(), (float)-1.0f) < 0.0f) {
                return false;
            }
            if (ParserUtil.parseFloat((String)this.marginRightField.getText(), (float)-1.0f) < 0.0f) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private JPanel createOrientationPanel() {
        Icon portraitIcon = this.guiContext.getIconTheme().getLargeIcon(this.getLocale(), "pagesetup.portrait");
        JLabel portraitLabel = new JLabel(this.messages.getString("PageSetupDialog.Portrait"), portraitIcon, 2);
        portraitLabel.setLabelFor(this.portraitModeBox);
        Icon landscapeIcon = this.guiContext.getIconTheme().getLargeIcon(this.getLocale(), "pagesetup.landscape");
        JLabel landscapeLabel = new JLabel(this.messages.getString("PageSetupDialog.Landscape"), landscapeIcon, 2);
        landscapeLabel.setLabelFor(this.landscapeModeBox);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 0));
        contentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.messages.getString("PageSetupDialog.Orientation")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        contentPane.add(this.portraitModeBox);
        contentPane.add(portraitLabel);
        contentPane.add(Box.createHorizontalGlue());
        contentPane.add(this.landscapeModeBox);
        contentPane.add(landscapeLabel);
        contentPane.add(Box.createHorizontalGlue());
        return contentPane;
    }

    private JPanel createPageSpanningPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.messages.getString("PageSetupDialog.PageSpanning")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 10);
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.SheetsAcross")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.SheetsDown")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 50;
        gbc.insets = new Insets(0, 0, 0, 10);
        contentPane.add((Component)this.spanHorizontalField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 50;
        contentPane.add((Component)this.spanVerticalField, gbc);
        return contentPane;
    }

    private JPanel createPageSizePanel() {
        JLabel preDefinedPageSizeLabel = new JLabel(this.messages.getString("PageSetupDialog.Standard"));
        preDefinedPageSizeLabel.setLabelFor(this.preDefinedPageSizeBox);
        JLabel userDefinedPageSizeLabel = new JLabel(this.messages.getString("PageSetupDialog.Custom"));
        userDefinedPageSizeLabel.setLabelFor(this.userDefinedPageSizeBox);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.messages.getString("PageSetupDialog.PageSize")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        contentPane.add((Component)this.preDefinedPageSizeBox, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 4.0;
        contentPane.add((Component)preDefinedPageSizeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        contentPane.add((Component)this.pageFormatBox, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        contentPane.add((Component)this.userDefinedPageSizeBox, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        contentPane.add((Component)userDefinedPageSizeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 3;
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.Width")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 3;
        contentPane.add((Component)this.pageWidthField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 5, 0, 0);
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.Height")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 4;
        gbc.gridy = 3;
        contentPane.add((Component)this.pageHeightField, gbc);
        return contentPane;
    }

    private JPanel createPreviewPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.messages.getString("PageSetupDialog.Preview")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        contentPane.add((Component)this.previewPane, "Center");
        return contentPane;
    }

    private JPanel createMarginsPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.messages.getString("PageSetupDialog.Margins")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.Top")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 1;
        contentPane.add((Component)this.marginTopField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.Left")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 3;
        contentPane.add((Component)this.marginLeftField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.Right")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 3;
        contentPane.add((Component)this.marginRightField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 4;
        contentPane.add((Component)new JLabel(this.messages.getString("PageSetupDialog.Bottom")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 5;
        contentPane.add((Component)this.marginBottomField, gbc);
        return contentPane;
    }

    protected JPanel createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        contentPane.add((Component)this.createOrientationPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        contentPane.add((Component)this.createPageSizePanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        contentPane.add((Component)this.createMarginsPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        contentPane.add((Component)this.createPageSpanningPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        contentPane.add((Component)this.createPreviewPanel(), gbc);
        return contentPane;
    }

    public PageDefinition performSetup(PageDefinition original) {
        if (original instanceof SimplePageDefinition) {
            SimplePageDefinition simplePageDefinition = (SimplePageDefinition)original;
            this.spanHorizontalField.setText(String.valueOf(simplePageDefinition.getPageCountHorizontal()));
            this.spanVerticalField.setText(String.valueOf(simplePageDefinition.getPageCountVertical()));
            PageFormat pageFormat = simplePageDefinition.getPageFormat();
            this.copyPageFormatToFields(pageFormat);
        } else if (original != null) {
            this.spanHorizontalField.setText(null);
            this.spanVerticalField.setText(null);
            if (original.getPageCount() > 0) {
                PageFormat pageFormat = original.getPageFormat(0);
                this.copyPageFormatToFields(pageFormat);
            } else {
                this.preDefinedPageSizeBox.setSelected(true);
                this.pageWidthField.setText(null);
                this.pageHeightField.setText(null);
                this.pageFormatBox.setSelectedItem("A4");
                this.portraitModeBox.setSelected(true);
                this.marginLeftField.setText("18");
                this.marginTopField.setText("18");
                this.marginRightField.setText("18");
                this.marginBottomField.setText("18");
            }
        } else {
            this.spanHorizontalField.setText("1");
            this.spanVerticalField.setText("1");
            this.preDefinedPageSizeBox.setSelected(true);
            this.pageWidthField.setText(null);
            this.pageHeightField.setText(null);
            this.pageFormatBox.setSelectedItem("A4");
            this.portraitModeBox.setSelected(true);
            this.marginLeftField.setText("18");
            this.marginTopField.setText("18");
            this.marginRightField.setText("18");
            this.marginBottomField.setText("18");
        }
        if (!this.performEdit()) {
            return original;
        }
        return this.createPageDefinition();
    }

    private void copyPageFormatToFields(PageFormat pageFormat) {
        Paper paper = pageFormat.getPaper();
        PageFormatFactory pageFormatFactory = PageFormatFactory.getInstance();
        String formatName = pageFormatFactory.getPageFormatName(paper.getWidth(), paper.getHeight());
        this.pageFormatBox.setSelectedItem(formatName);
        this.pageWidthField.setText(String.valueOf(paper.getWidth()));
        this.pageHeightField.setText(String.valueOf(paper.getHeight()));
        this.userDefinedPageSizeBox.setSelected(formatName == null);
        this.preDefinedPageSizeBox.setSelected(formatName != null);
        boolean portraitMode = pageFormat.getOrientation() == 1;
        this.portraitModeBox.setSelected(portraitMode);
        this.landscapeModeBox.setSelected(!portraitMode);
        if (portraitMode) {
            this.marginLeftField.setText(String.valueOf(pageFormatFactory.getLeftBorder(paper)));
            this.marginTopField.setText(String.valueOf(pageFormatFactory.getTopBorder(paper)));
            this.marginRightField.setText(String.valueOf(pageFormatFactory.getRightBorder(paper)));
            this.marginBottomField.setText(String.valueOf(pageFormatFactory.getBottomBorder(paper)));
        } else {
            this.marginTopField.setText(String.valueOf(pageFormatFactory.getLeftBorder(paper)));
            this.marginLeftField.setText(String.valueOf(pageFormatFactory.getBottomBorder(paper)));
            this.marginBottomField.setText(String.valueOf(pageFormatFactory.getRightBorder(paper)));
            this.marginRightField.setText(String.valueOf(pageFormatFactory.getTopBorder(paper)));
        }
    }

    private SimplePageDefinition createPageDefinition() {
        PageFormat pf;
        float pageWidth = ParserUtil.parseFloat((String)this.pageWidthField.getText(), (float)0.0f);
        float pageHeight = ParserUtil.parseFloat((String)this.pageHeightField.getText(), (float)0.0f);
        int spanHorizontal = ParserUtil.parseInt((String)this.spanHorizontalField.getText(), (int)0);
        int spanVertical = ParserUtil.parseInt((String)this.spanVerticalField.getText(), (int)0);
        float marginTop = ParserUtil.parseFloat((String)this.marginTopField.getText(), (float)0.0f);
        float marginLeft = ParserUtil.parseFloat((String)this.marginLeftField.getText(), (float)0.0f);
        float marginBottom = ParserUtil.parseFloat((String)this.marginBottomField.getText(), (float)0.0f);
        float marginRight = ParserUtil.parseFloat((String)this.marginRightField.getText(), (float)0.0f);
        Paper p = PageFormatFactory.getInstance().createPaper(pageWidth, pageHeight);
        if (this.portraitModeBox.isSelected()) {
            PageFormatFactory.getInstance().setBorders(p, marginTop, marginLeft, marginBottom, marginRight);
            pf = PageFormatFactory.getInstance().createPageFormat(p, 1);
        } else {
            PageFormatFactory.getInstance().setBorders(p, marginRight, marginTop, marginLeft, marginBottom);
            pf = PageFormatFactory.getInstance().createPageFormat(p, 0);
        }
        return new SimplePageDefinition(pf, spanHorizontal, spanVertical);
    }

    private class OrientationChangeListener
    implements ActionListener {
        private OrientationChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageSetupDialog.this.validateInputs(false);
        }
    }

    private class PageSizeCheckBoxSelectionAction
    implements ChangeListener {
        private PageSizeCheckBoxSelectionAction() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (PageSetupDialog.this.userDefinedPageSizeBox.isSelected()) {
                PageSetupDialog.this.pageFormatBox.setEnabled(false);
                PageSetupDialog.this.pageWidthField.setEnabled(true);
                PageSetupDialog.this.pageHeightField.setEnabled(true);
            } else {
                PageSetupDialog.this.pageFormatBox.setEnabled(true);
                PageSetupDialog.this.pageWidthField.setEnabled(false);
                PageSetupDialog.this.pageHeightField.setEnabled(false);
            }
        }
    }

    private class RevalidateListener
    implements DocumentListener {
        private RevalidateListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PageSetupDialog.this.validateInputs(false);
        }
    }

    private class PageSizeSelectionAction
    implements ActionListener {
        private PageSizeSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedItem = (String)PageSetupDialog.this.pageFormatBox.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            Paper paper = PageFormatFactory.getInstance().createPaper(selectedItem);
            if (paper == null) {
                return;
            }
            PageSetupDialog.this.pageWidthField.setText(String.valueOf(paper.getWidth()));
            PageSetupDialog.this.pageHeightField.setText(String.valueOf(paper.getHeight()));
        }
    }
}

