/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.AbstractExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.EncodingComboBoxModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class HtmlZipExportDialog
extends AbstractExportDialog {
    public static final String HTML_OUTPUT_ENCODING = "org.pentaho.reporting.engine.classic.core.modules.output.table.html.Encoding";
    public static final String HTML_OUTPUT_ENCODING_DEFAULT = "UTF-16";
    private JTextField txFilename;
    private JTextField txDataFilename;
    private JTextField txTitle;
    private JTextField txAuthor;
    private JComboBox cbEncoding;
    private EncodingComboBoxModel encodingModel;
    private JCheckBox cbxStrictLayout;
    private JCheckBox cbxCopyExternalReferences;
    private JFileChooser fileChooserZip;
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private JStatusBar statusBar;
    private JTextField txKeywords;
    private JTextField txDescription;

    public HtmlZipExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public HtmlZipExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public HtmlZipExportDialog() {
        this.initConstructor();
    }

    private void initConstructor() {
        this.statusBar = new JStatusBar();
        this.setTitle(this.getResources().getString("htmlexportdialog.dialogtitle"));
        this.initialize();
        this.clear();
    }

    @Override
    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    private JPanel createExportPanel() {
        JLabel lblDirFileName = new JLabel(this.getResources().getString("htmlexportdialog.filename"));
        JLabel lblDirDataFileName = new JLabel(this.getResources().getString("htmlexportdialog.datafilename"));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)lblDirFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 1;
        contentPane.add((Component)new JButton(new ActionSelectDirFile(this.getResources())), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)lblDirDataFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txDataFilename, gbc);
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new BorderLayout());
        advancedOptionsPane.add((Component)contentPane, "North");
        return advancedOptionsPane;
    }

    private JPanel createExportOptionsPanel() {
        JLabel lblEncoding = new JLabel(this.getResources().getString("htmlexportdialog.encoding"));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbxCopyExternalReferences, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbxStrictLayout, gbc);
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new BorderLayout());
        advancedOptionsPane.add((Component)contentPane, "North");
        return advancedOptionsPane;
    }

    private JPanel createMetaDataPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        JLabel lblAuthor = new JLabel(this.getResources().getString("htmlexportdialog.author"));
        JLabel lblTitel = new JLabel(this.getResources().getString("htmlexportdialog.title"));
        JLabel lblKeywords = new JLabel(this.getResources().getString("htmlexportdialog.keywords"));
        JLabel lblDescription = new JLabel(this.getResources().getString("htmlexportdialog.description"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)lblTitel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblAuthor, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblKeywords, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblDescription, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txTitle, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txAuthor, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txKeywords, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txDescription, gbc);
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new BorderLayout());
        advancedOptionsPane.add((Component)contentPane, "North");
        return advancedOptionsPane;
    }

    private void initialize() {
        this.txAuthor = new JTextField();
        this.txAuthor.setColumns(40);
        this.txTitle = new JTextField();
        this.txTitle.setColumns(40);
        this.txKeywords = new JTextField();
        this.txKeywords.setColumns(40);
        this.txDescription = new JTextField();
        this.txDescription.setColumns(40);
        this.txFilename = new JTextField();
        this.txFilename.setColumns(40);
        this.txDataFilename = new JTextField();
        this.txDataFilename.setColumns(40);
        this.encodingModel = EncodingComboBoxModel.createDefaultModel(Locale.getDefault());
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        this.cbxStrictLayout = new JCheckBox(this.getResources().getString("htmlexportdialog.strict-layout"));
        this.cbxCopyExternalReferences = new JCheckBox(this.getResources().getString("htmlexportdialog.copy-external-references"));
        this.getFormValidator().registerButton(this.cbxStrictLayout);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerTextField(this.txDataFilename);
        this.getFormValidator().registerComboBox(this.cbEncoding);
        JPanel exportPane = this.createExportPanel();
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        boolean advancedSettingsTabAvail = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.AdvancedSettingsAvailable"));
        boolean metaDataSettingsTabAvail = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.MetaDataSettingsAvailable"));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(this.getResources().getString("htmlexportdialog.export-settings"), exportPane);
        tabbedPane.add(this.getResources().getString("htmlexportdialog.parameters"), this.getParametersPanel());
        if (metaDataSettingsTabAvail) {
            tabbedPane.add(this.getResources().getString("htmlexportdialog.metadata-settings"), this.createMetaDataPanel());
        }
        if (advancedSettingsTabAvail) {
            tabbedPane.add(this.getResources().getString("htmlexportdialog.advanced-settings"), this.createExportOptionsPanel());
        }
        this.setContentPane(this.createContentPane(tabbedPane));
    }

    public String getHTMLTitle() {
        return this.txTitle.getText();
    }

    public void setHTMLTitle(String title) {
        this.txTitle.setText(title);
    }

    public String getAuthor() {
        return this.txAuthor.getText();
    }

    public void setAuthor(String author) {
        this.txAuthor.setText(author);
    }

    public void setKeywords(String keywords) {
        this.txKeywords.setText(keywords);
    }

    public String getKeywords() {
        return this.txKeywords.getText();
    }

    public void setDescription(String description) {
        this.txDescription.setText(description);
    }

    public String getDescription() {
        return this.txDescription.getText();
    }

    @Override
    public void clear() {
        this.txAuthor.setText(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("user.name", ""));
        this.txFilename.setText("");
        this.txDataFilename.setText("");
        this.txTitle.setText("");
        this.txKeywords.setText("");
        this.txDescription.setText("");
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(EncodingRegistry.getPlatformDefaultEncoding()));
        this.cbxCopyExternalReferences.setSelected(false);
        this.cbxStrictLayout.setSelected(false);
    }

    @Override
    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration p = new DefaultConfiguration();
        if (full) {
            p.setProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.ExportMethod", "zip");
            p.setProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.DataDirectory", this.getDataFilename());
            p.setProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.TargetFileName", this.getFilename());
        }
        p.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Keywords", this.getKeywords());
        p.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Description", this.getDescription());
        p.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Author", this.getAuthor());
        p.setConfigProperty(HTML_OUTPUT_ENCODING, this.getEncoding());
        p.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Title", this.getHTMLTitle());
        p.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.StrictLayout", String.valueOf(this.isStrictLayout()));
        return p;
    }

    @Override
    protected void setDialogContents(Configuration p) {
        this.setHTMLTitle(p.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Title", p.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Title")));
        this.setAuthor(p.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Author", p.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Author")));
        this.setKeywords(p.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Keywords", p.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Keywords")));
        this.setDescription(p.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Description", p.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Description")));
        this.setStrictLayout("true".equals(p.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.StrictLayout")));
        String encoding = p.getConfigProperty(HTML_OUTPUT_ENCODING, EncodingRegistry.getPlatformDefaultEncoding());
        this.encodingModel.ensureEncodingAvailable(encoding);
        this.setEncoding(encoding);
        this.setDataFilename(p.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.DataDirectory", ""));
        this.setFilename(p.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.TargetFileName", ""));
    }

    public String getDataFilename() {
        return this.txDataFilename.getText();
    }

    public void setDataFilename(String dirFilename) {
        this.txDataFilename.setText(dirFilename);
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public void setFilename(String dirFilename) {
        this.txFilename.setText(dirFilename);
    }

    public boolean isStrictLayout() {
        return this.cbxStrictLayout.isSelected();
    }

    public void setStrictLayout(boolean s) {
        this.cbxStrictLayout.setSelected(s);
    }

    public String getEncoding() {
        if (this.cbEncoding.getSelectedIndex() == -1) {
            return EncodingRegistry.getPlatformDefaultEncoding();
        }
        return this.encodingModel.getEncoding(this.cbEncoding.getSelectedIndex());
    }

    public void setEncoding(String encoding) {
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(encoding));
    }

    protected void performSelectFileZip() {
        File file = new File(this.getFilename());
        if (this.fileChooserZip == null) {
            this.fileChooserZip = new JFileChooser();
            this.fileChooserZip.addChoosableFileFilter((FileFilter)new FilesystemFilter(new String[]{ZIP_FILE_EXTENSION, JAR_FILE_EXTENSION}, this.getResources().getString("htmlexportdialog.zip-archives"), true));
            this.fileChooserZip.setMultiSelectionEnabled(false);
        }
        this.fileChooserZip.setCurrentDirectory(file);
        this.fileChooserZip.setSelectedFile(file);
        int option = this.fileChooserZip.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooserZip.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)ZIP_FILE_EXTENSION)) {
                selFileName = selFileName + ZIP_FILE_EXTENSION;
            }
            this.setFilename(selFileName);
        }
    }

    @Override
    public boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("htmlexportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("htmlexportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("htmlexportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("htmlexportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(StatusType.WARNING, message);
        }
        try {
            File dataDir = new File(this.getDataFilename());
            File baseDir = new File("");
            if (!IOUtils.getInstance().isSubDirectory(baseDir, dataDir)) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("htmlexportdialog.targetPathIsAbsolute"));
                return false;
            }
        }
        catch (Exception e) {
            this.getStatusBar().setStatus(StatusType.ERROR, "error.validationfailed");
            return false;
        }
        return true;
    }

    @Override
    protected boolean performConfirm() {
        String filename = this.getFilename();
        File f = new File(filename).getAbsoluteFile();
        if (f.exists()) {
            String key1 = "htmlexportdialog.targetOverwriteConfirmation";
            String key2 = "htmlexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("htmlexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("htmlexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getConfigurationSuffix() {
        return "_html-zip-export";
    }

    @Override
    protected String getResourceBaseName() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages";
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.";
    }

    private class ActionSelectDirFile
    extends AbstractAction {
        protected ActionSelectDirFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("htmlexportdialog.selectFile"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HtmlZipExportDialog.this.performSelectFileZip();
        }
    }
}

