/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.DefaultIconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportEventSource;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class AbstractGuiContext
implements SwingGuiContext,
StatusListener,
ReportEventSource {
    public static final String STATUS_TYPE_PROPERTY = "statusType";
    public static final String STATUS_TEXT_PROPERTY = "statusText";
    public static final String ERROR_PROPERTY = "error";
    private IconTheme iconTheme = new DefaultIconTheme();
    private StatusType statusType;
    private String statusText;
    private Throwable error;
    private int pageNumber;
    private int numberOfPages;
    private boolean paginating;
    private boolean paginated;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected AbstractGuiContext() {
    }

    @Override
    public abstract Window getWindow();

    @Override
    public Locale getLocale() {
        MasterReport report = this.getReportJob();
        if (report != null) {
            Locale bundleLocale = report.getResourceBundleFactory().getLocale();
            if (bundleLocale != null) {
                return bundleLocale;
            }
            return report.getReportEnvironment().getLocale();
        }
        return Locale.getDefault();
    }

    @Override
    public IconTheme getIconTheme() {
        return this.iconTheme;
    }

    @Override
    public Configuration getConfiguration() {
        MasterReport report = this.getReportJob();
        if (report != null) {
            return report.getConfiguration();
        }
        return ClassicEngineBoot.getInstance().getGlobalConfig();
    }

    @Override
    public StatusListener getStatusListener() {
        return this;
    }

    @Override
    public void setStatus(StatusType type, String text, Throwable cause) {
        StatusType oldStatusType = this.statusType;
        String oldStatusText = this.statusText;
        Throwable oldError = this.error;
        this.statusType = type;
        this.statusText = text;
        this.error = cause;
        this.propertyChangeSupport.firePropertyChange(STATUS_TYPE_PROPERTY, oldStatusType, this.statusType);
        this.propertyChangeSupport.firePropertyChange(STATUS_TEXT_PROPERTY, oldStatusText, this.statusText);
        this.propertyChangeSupport.firePropertyChange(ERROR_PROPERTY, oldError, this.error);
    }

    public Throwable getError() {
        return this.error;
    }

    public StatusType getStatusType() {
        return this.statusType;
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public ReportEventSource getEventSource() {
        return this;
    }

    public void setPageNumber(int pageNumber) {
        int oldPageNumber = this.pageNumber;
        this.pageNumber = pageNumber;
        this.propertyChangeSupport.firePropertyChange("pageNumber", oldPageNumber, this.numberOfPages);
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setNumberOfPages(int numberOfPages) {
        int oldNumberOfPages = this.numberOfPages;
        this.numberOfPages = numberOfPages;
        this.propertyChangeSupport.firePropertyChange("numberOfPages", oldNumberOfPages, numberOfPages);
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setPaginating(boolean paginating) {
        boolean oldPginating = this.paginating;
        this.paginating = paginating;
        this.propertyChangeSupport.firePropertyChange("paginating", oldPginating, paginating);
    }

    @Override
    public boolean isPaginating() {
        return this.paginating;
    }

    public void setPaginated(boolean paginated) {
        boolean oldPaginated = this.paginated;
        this.paginated = paginated;
        this.propertyChangeSupport.firePropertyChange("paginated", oldPaginated, paginated);
    }

    @Override
    public boolean isPaginated() {
        return this.paginated;
    }

    @Override
    public abstract MasterReport getReportJob();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property, propertyChangeListener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

