/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters;

import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ParameterReportControllerPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterUpdateContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.TextComponentEditHandler;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;

public class TextAreaParameterComponent
extends JScrollPane
implements ParameterComponent {
    private ParameterUpdateContext updateContext;
    private String parameterName;
    private JTextArea textArea;
    private TextComponentEditHandler handler;
    private Format format;

    public TextAreaParameterComponent(ParameterDefinitionEntry entry, ParameterContext parameterContext, ParameterUpdateContext updateContext) {
        this.updateContext = updateContext;
        String formatString = entry.getTranslatedParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", parameterContext);
        String timeZoneSpec = entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", parameterContext);
        Locale locale = parameterContext.getResourceBundleFactory().getLocale();
        TimeZone timeZone = TextComponentEditHandler.createTimeZone(timeZoneSpec, parameterContext.getResourceBundleFactory().getTimeZone());
        this.textArea = new JTextArea();
        this.format = TextComponentEditHandler.createFormat(formatString, locale, timeZone, entry.getValueType());
        this.handler = new TextComponentEditHandler(entry.getValueType(), entry.getName(), this.textArea, updateContext, this.format);
        this.textArea.getDocument().addDocumentListener(this.handler);
        this.textArea.setColumns(60);
        this.textArea.setRows(10);
        this.setViewportView(this.textArea);
        this.parameterName = entry.getName();
        updateContext.addChangeListener(new TextUpdateHandler());
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void initialize() {
        block7: {
            this.handler.setAdjustingToExternalInput(true);
            try {
                Object value = this.updateContext.getParameterValue(this.parameterName);
                if (value != null) {
                    try {
                        if (this.format != null) {
                            this.textArea.setText(this.format.format(value));
                            break block7;
                        }
                        this.textArea.setText(ConverterRegistry.toAttributeValue(value));
                    }
                    catch (Exception e) {
                        this.textArea.setText(value.toString());
                        this.setBackground(ParameterReportControllerPane.ERROR_COLOR);
                    }
                    break block7;
                }
                this.textArea.setText(null);
            }
            finally {
                this.handler.setAdjustingToExternalInput(false);
            }
        }
    }

    private class TextUpdateHandler
    implements ChangeListener {
        private TextUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TextAreaParameterComponent.this.initialize();
        }
    }
}

