/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.beans.PropertyEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeCore;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.builder.AttributeMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeDefinition;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeReadHandler
extends AbstractMetaDataReadHandler {
    private static final Log logger = LogFactory.getLog(AttributeReadHandler.class);
    private AttributeMetaDataBuilder builder;
    private String prefix;

    public AttributeReadHandler(String defaultBundle, String prefix) {
        super(defaultBundle);
        this.prefix = prefix;
        this.builder = new AttributeMetaDataBuilder();
    }

    public AttributeMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.getBuilder().namespace(this.parseNamespace(attrs));
        this.getBuilder().namespacePrefix(this.parseNamespacePrefix(attrs));
        this.getBuilder().mandatory("true".equals(attrs.getValue(this.getUri(), "mandatory")));
        this.getBuilder().computed("true".equals(attrs.getValue(this.getUri(), "computed")));
        this.getBuilder().transientFlag("true".equals(attrs.getValue(this.getUri(), "transient")));
        this.getBuilder().bulk("true".equals(attrs.getValue(this.getUri(), "prefer-bulk")));
        this.getBuilder().designTime("true".equals(attrs.getValue(this.getUri(), "design-time-value")));
        this.getBuilder().targetClass(this.parseValueType(attrs));
        this.getBuilder().valueRole(this.parseValueRole(attrs));
        this.getBuilder().propertyEditor(ObjectUtilities.loadAndValidate((String)attrs.getValue(this.getUri(), "propertyEditor"), AttributeReadHandler.class, PropertyEditor.class));
        this.getBuilder().core(this.parseAttributeCore(attrs));
        this.getBuilder().bundle(this.getBundle(), this.computePrefix());
    }

    private String computePrefix() {
        String namespace = this.getNamespace();
        String attrName = this.getName();
        String namespacePrefix = ElementTypeRegistry.getInstance().getNamespacePrefix(namespace);
        if (namespacePrefix == null) {
            logger.warn((Object)("Invalid namespace-prefix, skipping attribute " + namespace + ':' + attrName));
            return null;
        }
        return this.prefix + "attribute." + namespacePrefix + '.';
    }

    private AttributeCore parseAttributeCore(Attributes attrs) throws ParseException {
        AttributeCore attributeCore;
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            attributeCore = (AttributeCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, AttributeReadHandler.class, AttributeCore.class);
            if (attributeCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid AttributeCore implementation.", this.getLocator());
            }
        } else {
            attributeCore = new DefaultAttributeCore();
        }
        return attributeCore;
    }

    private String parseValueRole(Attributes attrs) {
        String valueRole = attrs.getValue(this.getUri(), "value-role");
        if (valueRole == null) {
            valueRole = "Value";
        }
        return valueRole;
    }

    private Class<?> parseValueType(Attributes attrs) throws ParseException {
        String valueTypeText = attrs.getValue(this.getUri(), "value-type");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'value-type' is undefined", this.getLocator());
        }
        try {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass());
            return Class.forName(valueTypeText, false, classLoader);
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'value-type' is not valid", e, this.getLocator());
        }
    }

    private String parseNamespace(Attributes attrs) throws ParseException {
        String namespace = attrs.getValue(this.getUri(), "namespace");
        if (namespace == null) {
            throw new ParseException("Attribute 'namespace' is undefined", this.getLocator());
        }
        return namespace;
    }

    private String parseNamespacePrefix(Attributes attrs) throws ParseException {
        String namespacePrefix = attrs.getValue(this.getUri(), "namespace-prefix");
        if (namespacePrefix == null) {
            namespacePrefix = ElementTypeRegistry.getInstance().getNamespacePrefix(this.parseNamespace(attrs));
        }
        return namespacePrefix;
    }

    public AttributeCore getAttributeCore() {
        return this.getBuilder().getCore();
    }

    public String getPropertyEditor() {
        return this.getBuilder().getPropertyEditor().getName();
    }

    public String getNamespace() {
        return this.getBuilder().getNamespace();
    }

    public boolean isMandatory() {
        return this.getBuilder().isMandatory();
    }

    public boolean isComputed() {
        return this.getBuilder().isComputed();
    }

    public boolean isTransient() {
        return this.getBuilder().isTransientFlag();
    }

    public Class<?> getValueType() {
        return this.getBuilder().getTargetClass();
    }

    public boolean isBulk() {
        return this.getBuilder().isBulk();
    }

    public String getValueRole() {
        return this.getBuilder().getValueRole();
    }

    public AttributeDefinition getObject() throws SAXException {
        return new AttributeDefinition(this.getBuilder());
    }

    public AttributeMetaData getMetaData() {
        return new DefaultAttributeMetaData(this.getBuilder());
    }
}

