/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ElementMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class DefaultElementMetaData
extends AbstractMetaData
implements ElementMetaData {
    private static final Log logger = LogFactory.getLog(DefaultElementMetaData.class);
    private transient AttributeMetaData[] attributesAsArray;
    private transient StyleMetaData[] stylesArray;
    private AttributeMap<AttributeMetaData> attributes;
    private Map<StyleKey, StyleMetaData> styles;
    private Class<? extends ElementType> elementType;
    private ElementMetaData.TypeClassification reportElementType;
    private Class<?> contentType;
    private String namespace;

    public DefaultElementMetaData(String name, String bundleLocation, String keyPrefix, String namespace, boolean expert, boolean preferred, boolean hidden, boolean deprecated, ElementMetaData.TypeClassification reportElementType, AttributeMap<AttributeMetaData> attributes, Map<StyleKey, StyleMetaData> styles, Class<? extends ElementType> elementType, Class<?> contentType, MaturityLevel maturityLevel, int compatibilityLevel) {
        super(name, bundleLocation, keyPrefix, expert, preferred, hidden, deprecated, maturityLevel, compatibilityLevel);
        if (styles == null) {
            throw new NullPointerException();
        }
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (elementType == null) {
            throw new NullPointerException();
        }
        if (contentType == null) {
            throw new NullPointerException();
        }
        if (namespace == null) {
            throw new NullPointerException();
        }
        this.contentType = contentType;
        this.reportElementType = reportElementType;
        this.attributes = attributes.clone();
        this.styles = new HashMap<StyleKey, StyleMetaData>(styles);
        this.elementType = elementType;
        this.namespace = namespace;
    }

    public DefaultElementMetaData(ElementMetaDataBuilder builder) {
        super(builder);
        this.contentType = builder.getContentType();
        this.reportElementType = builder.getReportElementType();
        this.attributes = builder.getAttributes();
        this.styles = builder.getStyles();
        this.elementType = builder.getElementType();
        this.namespace = builder.getNamespace();
        if (this.namespace == null) {
            throw new IllegalArgumentException();
        }
    }

    public DefaultElementMetaData(ElementMetaData metaData) {
        super(metaData);
        this.contentType = metaData.getContentType();
        this.reportElementType = metaData.getReportElementType();
        this.elementType = metaData.getElementType();
        this.namespace = metaData.getNamespace();
        if (this.namespace == null) {
            throw new IllegalArgumentException();
        }
        this.styles = new HashMap<StyleKey, StyleMetaData>();
        StyleMetaData[] styleDescriptions = metaData.getStyleDescriptions();
        for (int i = 0; i < styleDescriptions.length; ++i) {
            StyleMetaData styleMetaData = styleDescriptions[i];
            this.styles.put(styleMetaData.getStyleKey(), styleMetaData);
        }
        this.attributes = new AttributeMap();
        AttributeMetaData[] attributeDescriptions = metaData.getAttributeDescriptions();
        for (int i = 0; i < attributeDescriptions.length; ++i) {
            AttributeMetaData attributeDescription = attributeDescriptions[i];
            this.attributes.setAttribute(attributeDescription.getNameSpace(), attributeDescription.getName(), (Object)attributeDescription);
        }
    }

    @Override
    public AttributeMetaData[] getAttributeDescriptions() {
        if (this.attributesAsArray == null) {
            ArrayList<AttributeMetaData> buffer = new ArrayList<AttributeMetaData>();
            String[] namespaces = this.attributes.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                Map attrsNs = this.attributes.getAttributes(namespace);
                for (Map.Entry entry : attrsNs.entrySet()) {
                    AttributeMetaData exp = (AttributeMetaData)entry.getValue();
                    buffer.add(exp);
                }
            }
            this.attributesAsArray = buffer.toArray(new AttributeMetaData[buffer.size()]);
        }
        return (AttributeMetaData[])this.attributesAsArray.clone();
    }

    @Override
    public StyleMetaData[] getStyleDescriptions() {
        if (this.stylesArray == null) {
            this.stylesArray = this.styles.values().toArray(new StyleMetaData[this.styles.size()]);
        }
        return this.stylesArray;
    }

    @Override
    public AttributeMetaData getAttributeDescription(String namespace, String name) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        AttributeMetaData attribute = (AttributeMetaData)this.attributes.getAttribute(namespace, name);
        if (attribute == null && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("No metadata defined for attribute [%s:%s] on element-type %s", namespace, name, this.getName()));
        }
        return attribute;
    }

    public void setAttributeDescription(String namespace, String name, AttributeMetaData metaData) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.attributes.setAttribute(namespace, name, (Object)metaData);
    }

    @Override
    public StyleMetaData getStyleDescription(StyleKey name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.styles.get(name);
    }

    @Override
    public ElementType create() throws InstantiationException {
        try {
            return this.elementType.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Unable to instantiate " + this.elementType + ": IllegalAccessException caught");
        }
    }

    @Override
    public boolean isContainerElement() {
        return this.reportElementType != ElementMetaData.TypeClassification.DATA;
    }

    @Override
    public ElementMetaData.TypeClassification getReportElementType() {
        return this.reportElementType;
    }

    @Override
    public Class<?> getContentType() {
        return this.contentType;
    }

    @Override
    public Class<? extends ElementType> getElementType() {
        return this.elementType;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }
}

