/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.text;

import org.pentaho.reporting.engine.classic.core.layout.text.DefaultExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class TextUtility {
    private TextUtility() {
    }

    private static int translateBaselines(int baseline) {
        switch (baseline) {
            case 0: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 2: {
                return 3;
            }
            case 5: {
                return 7;
            }
            case 1: {
                return 5;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid baseline");
    }

    public static ExtendedBaselineInfo createBaselineInfo(int codepoint, FontMetrics fontMetrics, BaselineInfo reusableBaselineInfo) {
        if (fontMetrics == null) {
            throw new NullPointerException("FontMetrics cannot be null");
        }
        BaselineInfo baselineInfo = fontMetrics.getBaselines(codepoint, reusableBaselineInfo);
        int dominantBaseline = TextUtility.translateBaselines(baselineInfo.getDominantBaseline());
        long underlinePosition = fontMetrics.getUnderlinePosition();
        long strikeThroughPosition = fontMetrics.getStrikeThroughPosition();
        return new DefaultExtendedBaselineInfo(dominantBaseline, baselineInfo, 0L, 0L, fontMetrics.getMaxHeight(), fontMetrics.getMaxHeight(), underlinePosition, strikeThroughPosition);
    }

    public static ExtendedBaselineInfo createPaddedBaselineInfo(int codepoint, FontMetrics fontMetrics, BaselineInfo reusableBaselineInfo) {
        if (fontMetrics == null) {
            throw new NullPointerException("FontMetrics cannot be null");
        }
        BaselineInfo baselineInfo = fontMetrics.getBaselines(codepoint, reusableBaselineInfo);
        int dominantBaseline = TextUtility.translateBaselines(baselineInfo.getDominantBaseline());
        long underlinePosition = fontMetrics.getUnderlinePosition();
        long strikeThroughPosition = fontMetrics.getStrikeThroughPosition();
        long fontSize = fontMetrics.getMaxHeight();
        long threshold = (long)((double)fontSize * 1.005);
        long safeFontSize = (long)((double)fontSize * 1.3);
        if (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() < threshold) {
            return new DefaultExtendedBaselineInfo(dominantBaseline, baselineInfo, 0L, 0L, safeFontSize, safeFontSize, underlinePosition, strikeThroughPosition);
        }
        return new DefaultExtendedBaselineInfo(dominantBaseline, baselineInfo, 0L, 0L, fontSize, fontSize, underlinePosition, strikeThroughPosition);
    }
}

