/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticChunkWidthUpdate;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticChunkWidthUpdatePool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticRootChunkWidthUpdate;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public final class ComputeStaticPropertiesProcessStep
extends IterateSimpleStructureProcessStep {
    public static final long MAX_AUTO = StrictGeomUtility.toInternalValue(8.796093022208E12);
    private static final StaticRootChunkWidthUpdate ROOT = new StaticRootChunkWidthUpdate();
    private OutputProcessorMetaData metaData;
    private ResourceManager resourceManager;
    private boolean overflowXSupported;
    private boolean overflowYSupported;
    private boolean widowsEnabled;
    private StaticChunkWidthUpdate chunkWidthUpdate;
    private StaticChunkWidthUpdatePool chunkWidthUpdatePool = new StaticChunkWidthUpdatePool();
    private boolean widowOrphanDefinitionsEncountered;
    private boolean designTime;

    public void initialize(OutputProcessorMetaData metaData, ProcessingContext processingContext) {
        this.metaData = metaData;
        this.overflowXSupported = metaData.isFeatureSupported(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        this.overflowYSupported = metaData.isFeatureSupported(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        this.widowsEnabled = !ClassicEngineBoot.isEnforceCompatibilityFor(processingContext.getCompatibilityLevel(), 3, 8);
        this.widowOrphanDefinitionsEncountered = false;
        this.designTime = metaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
        this.resourceManager = processingContext.getResourceManager();
    }

    public boolean isWidowOrphanDefinitionsEncountered() {
        return this.widowOrphanDefinitionsEncountered;
    }

    public void compute(LogicalPageBox root) {
        this.chunkWidthUpdate = ROOT;
        this.startProcessing(root);
        this.chunkWidthUpdate = null;
    }

    @Override
    protected boolean startBox(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            return false;
        }
        this.chunkWidthUpdate = this.createChunkWidthUpdate(box);
        this.updateStaticProperties(box);
        this.computeWidowOrphanIndicator(box);
        if (box.getNodeType() == 274) {
            this.processParagraphChilds((ParagraphRenderBox)box);
            return false;
        }
        return true;
    }

    @Override
    protected void finishBox(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            return;
        }
        this.updateMinimumChunkWidth(box);
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        if (node instanceof RenderableComplexText) {
            RenderableComplexText t = (RenderableComplexText)node;
            t.computeMinimumChunkWidth(this.metaData, this.resourceManager);
        }
        this.chunkWidthUpdate.update(node.getMinimumChunkWidth());
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        ExtendedBaselineInfo extendedBaselineInfo = box.getStaticBoxLayoutProperties().getNominalBaselineInfo();
        if (extendedBaselineInfo == null) {
            throw new IllegalStateException("Baseline info must not be null at this point");
        }
        StyleSheet styleSheet = box.getNodeLayoutProperties().getStyleSheet();
        double value = styleSheet.getDoubleStyleProperty(TextStyleKeys.LINEHEIGHT, 0.0);
        long afterEdge = extendedBaselineInfo.getBaseline(9);
        if (value <= 0.0) {
            box.getPool().setLineHeight(afterEdge);
        } else {
            box.getPool().setLineHeight(RenderLength.resolveLength(afterEdge, value));
        }
        this.startProcessing(box.getPool());
    }

    private void computeBreakIndicator(RenderBox box) {
        boolean fixedPosition;
        StyleSheet styleSheet = box.getStyleSheet();
        RenderBox parent = box.getParent();
        if (parent != null) {
            boolean breakBefore = styleSheet.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE);
            boolean breakAfter = box.isBreakAfter();
            int nodeType = parent.getLayoutNodeType();
            if (breakBefore && nodeType != 274) {
                box.setManualBreakIndicator(RenderBox.BreakIndicator.DIRECT_MANUAL_BREAK);
                this.applyIndirectManualBreakIndicator(parent);
                return;
            }
            if (breakAfter && nodeType != 274) {
                this.applyIndirectManualBreakIndicator(parent);
            }
        }
        boolean bl = fixedPosition = !RenderLength.AUTO.equals(styleSheet.getStyleProperty(BandStyleKeys.FIXED_POSITION, RenderLength.AUTO));
        if (fixedPosition) {
            this.applyIndirectManualBreakIndicator(box);
        } else {
            box.setManualBreakIndicator(RenderBox.BreakIndicator.NO_MANUAL_BREAK);
        }
    }

    private void applyIndirectManualBreakIndicator(RenderBox node) {
        while (node != null) {
            if (node.getManualBreakIndicator() != RenderBox.BreakIndicator.NO_MANUAL_BREAK) {
                return;
            }
            node.setManualBreakIndicator(RenderBox.BreakIndicator.INDIRECT_MANUAL_BREAK);
            node = node.getParent();
        }
    }

    private void updateStaticProperties(RenderBox box) {
        BoxDefinition boxDefinition = box.getBoxDefinition();
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        if (sblp.isBaselineCalculated()) {
            return;
        }
        this.computeMarginsAndBorders(box, boxDefinition, sblp);
        this.computeResolvedStyleProperties(box, sblp);
        this.computeBreakIndicator(box);
    }

    private void computeWidowOrphanIndicator(RenderBox box) {
        RenderBox parent = box.getParent();
        if (parent == null) {
            box.setParentWidowContexts(0);
            return;
        }
        if (!this.widowsEnabled) {
            return;
        }
        StaticBoxLayoutProperties sblp = parent.getStaticBoxLayoutProperties();
        if (sblp.getOrphans() > 0 || sblp.getWidows() > 0 || sblp.isAvoidPagebreakInside()) {
            this.widowOrphanDefinitionsEncountered = true;
            box.setParentWidowContexts(parent.getParentWidowContexts() + 1);
        } else {
            box.setParentWidowContexts(parent.getParentWidowContexts());
        }
    }

    private void computeResolvedStyleProperties(RenderBox box, StaticBoxLayoutProperties sblp) {
        ExtendedBaselineInfo baselineInfo;
        int nodeType;
        StyleSheet style = box.getStyleSheet();
        NodeLayoutProperties nlp = box.getNodeLayoutProperties();
        if (this.designTime) {
            RenderBox parent = box.getParent();
            if (parent == null) {
                nlp.setVisible(style.getBooleanStyleProperty(ElementStyleKeys.VISIBLE));
            } else if (!parent.isEmptyNodesHaveSignificance()) {
                nlp.setVisible(style.getBooleanStyleProperty(ElementStyleKeys.VISIBLE));
            }
        }
        if (((nodeType = box.getLayoutNodeType()) & 0x42) == 66) {
            sblp.setAvoidPagebreakInside(true);
        } else if (nodeType == 278530 || nodeType == 130) {
            sblp.setAvoidPagebreakInside(style.getBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE, true));
        } else {
            sblp.setAvoidPagebreakInside(style.getBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE, false));
        }
        sblp.setDominantBaseline(-1);
        if (this.widowsEnabled) {
            sblp.setOrphans(style.getIntStyleProperty(ElementStyleKeys.ORPHANS, 0));
            sblp.setWidows(style.getIntStyleProperty(ElementStyleKeys.WIDOWS, 0));
            boolean orphanOptOut = style.getBooleanStyleProperty(ElementStyleKeys.WIDOW_ORPHAN_OPT_OUT, true);
            sblp.setWidowOrphanOptOut(orphanOptOut);
        }
        if ((baselineInfo = this.metaData.getBaselineInfo(120, style)) == null) {
            throw new IllegalStateException();
        }
        sblp.setNominalBaselineInfo(baselineInfo);
        sblp.setFontFamily(this.metaData.getNormalizedFontFamilyName((String)style.getStyleProperty(TextStyleKeys.FONT)));
        Object collapse = style.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        sblp.setPreserveSpace(WhitespaceCollapse.PRESERVE.equals(collapse));
        sblp.setOverflowX(style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_X, this.overflowXSupported));
        sblp.setOverflowY(style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_Y, this.overflowYSupported));
        sblp.setInvisibleConsumesSpace(style.getBooleanStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE, nodeType == 130));
        sblp.setVisible(style.getBooleanStyleProperty(ElementStyleKeys.VISIBLE));
        RenderBox parent = box.getParent();
        if (parent != null && style.getDoubleStyleProperty(ElementStyleKeys.MIN_WIDTH, 0.0) == 0.0 && style.getDoubleStyleProperty(ElementStyleKeys.WIDTH, 0.0) == 0.0) {
            if ((parent.getLayoutNodeType() & 0x12) == 18) {
                sblp.setDefinedWidth(true);
            } else {
                sblp.setDefinedWidth(false);
            }
        } else {
            sblp.setDefinedWidth(true);
        }
    }

    private void computeMarginsAndBorders(RenderBox box, BoxDefinition boxDefinition, StaticBoxLayoutProperties sblp) {
        int nodeType = box.getLayoutNodeType();
        if (nodeType == 278530 || nodeType == 270338) {
            sblp.setBorderBottom(0L);
            sblp.setBorderTop(0L);
            sblp.setBorderRight(0L);
            sblp.setBorderLeft(0L);
        } else {
            Border border = boxDefinition.getBorder();
            sblp.setBorderTop(border.getTop().getWidth());
            sblp.setBorderLeft(border.getLeft().getWidth());
            sblp.setBorderBottom(border.getBottom().getWidth());
            sblp.setBorderRight(border.getRight().getWidth());
        }
    }

    private StaticChunkWidthUpdate createChunkWidthUpdate(RenderBox box) {
        if (this.chunkWidthUpdate.isInline()) {
            return this.chunkWidthUpdatePool.createInline(this.chunkWidthUpdate, box);
        }
        int nodeType = box.getLayoutNodeType();
        if (nodeType == 274) {
            return this.chunkWidthUpdatePool.createParagraph(this.chunkWidthUpdate, (ParagraphRenderBox)box);
        }
        if (nodeType == 130 || nodeType == 278530) {
            return this.chunkWidthUpdatePool.createHorizontal(this.chunkWidthUpdate, box);
        }
        return this.chunkWidthUpdatePool.createVertical(this.chunkWidthUpdate, box);
    }

    protected void updateMinimumChunkWidth(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            if (box.isVisible()) {
                this.chunkWidthUpdate.update(box.getMinimumChunkWidth());
            }
            return;
        }
        box.setStaticBoxPropertiesAge(box.getChangeTracker());
        StaticChunkWidthUpdate boxUpdate = this.chunkWidthUpdate;
        boxUpdate.finish();
        this.chunkWidthUpdate = this.chunkWidthUpdate.pop();
        if (box.isVisible()) {
            this.chunkWidthUpdate.update(box.getMinimumChunkWidth());
        }
    }
}

