/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.AutoRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;

public class CleanTableRowsPreparationStep
extends IterateStructuralProcessStep {
    private GenericObjectTable<Cell> cells;
    private int requiredAdditionalRows;
    private int trueRowCount;
    private TableRowModel rowModel;
    private int autoBoxIndex;
    private int firstRowEncountered;
    private int currentRow;

    public int process(TableSectionRenderBox renderBox, long pageOffset) {
        this.firstRowEncountered = -1;
        this.rowModel = renderBox.getRowModel();
        this.trueRowCount = 0;
        this.cells = new GenericObjectTable();
        this.startProcessing(renderBox);
        return CleanTableRowsPreparationStep.computeSafeCut(pageOffset, this.cells, this.trueRowCount);
    }

    public int getFirstRowEncountered() {
        return this.firstRowEncountered;
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        this.autoBoxIndex = -1;
        return true;
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        AutoRenderBox autobox = (AutoRenderBox)box;
        autobox.setRowIndex(this.autoBoxIndex);
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        int row = box.getRowIndex();
        this.trueRowCount = row + 1;
        if (this.autoBoxIndex == -1) {
            this.autoBoxIndex = row;
        }
        this.currentRow = row;
        this.seenRow(row);
        return true;
    }

    private void seenRow(int rowNumber) {
        if (this.firstRowEncountered == -1) {
            this.firstRowEncountered = rowNumber;
        }
        int currentRowMaxRowSpan = this.rowModel.getMaximumRowSpan(rowNumber);
        if (this.requiredAdditionalRows > 0) {
            --this.requiredAdditionalRows;
        }
        this.requiredAdditionalRows += currentRowMaxRowSpan;
        --this.requiredAdditionalRows;
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        int row = this.currentRow;
        int col = box.getColumnIndex();
        int rowSpan = box.getRowSpan();
        Cell c = new Cell(row, col, rowSpan, box.getY());
        for (int r = 0; r < rowSpan; ++r) {
            this.cells.setObject(r + row, col, (Object)c);
        }
        return false;
    }

    public static int computeSafeCut(long pageOffset, GenericObjectTable<Cell> cells, int trueRowCount) {
        int rowForPageOffset = CleanTableRowsPreparationStep.findRowForPageOffset(pageOffset, cells, trueRowCount);
        if (rowForPageOffset == 0) {
            return 0;
        }
        if (rowForPageOffset == trueRowCount) {
            return trueRowCount;
        }
        int colIdx = cells.getColumnCount() - 1;
        int rowIdx = rowForPageOffset;
        while (colIdx >= 0) {
            Cell c = (Cell)cells.getObject(rowIdx, colIdx);
            if (c == null) {
                --colIdx;
                continue;
            }
            if (c.getRowIndex() == rowIdx) {
                --colIdx;
                continue;
            }
            --rowIdx;
        }
        return rowIdx;
    }

    private static int findRowForPageOffset(long pageOffset, GenericObjectTable<Cell> cells, int trueRowCount) {
        int selectedRow = 0;
        for (int row = 0; row < trueRowCount; ++row) {
            long pos = -1L;
            for (int col = 0; col < cells.getColumnCount(); ++col) {
                Cell c = (Cell)cells.getObject(row, col);
                if (c == null || c.getRowIndex() != row) continue;
                pos = c.getY();
            }
            if (pos == -1L) continue;
            if (pageOffset < pos) break;
            selectedRow = row;
        }
        return selectedRow;
    }

    public static class Cell {
        private int rowIndex;
        private int colIndex;
        private int rowSpan;
        private long y;

        public Cell(int rowIndex, int colIndex, int rowSpan, long y) {
            this.rowIndex = rowIndex;
            this.colIndex = colIndex;
            this.rowSpan = rowSpan;
            this.y = y;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getColIndex() {
            return this.colIndex;
        }

        public int getRowSpan() {
            return this.rowSpan;
        }

        public long getY() {
            return this.y;
        }
    }
}

