/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.layout.TextCache;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.text.ComplexTextFactory;
import org.pentaho.reporting.engine.classic.core.layout.text.DefaultRenderableTextFactory;
import org.pentaho.reporting.engine.classic.core.layout.text.RenderableTextFactory;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;

public class TextProducer {
    private CodePointBuffer buffer;
    private RenderableTextFactory textFactory;
    private TextCache textCache;
    private int[] bufferArray;
    private Utf16LE utf16LE;

    public TextProducer(OutputProcessorMetaData metaData) {
        this.textFactory = metaData.isFeatureSupported(OutputProcessorFeature.COMPLEX_TEXT) ? new ComplexTextFactory() : new DefaultRenderableTextFactory(metaData);
        this.textCache = new TextCache(500);
        this.bufferArray = new int[500];
        this.utf16LE = Utf16LE.getInstance();
    }

    private void transformText(String text) {
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = this.utf16LE.decodeString(text, this.buffer);
        this.bufferArray = this.buffer.getBuffer(this.bufferArray);
    }

    public void startText() {
        this.textFactory.startText();
    }

    public RenderNode[] getRenderNodes(ReportElement element, StyleSheet elementStyle, String text) {
        RenderNode[] finishNodes;
        RenderNode[] renderNodes;
        ReportAttributeMap<Object> attrs = element.getAttributes();
        TextCache.Result result = this.textCache.get(elementStyle.getId(), elementStyle.getChangeTracker(), attrs.getChangeTracker(), text);
        if (result != null) {
            renderNodes = result.getText();
            finishNodes = result.getFinish();
        } else {
            this.transformText(text);
            renderNodes = this.textFactory.createText(this.bufferArray, 0, this.buffer.getLength(), elementStyle, element.getElementType(), element.getObjectID(), attrs);
            finishNodes = this.textFactory.finishText();
            this.textCache.store(elementStyle.getId(), elementStyle.getChangeTracker(), attrs.getChangeTracker(), text, elementStyle, attrs, renderNodes, finishNodes);
        }
        if (renderNodes.length == 0) {
            return finishNodes;
        }
        if (finishNodes.length == 0) {
            return renderNodes;
        }
        RenderNode[] data = new RenderNode[finishNodes.length + renderNodes.length];
        System.arraycopy(renderNodes, 0, data, 0, renderNodes.length);
        System.arraycopy(finishNodes, 0, data, renderNodes.length, finishNodes.length);
        return data;
    }
}

