/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.BreakMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TableLayout;

public class ModelPrinter {
    public static final ModelPrinter INSTANCE = new ModelPrinter();
    private static final Log logger = LogFactory.getLog(ModelPrinter.class);
    private static final boolean PRINT_LINEBOX_CONTENTS = false;
    private static final boolean PRINT_TABLE_CELL_CONTENTS = true;

    public static RenderBox getRoot(RenderNode node) {
        RenderBox retval = node.getParent();
        for (RenderBox parent = node.getParent(); parent != null; parent = parent.getParent()) {
            retval = parent;
        }
        return retval;
    }

    protected void print(String s) {
        logger.debug((Object)s);
    }

    public void printParents(RenderNode box) {
        int level = 0;
        while (box != null) {
            if (box instanceof RenderBox) {
                this.printBoxDetails((RenderBox)box, level);
            } else {
                this.printNode(box, level);
            }
            ++level;
            box = box.getParent();
        }
    }

    public void print(RenderNode box) {
        if (!this.isPrintingEnabled()) {
            return;
        }
        if (box instanceof RenderBox) {
            this.printBox((RenderBox)box, 0);
        } else {
            this.printNode(box, 0);
        }
    }

    protected boolean isPrintingEnabled() {
        return logger.isDebugEnabled();
    }

    public void print(RenderBox box) {
        if (!this.isPrintingEnabled()) {
            return;
        }
        this.printBox(box, 0);
    }

    protected void printBox(RenderBox box, int level) {
        this.printBoxDetails(box, level);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            b.append("   ");
        }
        this.print(b.toString());
        if (box instanceof ParagraphRenderBox) {
            // empty if block
        }
        if (this.isPrintPageHeader() && box instanceof LogicalPageBox) {
            LogicalPageBox lbox = (LogicalPageBox)box;
            this.printBox(lbox.getHeaderArea(), level + 1);
            this.printBox(lbox.getWatermarkArea(), level + 1);
        }
        this.printChilds(box, level);
        if (this.isPrintPageFooter() && box instanceof LogicalPageBox) {
            LogicalPageBox lbox = (LogicalPageBox)box;
            this.printBox(lbox.getRepeatFooterArea(), level + 1);
            this.printBox(lbox.getFooterArea(), level + 1);
        }
    }

    protected boolean isPrintPageHeader() {
        return true;
    }

    protected boolean isPrintPageFooter() {
        return true;
    }

    private void printBoxDetails(RenderBox box, int level) {
        int i;
        int i2;
        StringBuilder b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append(box.getClass().getName());
        b.append('[');
        b.append(box.getElementType().getClass().getName());
        b.append(';');
        b.append(box.getName());
        b.append(']');
        b.append("={stateKey=");
        b.append(box.getStateKey());
        b.append(", pinned=");
        b.append(box.getPinned());
        b.append('}');
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- layout x=");
        b.append(box.getX());
        b.append(", y=");
        b.append(box.getY());
        b.append(", width=");
        b.append(box.getWidth());
        b.append(", height=");
        b.append(box.getHeight());
        b.append(", min-chunk-width=");
        b.append(box.getMinimumChunkWidth());
        b.append(", x2=");
        b.append(box.getX() + box.getWidth());
        b.append(", y2=");
        b.append(box.getY2());
        b.append(", y2-overflow=");
        b.append(box.getY() + box.getOverflowAreaHeight());
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- cached-layout cached-x=");
        b.append(box.getCachedX());
        b.append(", cached-y=");
        b.append(box.getCachedY());
        b.append(", cached-width=");
        b.append(box.getCachedWidth());
        b.append(", cached-height=");
        b.append(box.getCachedHeight());
        b.append(", content-area-x1=");
        b.append(box.getContentAreaX1());
        b.append(", content-area-x2=");
        b.append(box.getContentAreaX2());
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- widow-size=");
        b.append(box.getWidowConstraintSize());
        b.append("- widow-size-with-keep-together=");
        b.append(box.getWidowConstraintSizeWithKeepTogether());
        b.append(", orphan-size=");
        b.append(box.getOrphanConstraintSize());
        b.append(", widows=");
        b.append(box.getStaticBoxLayoutProperties().getWidows());
        b.append(", orphans=");
        b.append(box.getStaticBoxLayoutProperties().getOrphans());
        b.append(", keep-together=");
        b.append(box.getStaticBoxLayoutProperties().isAvoidPagebreakInside());
        b.append(", widow-orphan-opt-out=");
        b.append(box.getStaticBoxLayoutProperties().isWidowOrphanOptOut());
        b.append(", widows-box=");
        b.append(box.isWidowBox());
        b.append(", orphan-restrict-finish=");
        b.append((Object)box.getRestrictFinishedClearOut());
        b.append(", invalid-widow-orphan-node=");
        b.append(box.isInvalidWidowOrphanNode());
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- boxDefinition=");
        b.append(box.getBoxDefinition());
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(box.getNodeLayoutProperties());
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- staticBoxLayoutProperties=");
        b.append(box.getStaticBoxLayoutProperties());
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        this.print(b.toString());
        if (box instanceof LogicalPageBox) {
            LogicalPageBox pageBox = (LogicalPageBox)box;
            b = new StringBuilder();
            for (i = 0; i < level; ++i) {
                b.append("   ");
            }
            b.append("- PageBox={PageOffset=");
            b.append(pageBox.getPageOffset());
            b.append(", PageHeight=");
            b.append(pageBox.getPageHeight());
            b.append(", PageEnd=");
            b.append(pageBox.getPageEnd());
            b.append(", PageWidth=");
            b.append(pageBox.getPageWidth());
            b.append('}');
            this.print(b.toString());
            b = new StringBuilder();
            for (i = 0; i < level; ++i) {
                b.append("   ");
            }
            b.append("- PageBreaks={");
            b.append(pageBox.getAllVerticalBreaks());
            b.append('}');
            this.print(b.toString());
        }
        if (box instanceof TableRenderBox) {
            TableRenderBox pageBox = (TableRenderBox)box;
            b = new StringBuilder();
            for (i = 0; i < level; ++i) {
                b.append("   ");
            }
            b.append("- Layout: ");
            Object styleProperty = pageBox.getStyleSheet().getStyleProperty(BandStyleKeys.TABLE_LAYOUT);
            if (TableLayout.auto.equals(styleProperty)) {
                b.append((Object)TableLayout.auto);
            } else {
                b.append((Object)TableLayout.fixed);
            }
            this.print(b.toString());
        }
        if (box instanceof TableSectionRenderBox) {
            TableSectionRenderBox pageBox = (TableSectionRenderBox)box;
            b = new StringBuilder();
            for (int i3 = 0; i3 < level; ++i3) {
                b.append("   ");
            }
            b.append("- Role: ");
            b.append((Object)pageBox.getDisplayRole());
            this.print(b.toString());
        }
        if (box instanceof TableRowRenderBox) {
            TableRowRenderBox pageBox = (TableRowRenderBox)box;
            b = new StringBuilder();
            for (int i4 = 0; i4 < level; ++i4) {
                b.append("   ");
            }
            b.append("- Row: ");
            b.append(pageBox.getRowIndex());
            this.print(b.toString());
        }
        if (box instanceof TableCellRenderBox) {
            TableCellRenderBox pageBox = (TableCellRenderBox)box;
            b = new StringBuilder();
            for (int i5 = 0; i5 < level; ++i5) {
                b.append("   ");
            }
            b.append("- Column-Index=");
            b.append(pageBox.getColumnIndex());
            b.append(", ColSpan=");
            b.append(pageBox.getColSpan());
            b.append(", RowSpan=");
            b.append(pageBox.getRowSpan());
            this.print(b.toString());
        }
        if (box instanceof BreakMarkerRenderBox) {
            BreakMarkerRenderBox pageBox = (BreakMarkerRenderBox)box;
            b = new StringBuilder();
            for (int i6 = 0; i6 < level; ++i6) {
                b.append("   ");
            }
            b.append("- InstanceID=");
            b.append(pageBox.getInstanceId());
            b.append(", validity-range=");
            b.append(pageBox.getValidityRange());
            this.print(b.toString());
        }
        if (box.isOpen()) {
            b = new StringBuilder();
            for (int i7 = 0; i7 < level; ++i7) {
                b.append("   ");
            }
            b.append("- WARNING: THIS BOX IS STILL OPEN");
            this.print(b.toString());
        }
        if (box.isFinishedTable() || box.isFinishedPaginate()) {
            b = new StringBuilder();
            for (int i8 = 0; i8 < level; ++i8) {
                b.append("   ");
            }
            b.append("- INFO: THIS BOX IS FINISHED: ");
            if (box.isFinishedTable()) {
                b.append("- TABLE ");
            }
            if (box.isFinishedPaginate()) {
                b.append("- PAGE ");
            }
            this.print(b.toString());
        }
        if (box.isCommited()) {
            b = new StringBuilder();
            for (int i9 = 0; i9 < level; ++i9) {
                b.append("   ");
            }
            b.append("- INFO: THIS BOX IS COMMITED");
            this.print(b.toString());
        }
    }

    private void printChilds(RenderBox box, int level) {
        for (RenderNode childs = box.getFirstChild(); childs != null; childs = childs.getNext()) {
            if (childs instanceof RenderBox) {
                this.printBox((RenderBox)childs, level + 1);
                continue;
            }
            this.printNode(childs, level + 1);
        }
    }

    private void printNode(RenderNode node, int level) {
        int i;
        int i2;
        StringBuilder b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append(node.getClass().getName());
        b.append('[');
        b.append(']');
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- layout x=");
        b.append(node.getX());
        b.append(", y=");
        b.append(node.getY());
        b.append(", width=");
        b.append(node.getWidth());
        b.append(", height=");
        b.append(node.getHeight());
        b.append(", min-chunk-width=");
        b.append(node.getMinimumChunkWidth());
        b.append(", x2=");
        b.append(node.getX() + node.getWidth());
        b.append(", y2=");
        b.append(node.getY() + node.getHeight());
        this.print(b.toString());
        b = new StringBuilder();
        for (i2 = 0; i2 < level; ++i2) {
            b.append("   ");
        }
        b.append("- cached-layout cached-x=");
        b.append(node.getCachedX());
        b.append(", cached-y=");
        b.append(node.getCachedY());
        b.append(", cached-width=");
        b.append(node.getCachedWidth());
        b.append(", cached-height=");
        b.append(node.getCachedHeight());
        this.print(b.toString());
        if (node instanceof FinishedRenderNode) {
            b = new StringBuilder();
            for (i2 = 0; i2 < level; ++i2) {
                b.append("   ");
            }
            FinishedRenderNode fn = (FinishedRenderNode)node;
            b.append("layouted-y=");
            b.append(fn.getLayoutedY());
            b.append(", layouted-width=");
            b.append(fn.getLayoutedWidth());
            b.append(", layouted-height=");
            b.append(fn.getLayoutedHeight());
            b.append(", orphan-leaf=");
            b.append(fn.isOrphanLeaf());
            this.print(b.toString());
        }
        if (node instanceof RenderableText) {
            RenderableText text = (RenderableText)node;
            b = new StringBuilder();
            for (i = 0; i < level; ++i) {
                b.append("   ");
            }
            b.append("- text='");
            b.append(text.getRawText());
            b.append("'");
            this.print(b.toString());
        }
        if (node instanceof RenderableComplexText) {
            RenderableComplexText text = (RenderableComplexText)node;
            b = new StringBuilder();
            for (i = 0; i < level; ++i) {
                b.append("   ");
            }
            b.append("- complex-text='");
            b.append(text.getRawText());
            b.append("'");
            this.print(b.toString());
        }
        b = new StringBuilder();
        for (int i3 = 0; i3 < level; ++i3) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(node.getNodeLayoutProperties());
        this.print(b.toString());
        this.print(" ");
    }
}

