/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.imagemap;

import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriterSupport;

public abstract class AbstractImageMapEntry
implements ImageMapEntry {
    private AttributeMap attributeMap = new AttributeMap();

    protected AbstractImageMapEntry() {
    }

    @Override
    public String getAttribute(String namespace, String name) {
        return (String)this.attributeMap.getAttribute(namespace, name);
    }

    public void setAttribute(String namespace, String name, String value) {
        this.attributeMap.setAttribute(namespace, name, (Object)value);
    }

    @Override
    public String[] getNames(String namespace) {
        return this.attributeMap.getNames(namespace);
    }

    @Override
    public String[] getNameSpaces() {
        return this.attributeMap.getNameSpaces();
    }

    public Object getFirstAttribute(String name) {
        return this.attributeMap.getFirstAttribute(name);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.getShape().contains(x, y);
    }

    public String toString() {
        StringBuffer stringBuilder = new StringBuffer();
        stringBuilder.append("<area type=\"");
        stringBuilder.append(this.getAreaType());
        stringBuilder.append("\" coords=\"");
        float[] coords = this.getAreaCoordinates();
        for (int i = 0; i < coords.length; ++i) {
            float coord = coords[i];
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(coord);
        }
        stringBuilder.append("\"");
        String[] namespaces = this.attributeMap.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String namespace = namespaces[i];
            String[] names = this.attributeMap.getNames(namespace);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                stringBuilder.append(" ");
                stringBuilder.append(XmlWriterSupport.normalize((String)name, (boolean)true));
                stringBuilder.append("=");
                stringBuilder.append(XmlWriterSupport.normalize((String)String.valueOf(this.attributeMap.getAttribute(namespace, name)), (boolean)true));
            }
        }
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }
}

