/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import java.util.ResourceBundle;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class ExpressionUtilities {
    private ExpressionUtilities() {
    }

    public static BigDecimal convertToBigDecimal(Object o) {
        if (o instanceof Number) {
            return ExpressionUtilities.convertToBigDecimal((Number)o);
        }
        return null;
    }

    public static BigDecimal convertToBigDecimal(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Integer || number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        return new BigDecimal(number.toString());
    }

    public static ResourceBundle getDefaultResourceBundle(Expression expression) {
        if (expression == null) {
            throw new NullPointerException("Expression is null");
        }
        String resourceBundleName = expression.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ResourceBundle");
        return expression.getResourceBundleFactory().getResourceBundle(resourceBundleName);
    }
}

