/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class RectangleType
extends AbstractElementType {
    public static final RectangleType INSTANCE = new RectangleType();

    public RectangleType() {
        super("rectangle");
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        float arcWidth = this.parseArcParam(element, "arc-width");
        float arcHeight = this.parseArcParam(element, "arc-height");
        if (arcWidth <= 0.0f || arcHeight <= 0.0f) {
            return new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        }
        return new RoundRectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f, arcWidth, arcHeight);
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        return this.getValue(runtime, element);
    }

    @Override
    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
        element.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.TRUE);
        element.getStyle().setStyleProperty(ElementStyleKeys.DRAW_SHAPE, Boolean.TRUE);
    }

    private float parseArcParam(ReportElement element, String attrName) {
        float arcWidth;
        Object attributeArcWidth = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", attrName);
        if (attributeArcWidth != null) {
            if (attributeArcWidth instanceof Number) {
                Number n = (Number)attributeArcWidth;
                arcWidth = n.floatValue();
            } else {
                arcWidth = ParserUtil.parseFloat((String)String.valueOf(attributeArcWidth), (float)0.0f);
            }
        } else {
            arcWidth = 0.0f;
        }
        return arcWidth;
    }
}

