/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.awt.Component;
import java.awt.Image;
import java.awt.Shape;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ComponentDrawable;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawableImage;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class ContentType
extends AbstractElementType {
    public static final ContentType INSTANCE = new ContentType();
    private static final Class[] TARGETS = new Class[]{DrawableWrapper.class, Image.class};
    private static final Log logger = LogFactory.getLog(ContentType.class);

    public ContentType() {
        super("content");
    }

    protected ContentType(String id) {
        super(id);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Object loadedNullValue;
        Object nullValue;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        URL resource = null;
        Object value = ElementTypeUtils.queryStaticValue(element);
        if (value != null) {
            Object filteredValue = this.filter(runtime, element, value);
            if (filteredValue != null) {
                return filteredValue;
            }
            boolean isBrokenImageEnabled = "true".equals(runtime.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.EnableBrokenImage"));
            if (isBrokenImageEnabled) {
                resource = ContentType.class.getResource("/org/pentaho/reporting/engine/classic/core/metadata/icons/image_broken_50.png");
            }
        }
        if ((nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value")) != null && (loadedNullValue = this.filter(runtime, element, nullValue)) != null) {
            return loadedNullValue;
        }
        try {
            if (resource == null) {
                resource = ContentType.class.getResource("/org/pentaho/reporting/engine/classic/core/metadata/icons/image_50.png");
            }
            if (resource != null) {
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource loadedResource = resManager.createDirectly((Object)resource, Image.class);
                Image image = (Image)loadedResource.getResource();
                return new ReportDrawableImage(image);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to load content." + e));
        }
        return value;
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        return this.getValue(runtime, element);
    }

    protected Object filter(ExpressionRuntime runtime, ReportElement element, Object value) {
        Object o;
        if (value == null) {
            return null;
        }
        if (value instanceof Image) {
            try {
                return new DefaultImageReference((Image)value);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to load content using value " + value), (Throwable)e);
                return null;
            }
        }
        if (value instanceof Shape) {
            return value;
        }
        if (value instanceof ImageContainer) {
            return value;
        }
        if (value instanceof Component) {
            Component c = (Component)value;
            return new DrawableWrapper((Object)this.createComponentDrawable(runtime, c, element));
        }
        if (value instanceof DrawableWrapper) {
            return value;
        }
        if (DrawableWrapper.isDrawable((Object)value)) {
            return new DrawableWrapper(value);
        }
        ContentTypeContext context = element.getElementContext(ContentTypeContext.class);
        if (context.failureCache != null && Boolean.TRUE.equals(o = context.failureCache.get(value))) {
            return null;
        }
        try {
            ResourceKey contentBase = runtime.getProcessingContext().getContentBase();
            ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
            Object contentBaseValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
            ResourceKey key = resManager.createOrDeriveKey(contentBase, value, contentBaseValue);
            if (key == null) {
                return null;
            }
            Resource resource = resManager.create(key, contentBase, TARGETS);
            Object resourceContent = resource.getResource();
            if (resourceContent instanceof DrawableWrapper) {
                return resourceContent;
            }
            if (DrawableWrapper.isDrawable((Object)resourceContent)) {
                return new DrawableWrapper(resourceContent);
            }
            if (resourceContent instanceof Image) {
                return new DefaultImageReference(resource);
            }
            return resourceContent;
        }
        catch (Exception e) {
            if (context.failureCache == null) {
                context.failureCache = new LFUMap(5);
            }
            context.failureCache.put(value, (Object)Boolean.TRUE);
            logger.warn((Object)("Failed to load content using value " + value), (Throwable)e);
            return null;
        }
    }

    protected final ComponentDrawable createComponentDrawable(ExpressionRuntime runtime, Component c, ReportElement element) {
        ComponentDrawable cd;
        Configuration config = runtime.getConfiguration();
        String drawMode = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.ComponentDrawableMode", "shared");
        if ("private".equals(drawMode)) {
            cd = new ComponentDrawable();
        } else if ("synchronized".equals(drawMode)) {
            cd = new ComponentDrawable();
            cd.setPaintSynchronized(true);
        } else {
            ContentTypeContext context = element.getElementContext(ContentTypeContext.class);
            if (context.frame == null) {
                context.frame = new JFrame();
            }
            cd = new ComponentDrawable(context.frame);
            cd.setPaintSynchronized(true);
        }
        String allowOwnPeer = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.AllowOwnPeerForComponentDrawable");
        cd.setAllowOwnPeer("true".equals(allowOwnPeer));
        cd.setComponent(c);
        return cd;
    }

    @Override
    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
        element.getStyle().setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, Boolean.TRUE);
        element.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.TRUE);
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, Float.valueOf(50.0f));
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(50.0f));
    }

    public static class ContentTypeContext {
        public LFUMap<Object, Boolean> failureCache;
        public JFrame frame;
    }
}

