/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import javax.swing.table.TableModel;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.cache.CachableTableModel;
import org.pentaho.reporting.engine.classic.core.cache.DataCache;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheFactory;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheKey;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheManager;

public class EhCacheDataCache
implements DataCache {
    private static final String CACHE_NAME = "report-dataset-cache";
    private DataCacheManager cacheManager;
    private int maximumRows;
    private volatile CacheManager manager;
    private volatile Cache cache;

    public EhCacheDataCache() {
        this(ClassicEngineBoot.getInstance().getExtendedConfig().getIntProperty("org.pentaho.reporting.engine.classic.core.cache.EhCacheDataCache.CachableRowLimit"));
    }

    public EhCacheDataCache(int maximumRows) {
        this.maximumRows = maximumRows;
        this.cacheManager = new GlobalCacheManager();
        this.initializeCacheManager();
        this.initialize();
    }

    private void initializeCacheManager() {
        if (ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.engine.classic.core.cache.EhCacheDataCache.UseGlobalCacheManager")) {
            this.manager = CacheManager.getInstance();
        } else if (this.manager == null) {
            this.manager = this.createCacheManager();
        }
    }

    private synchronized void initialize() {
        if (this.manager != null && this.manager.getStatus() != Status.STATUS_ALIVE) {
            this.initializeCacheManager();
        }
        if (this.cache != null && this.cache.getStatus() == Status.STATUS_ALIVE) {
            return;
        }
        if (!this.manager.cacheExists(CACHE_NAME)) {
            this.cache = new Cache(CACHE_NAME, 500, false, false, 600L, 600L, false, 120L);
            this.manager.addCache(this.cache);
        } else {
            this.cache = this.manager.getCache(CACHE_NAME);
        }
    }

    protected CacheManager createCacheManager() {
        return new CacheManager();
    }

    public int getMaximumRows() {
        return this.maximumRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableModel get(DataCacheKey key) {
        Cache cache = this.cache;
        EhCacheDataCache ehCacheDataCache = this;
        synchronized (ehCacheDataCache) {
            if (cache == null) {
                return null;
            }
            if (cache.getStatus() != Status.STATUS_ALIVE) {
                this.cache = null;
                return null;
            }
        }
        Element element = cache.get((Object)key);
        if (element == null) {
            return null;
        }
        return (TableModel)element.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableModel put(DataCacheKey key, TableModel model) {
        Cache cache;
        if (model.getRowCount() > this.maximumRows) {
            return model;
        }
        if (!CachableTableModel.isSafeToCache(model)) {
            return model;
        }
        EhCacheDataCache ehCacheDataCache = this;
        synchronized (ehCacheDataCache) {
            this.initialize();
            cache = this.cache;
        }
        CachableTableModel cacheModel = new CachableTableModel(model);
        cache.put(new Element((Object)key, (Object)cacheModel));
        return cacheModel;
    }

    @Override
    public DataCacheManager getCacheManager() {
        return this.cacheManager;
    }

    private class GlobalCacheManager
    implements DataCacheManager {
        private GlobalCacheManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAll() {
            EhCacheDataCache ehCacheDataCache = EhCacheDataCache.this;
            synchronized (ehCacheDataCache) {
                if (EhCacheDataCache.this.cache != null) {
                    EhCacheDataCache.this.cache.removeAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            EhCacheDataCache ehCacheDataCache = EhCacheDataCache.this;
            synchronized (ehCacheDataCache) {
                if (EhCacheDataCache.this.cache != null) {
                    EhCacheDataCache.this.cache.removeAll();
                }
                if (ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.engine.classic.core.cache.EhCacheDataCache.UseGlobalCacheManager") && EhCacheDataCache.this.manager != null) {
                    EhCacheDataCache.this.manager.shutdown();
                }
                EhCacheDataCache.this.cache = null;
                EhCacheDataCache.this.manager = null;
                DataCacheFactory.notifyCacheShutdown(EhCacheDataCache.this);
            }
        }
    }
}

