/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ReportSectionDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public abstract class Section
extends Element
implements Iterable<Element> {
    protected Section() {
    }

    protected Section(InstanceID id) {
        super(id);
    }

    @Override
    public ElementStyleSheet getDefaultStyleSheet() {
        return ReportSectionDefaultStyleSheet.getSectionDefault();
    }

    public abstract Element getElement(int var1);

    public abstract int getElementCount();

    protected boolean unregisterParent(Element element) {
        Section parentSection = element.getParentSection();
        if (parentSection != null) {
            if (parentSection == this) {
                return true;
            }
            parentSection.removeElement(element);
        }
        return false;
    }

    protected void validateLooping(Element element) {
        if (element instanceof Section) {
            for (Section band = this; band != null; band = band.getParentSection()) {
                if (band != element) continue;
                throw new IllegalArgumentException("adding container's parent to itself");
            }
        }
    }

    public abstract void setElementAt(int var1, Element var2);

    protected abstract void removeElement(Element var1);

    protected void unregisterAsChild(Element element) {
        element.setParent(null);
    }

    protected void registerAsChild(Element element) {
        element.setParent(this);
    }

    @Override
    public Iterator<Element> iterator() {
        return new SectionIterator();
    }

    @Override
    public Section derive(boolean preserveElementInstanceIds) {
        return (Section)super.derive(preserveElementInstanceIds);
    }

    @Override
    public Section clone() {
        return (Section)super.clone();
    }

    private class SectionIterator
    implements Iterator<Element> {
        private int pos;

        private SectionIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < Section.this.getElementCount();
        }

        @Override
        public Element next() {
            if (this.pos >= Section.this.getElementCount()) {
                throw new NoSuchElementException();
            }
            Element e = Section.this.getElement(this.pos);
            ++this.pos;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

