/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.pentaho.reporting.libraries.base.util.PasswordObscurification;

public class SecurePasswordEncryption {
    private static final String[] byteToText;
    private static final byte[] SALT;

    public String encryptPassword(String password, String key) throws GeneralSecurityException, UnsupportedEncodingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), SALT, 1024, 128);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
        return this.encryptPassword(password, secret, "AES/CBC/PKCS5PADDING");
    }

    public String encryptPassword(String password, SecretKey key, String algorithm) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher c = Cipher.getInstance(algorithm);
        c.init(1, key);
        byte[] encryptedData = c.doFinal(password.getBytes("UTF-8"));
        StringBuffer b = new StringBuffer();
        byte[] iv = c.getIV();
        SecurePasswordEncryption.appendAsHexString(SecurePasswordEncryption.intToByte(iv.length), b);
        SecurePasswordEncryption.appendAsHexString(iv, b);
        SecurePasswordEncryption.appendAsHexString(SecurePasswordEncryption.intToByte(encryptedData.length), b);
        SecurePasswordEncryption.appendAsHexString(encryptedData, b);
        return b.toString();
    }

    protected static void appendAsHexString(byte[] encryptedData, StringBuffer b) {
        for (int i = 0; i < encryptedData.length; ++i) {
            int b1 = 0xFF & encryptedData[i];
            b.append(byteToText[b1]);
        }
    }

    protected static byte[] intToByte(int value) {
        byte[] b = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return b;
    }

    public String decryptPassword(String password, String key) throws UnsupportedEncodingException, GeneralSecurityException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), SALT, 1024, 128);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
        return this.decryptPassword(password, secret, "AES/CBC/PKCS5PADDING");
    }

    public String decryptPassword(String password, SecretKey key, String algorithm) throws UnsupportedEncodingException, GeneralSecurityException {
        byte[] b = SecurePasswordEncryption.stringToBytes(password);
        if (b == null) {
            return null;
        }
        int ivLength = SecurePasswordEncryption.bytesToInt(b, 0);
        byte[] iv = new byte[ivLength];
        System.arraycopy(b, 4, iv, 0, ivLength);
        int dataLength = SecurePasswordEncryption.bytesToInt(b, 4 + ivLength);
        byte[] data = new byte[dataLength];
        System.arraycopy(b, 8 + ivLength, data, 0, dataLength);
        Cipher c = Cipher.getInstance(algorithm);
        c.init(2, (Key)key, new IvParameterSpec(iv));
        byte[] decryptedData = c.doFinal(data);
        return new String(decryptedData, "UTF-8");
    }

    protected static byte[] stringToBytes(String password) throws UnsupportedEncodingException {
        char[] chars = password.toCharArray();
        if (chars.length % 2 != 0) {
            return null;
        }
        byte[] b = new byte[chars.length / 2];
        for (int i = 0; i < b.length; ++i) {
            int c1 = PasswordObscurification.charToHex(chars[i * 2]);
            int c2 = PasswordObscurification.charToHex(chars[i * 2 + 1]);
            int encodedByte = c1 * 16 + c2;
            int encByte = 0xFF & encodedByte;
            b[i] = (byte)encByte;
        }
        return b;
    }

    protected static int bytesToInt(byte[] data, int offset) {
        int retval = 0;
        retval |= (data[offset] & 0xFF) << 24;
        retval |= (data[offset + 1] & 0xFF) << 16;
        retval |= (data[offset + 2] & 0xFF) << 8;
        return retval |= data[offset + 3] & 0xFF;
    }

    static {
        int i;
        SALT = new byte[]{18, 86, -119, -2, -85, -59, 127, 1};
        byteToText = new String[256];
        for (i = 0; i < 16; ++i) {
            SecurePasswordEncryption.byteToText[i] = '0' + Integer.toHexString(i);
        }
        for (i = 16; i < 256; ++i) {
            SecurePasswordEncryption.byteToText[i] = Integer.toHexString(i);
        }
    }
}

