/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import utilities.JarMakerEvent;
import utilities.JarMakerListener;

public class JarMaker {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final boolean DEBUG = false;
    private static final boolean DEBUG_MANIFEST = false;
    private static final boolean DEBUG_CP = false;
    private static final boolean DEBUG_ZIP = false;
    private static final boolean DEBUG_REF = false;
    static final String CLASS_SUFFIX = ".class";
    private static final String MANIFEST_DIR_NAME = "META-INF/";
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_NAME_KEYWORD = "Name:";
    private static final String MANIFEST_VERSION_KEYWORD = "Manifest-Version:";
    private static final String MANIFEST_REQVERS_KEYWORD = "Required-Version:";
    private static final int BUFFER_SIZE = 2048;
    private static final int SPLIT_SIZE_KBYTES = 2048;
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final File CURRENT_DIR = new File(System.getProperty("user.dir"));
    static final boolean CHECK_DUPS = true;
    static final boolean NO_CHECK_DUPS = false;
    static final int STARTS_WITH = 1;
    static final int ENDS_WITH = 2;
    static final int CONTAINS = 3;
    private static boolean noSHA_ = false;
    private static boolean noMD5_ = false;
    boolean verbose_;
    boolean requestedUsageInfo_;
    private File sourceJarFile_;
    private File destinationJarFile_;
    private Vector filesRequired_ = new Vector();
    private Vector filesExcluded_ = new Vector();
    private Vector packages_ = new Vector();
    private Vector packagesExcluded_ = new Vector();
    private Hashtable additionalFiles_ = new Hashtable();
    boolean excludeSomeDependencies_;
    Vector dependenciesToExclude_ = new Vector();
    private boolean extract_ = false;
    private File baseDirectoryForExtract_ = new File(System.getProperty("user.dir"));
    private boolean split_ = false;
    private int splitSize_ = 2048;
    private String jarEntryDefaultPrefix_;
    private String jarEntryDefaultPrefixDotted_;
    private transient Vector eventListeners_ = new Vector();
    private Arguments arguments_ = new Arguments();

    public JarMaker() {
    }

    JarMaker(String string) {
        this.jarEntryDefaultPrefix_ = string;
        this.jarEntryDefaultPrefixDotted_ = string.replace('/', '.');
    }

    static boolean addElement(Vector vector, Object object) {
        if (vector.contains(object)) {
            return false;
        }
        vector.addElement(object);
        return true;
    }

    static void removeElements(Vector vector, String string, int n) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            boolean bl = false;
            switch (n) {
                case 1: {
                    if (!((String)object).startsWith(string)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!((String)object).endsWith(string)) break;
                    bl = true;
                    break;
                }
                default: {
                    if (((String)object).indexOf(string) == -1) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            vector2.addElement(object);
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            vector.removeElement((String)object.nextElement());
        }
    }

    public synchronized void addJarMakerListener(JarMakerListener jarMakerListener) {
        if (jarMakerListener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners_.addElement(jarMakerListener);
    }

    static void addPackageFiles(Vector vector, JarMap jarMap, Vector vector2) throws IOException {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.replace('.', '/');
            Vector vector3 = JarMaker.getEntryNamesForPackage(string2, jarMap);
            if (vector3.size() == 0) {
                System.err.println("Error: Specified package not found in source file:");
                System.err.println("       " + string);
                throw new ZipException(string);
            }
            JarMaker.copyVector(vector3, vector, true);
        }
    }

    static void removePackageFiles(Vector vector, JarMap jarMap, Vector vector2) throws IOException {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.replace('.', '/');
            Vector vector3 = JarMaker.getEntryNamesForPackage(string2, jarMap);
            if (vector3.size() == 0) {
                System.err.println("Error: Specified package not found in source file:");
                System.err.println("       " + string);
                throw new ZipException(string);
            }
            JarMaker.removeElements(vector, vector3);
        }
    }

    Vector adjustDependencies1(Vector vector, JarMap jarMap) throws IOException {
        return vector;
    }

    Vector adjustDependencies2(Vector vector, JarMap jarMap) throws IOException {
        JarMaker.removePackageFiles(vector, jarMap, this.packagesExcluded_);
        JarMaker.addPackageFiles(vector, jarMap, this.packages_);
        return vector;
    }

    void analyzeJarEntry(String string, Vector vector, Vector vector2, JarMap jarMap) throws IOException {
        this.fireAnalysisEvent(true, string);
        if (string.endsWith(CLASS_SUFFIX)) {
            if (this.excludeSomeDependencies_ && this.dependenciesToExclude_.contains(string)) {
                if (this.verbose_) {
                    System.out.println("\nExcluding entry from dependency analysis: " + string + "\n");
                }
                JarMaker.addElement(vector2, string);
            } else {
                Vector vector3 = this.getReferencedEntries(string, jarMap);
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!vector.contains(string2)) continue;
                    vector.removeElement(string2);
                    this.analyzeJarEntry(string2, vector, vector2, jarMap);
                    JarMaker.addElement(vector2, string2);
                }
            }
        }
        this.fireAnalysisEvent(false, string);
    }

    private static void constructManifestEntry(StringBuffer stringBuffer, File file, String string) throws IOException {
        byte[] byArray;
        MessageDigest messageDigest;
        String string2 = new String("Name: " + string);
        String string3 = new String("Digest-Algorithms: SHA MD5");
        String string4 = null;
        String string5 = null;
        byte[] byArray2 = JarMaker.getBytes(file);
        if (!noSHA_) {
            try {
                messageDigest = MessageDigest.getInstance("SHA");
                byArray = messageDigest.digest(byArray2);
                string4 = new String("SHA-Digest: " + byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSHA_ = true;
            }
        }
        if (!noMD5_) {
            try {
                messageDigest = MessageDigest.getInstance("MD5");
                byArray = messageDigest.digest(byArray2);
                string5 = new String("MD5-Digest: " + byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noMD5_ = true;
            }
        }
        if (string2 != null && string3 != null && (string4 != null || string5 != null)) {
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            stringBuffer.append(string3);
            stringBuffer.append('\n');
            if (string4 != null) {
                stringBuffer.append(string4);
                stringBuffer.append('\n');
            }
            if (string5 != null) {
                stringBuffer.append(string5);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        } else {
            System.err.println("Error: Failed to construct manifest entry for file");
            System.err.println("       " + file.getAbsolutePath());
        }
    }

    static final boolean contains(int[] nArray, int n) {
        return Arrays.binarySearch(nArray, n) >= 0;
    }

    private static void copyBytes(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[2048];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (!bl && (long)n2 < l) {
            n = inputStream.read(byArray, 0, byArray.length);
            if (n == -1) {
                bl = true;
                continue;
            }
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copyFile(File file, File file2) throws IOException {
        FilterOutputStream filterOutputStream;
        block12: {
            if (file == null) {
                throw new NullPointerException("sourceFile");
            }
            if (file2 == null) {
                throw new NullPointerException("destinationFile");
            }
            BufferedInputStream bufferedInputStream = null;
            filterOutputStream = null;
            String string = file2.getParent();
            if (string == null) {
                throw new NullPointerException("parentDirectory");
            }
            File file3 = new File(string);
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException(file3.getAbsolutePath() + ": Cannot create directory.");
            }
            byte[] byArray = new byte[2048];
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 2048);
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 2048);
                    boolean bl = false;
                    while (!bl) {
                        int n = bufferedInputStream.read(byArray);
                        if (n == -1) {
                            bl = true;
                            continue;
                        }
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                    ((BufferedOutputStream)filterOutputStream).flush();
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when copying file");
                    System.err.println("       " + file2.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
                Object var10_10 = null;
                if (bufferedInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream == null) throw throwable;
                filterOutputStream.close();
                throw throwable;
            }
            bufferedInputStream.close();
        }
        if (filterOutputStream == null) return;
        filterOutputStream.close();
    }

    static void copyVector(Vector vector, Vector vector2, boolean bl) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (bl && vector2.contains(e)) continue;
            vector2.addElement(e);
        }
    }

    static void removeElements(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.remove(enumeration.nextElement());
        }
    }

    static void copyZipEntry(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        long l;
        long l2;
        if (zipEntry == null) {
            throw new NullPointerException("inZipEntry");
        }
        if (inputStream == null) {
            throw new NullPointerException("inStream");
        }
        if (zipOutputStream == null) {
            throw new NullPointerException("zipOutStream");
        }
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setComment(zipEntry.getComment());
        long l3 = zipEntry.getCrc();
        if (l3 != -1L) {
            zipEntry2.setCrc(l3);
        }
        zipEntry2.setExtra(zipEntry.getExtra());
        int n = zipEntry.getMethod();
        if (n != -1) {
            zipEntry2.setMethod(n);
        }
        if ((l2 = zipEntry.getSize()) != -1L) {
            zipEntry2.setSize(l2);
        }
        if ((l = zipEntry.getTime()) != -1L) {
            zipEntry2.setTime(l);
        }
        zipOutputStream.putNextEntry(zipEntry2);
        byte[] byArray = new byte[2048];
        if (!zipEntry.isDirectory()) {
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            while (!bl && (long)n3 < l2) {
                n2 = inputStream.read(byArray);
                if (n2 == -1) {
                    bl = true;
                    continue;
                }
                zipOutputStream.write(byArray, 0, n2);
                n3 += n2;
            }
        }
    }

    private static int determineDirMetadataSize(Vector vector, int n) {
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n2 += string.length();
            n2 += n;
        }
        return n2;
    }

    public File extract(File file) throws FileNotFoundException, IOException, ZipException {
        if (file == null) {
            throw new NullPointerException("sourceJarFile");
        }
        File file2 = new File(System.getProperty("user.dir"));
        this.extract(file, file2);
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract(File file, File file2) throws FileNotFoundException, IOException, ZipException {
        if (file == null) {
            throw new NullPointerException("sourceJarFile");
        }
        if (file2 == null) {
            throw new NullPointerException("outputDirectory");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (this.verbose_) {
            System.out.println("Source file is " + file.getAbsolutePath());
            System.out.println("Output directory is " + file2.getAbsolutePath());
        }
        FilterOutputStream filterOutputStream = null;
        String string = file2.getAbsolutePath();
        JarMap jarMap = null;
        if (this.additionalFiles_.size() != 0) {
            System.err.println("Warning: Additional files were specified.  They are ignored by extract().");
        }
        try {
            try {
                jarMap = new JarMap(file, this.verbose_);
                Vector vector = this.identifyDependencies(jarMap);
                if (jarMap.hasManifest() && !vector.contains(MANIFEST_ENTRY_NAME)) {
                    int n = vector.indexOf(MANIFEST_DIR_NAME);
                    if (n == -1) {
                        vector.insertElementAt(MANIFEST_DIR_NAME, 0);
                        n = 0;
                    }
                    vector.insertElementAt(MANIFEST_ENTRY_NAME, n + 1);
                }
                if (this.verbose_) {
                    System.out.println("Extracting files");
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    String string2 = (String)enumeration.nextElement();
                    String string3 = JarMaker.generateFilePath(string, string2);
                    if (this.verbose_) {
                        System.out.print(".");
                    }
                    if (string2.endsWith("/")) {
                        object = new File(string3.substring(0, string3.length() - 1));
                        if (((File)object).exists() || ((File)object).mkdirs()) continue;
                        throw new IOException(((File)object).getAbsolutePath() + ": Cannot create directory.");
                    }
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(string3), 2048);
                    object = jarMap.getEntry(string2);
                    if (object == null) {
                        throw new FileNotFoundException(string2);
                    }
                    InputStream inputStream = jarMap.getInputStream((ZipEntry)object);
                    JarMaker.copyBytes(inputStream, filterOutputStream, ((ZipEntry)object).getSize());
                    ((BufferedOutputStream)filterOutputStream).flush();
                    filterOutputStream.close();
                    filterOutputStream = null;
                    inputStream.close();
                }
                Object var13_15 = null;
                if (jarMap != null) {
                    jarMap.close();
                }
                if (filterOutputStream == null) return;
                if (this.verbose_) {
                    System.out.println("Closing destination file");
                }
            }
            catch (ZipException zipException) {
                System.err.println("Error: ZipException when extracting source file");
                System.err.println("       " + file.getAbsolutePath() + ":");
                System.err.println(zipException.toString());
                throw zipException;
            }
            catch (IOException iOException) {
                System.err.println("Error: IOException when extracting source file");
                System.err.println("       " + file.getAbsolutePath() + ":");
                System.err.println(iOException.toString());
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (jarMap != null) {
                jarMap.close();
            }
            if (filterOutputStream == null) throw throwable;
            if (this.verbose_) {
                System.out.println("Closing destination file");
            }
            filterOutputStream.close();
            throw throwable;
        }
        filterOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAnalysisEvent(boolean bl, String string) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.eventListeners_.clone();
        }
        object = new JarMakerEvent(this, string);
        for (int i = 0; i < vector.size(); ++i) {
            JarMakerListener jarMakerListener = (JarMakerListener)vector.elementAt(i);
            if (bl) {
                jarMakerListener.dependencyAnalysisStarted((JarMakerEvent)object);
                continue;
            }
            jarMakerListener.dependencyAnalysisCompleted((JarMakerEvent)object);
        }
    }

    private static Vector generateDirEntries(String string, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string2 = string.substring(0, string.lastIndexOf("/") + 1);
        if (string2.length() != 0) {
            int n = string2.indexOf("/");
            while (n != -1 && n < string.length() - 1) {
                String string3 = string2.substring(0, n + 1);
                if (!vector.contains(string3)) {
                    vector2.addElement(string3);
                }
                n = string2.indexOf("/", n + 1);
            }
        }
        return vector2;
    }

    static String generateFilePath(File file, String string) {
        if (file == null) {
            throw new NullPointerException("baseDirectory");
        }
        return JarMaker.generateFilePath(file.getAbsolutePath(), string);
    }

    static String generateFilePath(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("basePath");
        }
        if (string2 == null) {
            throw new NullPointerException("entryName");
        }
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        if (stringBuffer.charAt(stringBuffer.length() - 1) != FILE_SEPARATOR) {
            stringBuffer.append(FILE_SEPARATOR);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string2.trim().replace('/', FILE_SEPARATOR));
        stringBuffer.append(stringBuffer2);
        String string3 = stringBuffer.toString();
        return string3;
    }

    private static Hashtable generateJarEntryMap(Hashtable hashtable) {
        Hashtable<File, String> hashtable2 = hashtable.size() != 0 ? new Hashtable(hashtable.size()) : new Hashtable<File, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            File file2 = (File)hashtable.get(file);
            String string = JarMaker.generateJarEntryName(file, file2);
            hashtable2.put(file, string);
        }
        return hashtable2;
    }

    private static String generateJarEntryName(File file, File file2) {
        String string;
        String string2 = file.getAbsolutePath();
        if (string2.startsWith(string = file2.getAbsolutePath())) {
            string2 = string2.substring(string.length());
        } else {
            System.err.println("Warning: File path does not begin with base path for additional files.");
            System.err.println("   File path: " + string2);
            System.err.println("   Base path: " + string);
        }
        String string3 = string2.replace(FILE_SEPARATOR, '/');
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public Vector getAdditionalFiles() {
        Vector<File> vector = new Vector<File>();
        Enumeration enumeration = this.additionalFiles_.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((File)enumeration.nextElement());
        }
        return vector;
    }

    static byte[] getBytes(File file) throws IOException {
        long l = file.length();
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n = ((InputStream)fileInputStream).read(byArray);
            if ((long)n < l) {
                throw new IOException(file.getAbsolutePath() + ": Failed to read entire file.");
            }
        }
        catch (IOException iOException) {
            System.err.println("Error: IOException when reading file");
            System.err.println("       " + file.getAbsolutePath() + ":");
            System.err.println(iOException.toString());
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return byArray;
    }

    File getDestinationJar() {
        return this.destinationJarFile_;
    }

    private static Vector getEntryNamesForPackage(String string, JarMap jarMap) {
        Vector<String> vector = new Vector<String>();
        int n = string.length();
        Enumeration enumeration = jarMap.elements();
        block3: while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            switch (n) {
                case 0: {
                    if (string2.indexOf(47) != -1) continue block3;
                    vector.addElement(string2);
                    continue block3;
                }
            }
            if (!string2.startsWith(string) || string2.lastIndexOf(47) != n) continue;
            vector.addElement(string2);
        }
        return vector;
    }

    File getExtractionDirectory() {
        return this.baseDirectoryForExtract_;
    }

    private Vector getReferencedEntries(String string, JarMap jarMap) throws IOException {
        if (this.verbose_) {
            System.out.print(".");
        }
        ZipEntry zipEntry = jarMap.getEntry(string);
        String string2 = zipEntry.getName();
        String string3 = "";
        int n = string2.lastIndexOf(47);
        if (n != -1) {
            string3 = string2.substring(0, n).replace('/', '.');
        }
        InputStream inputStream = jarMap.getInputStream(zipEntry);
        Vector vector = this.prescanForClassIndexes(inputStream, string3, jarMap);
        inputStream.close();
        inputStream = jarMap.getInputStream(zipEntry);
        Vector vector2 = this.processBytecodeStream(inputStream, string3, jarMap, vector);
        inputStream.close();
        return vector2;
    }

    public Vector getRequiredFiles() {
        return this.filesRequired_;
    }

    public Vector getFilesRequired() {
        return this.filesRequired_;
    }

    public Vector getFilesExcluded() {
        return this.filesExcluded_;
    }

    public Vector getPackages() {
        return this.packages_;
    }

    public Vector getPackagesExcluded() {
        return this.packagesExcluded_;
    }

    File getSourceJar() {
        return this.sourceJarFile_;
    }

    int getSplitSize() {
        return this.splitSize_;
    }

    String[] getUnrecognizedArgs() {
        return this.arguments_.getUnrecognized();
    }

    private Vector identifyDependencies(JarMap jarMap) throws IOException {
        if (this.verbose_) {
            System.out.println("Analyzing source file");
        }
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = jarMap.entries();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(((ZipEntry)enumeration.nextElement()).getName());
        }
        vector2.removeElement(MANIFEST_ENTRY_NAME);
        Vector vector3 = new Vector();
        JarMaker.copyVector(this.filesRequired_, vector3, false);
        JarMaker.copyVector(this.filesExcluded_, this.dependenciesToExclude_, true);
        vector3 = this.adjustDependencies1(vector3, jarMap);
        if (vector3.size() == 0) {
            if (this.verbose_) {
                System.out.println("No required JAR or ZIP entries were specified");
            }
        } else {
            if (this.verbose_) {
                System.out.println("Analyzing " + vector3.size() + " required entries, starting with " + vector3.elementAt(0) + ".");
            }
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                if (!jarMap.contains(string)) {
                    System.err.println("Warning: The source file does not contain the specified required file: " + string);
                    vector3.removeElement(string);
                    continue;
                }
                if (!vector2.contains(string)) continue;
                vector2.removeElement(string);
                this.analyzeJarEntry(string, vector2, vector, jarMap);
                JarMaker.addElement(vector, string);
            }
            if (this.verbose_) {
                System.out.println();
            }
        }
        if (vector.size() == 0 && this.packages_.size() == 0) {
            JarMaker.copyVector(jarMap.getEntryNames(), vector, false);
        }
        vector = this.adjustDependencies2(vector, jarMap);
        JarMaker.removeElements(vector, this.filesExcluded_);
        vector = JarMaker.sortStrings(vector);
        vector = JarMaker.insertDirectoryEntries(vector);
        return vector;
    }

    private static Vector insertDirectoryEntries(Vector vector) {
        String string = new String("");
        Vector<String> vector2 = new Vector<String>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
            if (!string3.equals(string)) {
                string = string3;
                int n = string3.indexOf("/");
                while (n != -1) {
                    String string4 = string3.substring(0, n + 1);
                    if (!vector2.contains(string4) && !string4.equals(string2)) {
                        vector2.addElement(string4);
                    }
                    n = string3.indexOf("/", n + 1);
                }
            }
            vector2.addElement(string2);
        }
        return vector2;
    }

    boolean isExtract() {
        return this.extract_;
    }

    boolean isOptionInfoSufficient() {
        return this.arguments_.isOptionInfoSufficient();
    }

    boolean isSplit() {
        return this.split_;
    }

    boolean isVerbose() {
        return this.verbose_;
    }

    public File makeJar(File file) throws FileNotFoundException, IOException, ZipException {
        if (file == null) {
            throw new NullPointerException("sourceJarFile");
        }
        File file2 = JarMaker.setupDefaultDestinationJarFile(file);
        this.makeJar(file, file2);
        return file2;
    }

    /*
     * Loose catch block
     */
    public void makeJar(File file, File file2) throws FileNotFoundException, IOException, ZipException {
        block42: {
            Exception exception2222;
            FilterOutputStream filterOutputStream;
            ZipOutputStream zipOutputStream;
            ManifestMap manifestMap;
            JarMap jarMap;
            block40: {
                block41: {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Serializable serializable;
                    Serializable serializable2;
                    if (file == null) {
                        throw new NullPointerException("sourceJarFile");
                    }
                    if (file2 == null) {
                        throw new NullPointerException("destinationJarFile");
                    }
                    if (!file.exists()) {
                        throw new FileNotFoundException(file.getAbsolutePath());
                    }
                    if (file2.exists() && !file2.canWrite()) {
                        System.err.println("Error: Cannot write file");
                        System.err.println("       " + file2.getAbsolutePath());
                        throw new IOException(file2.getAbsolutePath());
                    }
                    if (this.verbose_) {
                        System.out.println("Source file is " + file.getAbsolutePath());
                        System.out.println("Destination file is " + file2.getAbsolutePath());
                    }
                    if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
                        System.err.println("Error: Destination file is same as source file.");
                        throw new IllegalArgumentException("destinationJarFile(" + file2.getAbsolutePath() + ")");
                    }
                    jarMap = null;
                    manifestMap = null;
                    zipOutputStream = null;
                    filterOutputStream = null;
                    jarMap = new JarMap(file, this.verbose_);
                    Vector vector = this.identifyDependencies(jarMap);
                    Enumeration enumeration = this.additionalFiles_.keys();
                    while (enumeration.hasMoreElements()) {
                        serializable2 = (File)enumeration.nextElement();
                        if (((File)serializable2).exists() && ((File)serializable2).isFile()) continue;
                        System.err.println("Error: A specified additional file was not found:");
                        System.err.println("       " + ((File)serializable2).getAbsolutePath());
                    }
                    serializable2 = JarMaker.generateJarEntryMap(this.additionalFiles_);
                    if (this.verbose_) {
                        System.out.println();
                        System.out.println("Opening destination file " + file2.getAbsolutePath());
                    }
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 2048);
                    zipOutputStream = new ZipOutputStream(filterOutputStream);
                    if (jarMap.hasManifest()) {
                        manifestMap = new ManifestMap(jarMap);
                        serializable = new StringBuffer();
                        object5 = manifestMap.getHeader();
                        if (((String)object5).length() != 0) {
                            ((StringBuffer)serializable).append((String)object5);
                        }
                        object4 = manifestMap.elements();
                        while (object4.hasMoreElements()) {
                            object3 = (String)object4.nextElement();
                            if (!vector.contains(object3) || ((Hashtable)serializable2).contains(object3)) continue;
                            object2 = manifestMap.get((String)object3);
                            ((StringBuffer)serializable).append((String)object2);
                        }
                        if (this.additionalFiles_.size() != 0) {
                            if (this.verbose_) {
                                System.out.println("Creating manifest entries for additional files");
                            }
                            object3 = this.additionalFiles_.keys();
                            while (object3.hasMoreElements()) {
                                object2 = (File)object3.nextElement();
                                object = (String)((Hashtable)serializable2).get(object2);
                                JarMaker.constructManifestEntry((StringBuffer)serializable, (File)object2, (String)object);
                            }
                        }
                        object3 = ((StringBuffer)serializable).toString().getBytes();
                        object2 = new ZipEntry(MANIFEST_ENTRY_NAME);
                        ((ZipEntry)object2).setSize(((Enumeration<K>)object3).length);
                        zipOutputStream.putNextEntry((ZipEntry)object2);
                        zipOutputStream.write((byte[])object3);
                        ((FilterOutputStream)zipOutputStream).flush();
                        ((BufferedOutputStream)filterOutputStream).flush();
                        zipOutputStream.closeEntry();
                        ((BufferedOutputStream)filterOutputStream).flush();
                    }
                    serializable = new Vector();
                    object5 = vector.elements();
                    while (object5.hasMoreElements()) {
                        object4 = (String)object5.nextElement();
                        if (this.verbose_) {
                            System.out.print(".");
                        }
                        if (((Hashtable)serializable2).contains(object4)) continue;
                        if (((String)object4).endsWith("/")) {
                            ((Vector)serializable).addElement(object4);
                        }
                        if ((object3 = jarMap.getEntry((String)object4)) == null) {
                            if (((String)object4).endsWith("/")) continue;
                            throw new IOException((String)object4 + ": No such entry in source file.");
                        }
                        object2 = jarMap.getInputStream((ZipEntry)object3);
                        JarMaker.copyZipEntry(object3, (InputStream)object2, zipOutputStream);
                        ((FilterOutputStream)zipOutputStream).flush();
                        ((BufferedOutputStream)filterOutputStream).flush();
                        zipOutputStream.closeEntry();
                        ((BufferedOutputStream)filterOutputStream).flush();
                        ((InputStream)object2).close();
                    }
                    if (this.verbose_) {
                        System.out.println();
                    }
                    object4 = this.additionalFiles_.keys();
                    while (object4.hasMoreElements()) {
                        Object object6;
                        Object object7;
                        object3 = (File)object4.nextElement();
                        object2 = (String)((Hashtable)serializable2).get(object3);
                        object = JarMaker.generateDirEntries((String)object2, (Vector)serializable);
                        Enumeration enumeration2 = ((Vector)object).elements();
                        while (enumeration2.hasMoreElements()) {
                            object7 = (String)enumeration2.nextElement();
                            object6 = new ZipEntry((String)object7);
                            ((ZipEntry)object6).setSize(0L);
                            zipOutputStream.putNextEntry((ZipEntry)object6);
                            ((FilterOutputStream)zipOutputStream).flush();
                            ((BufferedOutputStream)filterOutputStream).flush();
                            zipOutputStream.closeEntry();
                            ((BufferedOutputStream)filterOutputStream).flush();
                            ((Vector)serializable).addElement(object7);
                        }
                        object7 = new ZipEntry((String)object2);
                        ((ZipEntry)object7).setSize(((File)object3).length());
                        ((ZipEntry)object7).setTime(((File)object3).lastModified());
                        object6 = new BufferedInputStream(new FileInputStream((File)object3), 2048);
                        zipOutputStream.putNextEntry((ZipEntry)object7);
                        JarMaker.copyBytes((InputStream)object6, zipOutputStream, ((ZipEntry)object7).getSize());
                        ((FilterOutputStream)zipOutputStream).flush();
                        ((BufferedOutputStream)filterOutputStream).flush();
                        zipOutputStream.closeEntry();
                        ((BufferedOutputStream)filterOutputStream).flush();
                        ((InputStream)object6).close();
                    }
                    Object var20_21 = null;
                    if (manifestMap != null) {
                        manifestMap.close();
                    }
                    if (jarMap != null) {
                        jarMap.close();
                    }
                    if (zipOutputStream == null) break block40;
                    if (!this.verbose_) break block41;
                    System.out.println("Closing destination file");
                }
                try {
                    zipOutputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception2222) {}
            }
            break block42;
            {
                catch (ZipException zipException) {
                    System.err.println("Error: ZipException when writing file");
                    System.err.println("       " + file2.getAbsolutePath() + ":");
                    System.err.println(zipException.toString());
                    throw zipException;
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when writing file");
                    System.err.println("       " + file2.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Exception exception32222;
                Object var20_22 = null;
                if (manifestMap != null) {
                    manifestMap.close();
                }
                if (jarMap != null) {
                    jarMap.close();
                }
                if (zipOutputStream != null) {
                    if (this.verbose_) {
                        System.out.println("Closing destination file");
                    }
                    try {
                        zipOutputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    boolean parseArgs(String[] stringArray, boolean bl) {
        boolean bl2 = false;
        this.reset();
        if (this.arguments_.parse(stringArray, this, bl)) {
            bl2 = true;
        }
        return bl2;
    }

    private Vector prescanForClassIndexes(InputStream inputStream, String string, JarMap jarMap) throws IOException {
        Vector<Short> vector = new Vector<Short>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readInt();
        dataInputStream.readShort();
        dataInputStream.readShort();
        short s = dataInputStream.readShort();
        block9: for (short s2 = 1; s2 < s; s2 = (short)(s2 + 1)) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 1: {
                    short s3 = dataInputStream.readShort();
                    dataInputStream.skipBytes(s3);
                    continue block9;
                }
                case 3: 
                case 4: {
                    dataInputStream.skipBytes(4);
                    continue block9;
                }
                case 5: 
                case 6: {
                    dataInputStream.skipBytes(8);
                    s2 = (short)(s2 + 1);
                    continue block9;
                }
                case 7: {
                    short s4 = dataInputStream.readShort();
                    vector.addElement(new Short(s4));
                    continue block9;
                }
                case 8: {
                    dataInputStream.skipBytes(2);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.skipBytes(2);
                    dataInputStream.skipBytes(2);
                    continue block9;
                }
                case 12: {
                    dataInputStream.skipBytes(2);
                    dataInputStream.skipBytes(2);
                    continue block9;
                }
            }
        }
        return vector;
    }

    private Vector processBytecodeStream(InputStream inputStream, String string, JarMap jarMap, Vector vector) throws IOException {
        Vector<String> vector2 = new Vector<String>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readInt();
        dataInputStream.readShort();
        dataInputStream.readShort();
        short s = dataInputStream.readShort();
        block9: for (short s2 = 1; s2 < s; s2 = (short)(s2 + 1)) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 1: {
                    short s3 = dataInputStream.readShort();
                    if (s3 <= 0) continue block9;
                    byte[] byArray = new byte[s3];
                    dataInputStream.readFully(byArray);
                    String string2 = this.processUtf8(s2, new String(byArray, "UTF8"), vector, string, jarMap);
                    if (string2 == null) continue block9;
                    vector2.addElement(string2);
                    continue block9;
                }
                case 3: 
                case 4: {
                    dataInputStream.skipBytes(4);
                    continue block9;
                }
                case 5: 
                case 6: {
                    dataInputStream.skipBytes(8);
                    s2 = (short)(s2 + 1);
                    continue block9;
                }
                case 7: {
                    short s4 = dataInputStream.readShort();
                    continue block9;
                }
                case 8: {
                    dataInputStream.skipBytes(2);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.skipBytes(2);
                    dataInputStream.skipBytes(2);
                    continue block9;
                }
                case 12: {
                    dataInputStream.skipBytes(2);
                    dataInputStream.skipBytes(2);
                    continue block9;
                }
            }
        }
        return vector2;
    }

    private String processUtf8(short s, String string, Vector vector, String string2, JarMap jarMap) {
        String string3 = null;
        if (vector.contains(new Short(s))) {
            String string4 = string + CLASS_SUFFIX;
            if (jarMap.contains(string4)) {
                string3 = string4;
            }
        } else if (string2.length() != 0 && string.startsWith(string2) || this.jarEntryDefaultPrefix_ != null && (string.startsWith(this.jarEntryDefaultPrefix_) || string.startsWith(this.jarEntryDefaultPrefixDotted_))) {
            String string5 = string.replace('.', '/') + ".properties";
            if (jarMap.contains(string5)) {
                string3 = string5;
            } else {
                String string6 = string.replace('.', '/') + CLASS_SUFFIX;
                if (jarMap.contains(string6)) {
                    string3 = string6;
                }
            }
        } else {
            String string7 = null;
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string7 = string.substring(n).toLowerCase();
            }
            if (string7 != null && (string7.equals(".gif") || string7.equals(".jpg") || string7.equals(".html") || string7.equals(".pdml") || string7.equals(".pcml") || string7.equals(".ser"))) {
                String string8 = null;
                if (string2.length() != 0) {
                    string8 = string2.replace('.', '/') + "/" + string;
                    if (jarMap.contains(string8)) {
                        string3 = string8;
                    } else if (jarMap.contains(string)) {
                        string3 = string;
                    }
                } else if (jarMap.contains(string)) {
                    string3 = string;
                }
            }
        }
        return string3;
    }

    public synchronized void removeJarMakerListener(JarMakerListener jarMakerListener) {
        if (jarMakerListener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners_.removeElement(jarMakerListener);
    }

    public void reset() {
        this.sourceJarFile_ = null;
        this.destinationJarFile_ = null;
        this.filesRequired_.removeAllElements();
        this.filesExcluded_.removeAllElements();
        this.packages_.removeAllElements();
        this.packagesExcluded_.removeAllElements();
        this.additionalFiles_.clear();
        this.verbose_ = false;
        this.extract_ = false;
        this.baseDirectoryForExtract_ = new File(System.getProperty("user.dir"));
        this.split_ = false;
        this.splitSize_ = 2048;
        this.eventListeners_.removeAllElements();
        this.arguments_ = new Arguments();
    }

    public void setAdditionalFiles(Vector vector) {
        File file = new File(System.getProperty("user.dir"));
        this.setAdditionalFiles(vector, file);
    }

    public void setAdditionalFiles(Vector vector, File file) {
        if (vector == null) {
            throw new NullPointerException("fileList");
        }
        if (file == null) {
            throw new NullPointerException("baseDirectory");
        }
        vector = JarMaker.validateList(vector, "additionalFile", "java.io.File", this.verbose_);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            File file2 = (File)enumeration.nextElement();
            if (this.additionalFiles_.containsKey(file2)) continue;
            this.additionalFiles_.put(file2, file);
        }
    }

    void setDestinationJar(File file) {
        if (file == null) {
            throw new NullPointerException("destinationJarFile");
        }
        this.destinationJarFile_ = file;
    }

    void setExtract(boolean bl) {
        this.extract_ = bl;
    }

    void setExtractionDirectory(File file) {
        this.baseDirectoryForExtract_ = file;
    }

    public void setPackages(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("packages");
        }
        vector = JarMaker.validateList(vector, "packageName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.packages_, true);
    }

    public void setPackagesExcluded(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("packages");
        }
        vector = JarMaker.validateList(vector, "packageName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.packagesExcluded_, true);
    }

    public void setRequiredFiles(Vector vector) {
        this.setFilesRequired(vector);
    }

    public void setFilesRequired(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("entryList");
        }
        vector = JarMaker.validateList(vector, "entryName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.filesRequired_, true);
    }

    public void setFilesExcluded(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("entryList");
        }
        vector = JarMaker.validateList(vector, "entryName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.filesExcluded_, true);
    }

    void setSourceJar(File file) {
        if (file == null) {
            throw new NullPointerException("sourceJarFile");
        }
        this.sourceJarFile_ = file;
    }

    void setSplit(boolean bl) {
        this.split_ = bl;
    }

    void setSplitSize(int n) {
        this.splitSize_ = n;
    }

    static File setupDefaultDestinationJarFile(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        String string2 = "Small";
        String string3 = n == -1 ? string + string2 : string.substring(0, n) + string2 + string.substring(n);
        return new File(CURRENT_DIR, string3);
    }

    private static File setupSplitJarFile(File file, int n) {
        String string = file.getName();
        int n2 = string.lastIndexOf(46);
        String string2 = n2 == -1 ? string + n : string.substring(0, n2) + Integer.toString(n) + string.substring(n2);
        return new File(CURRENT_DIR, string2);
    }

    public void setVerbose() {
        this.setVerbose(true);
    }

    public void setVerbose(boolean bl) {
        this.verbose_ = bl;
    }

    static Vector sortStrings(Vector vector) {
        Vector<String> vector2 = new Vector<String>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = false;
            int n = vector2.size();
            Enumeration enumeration2 = vector2.elements();
            int n2 = 0;
            while (!bl && enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (string.compareTo(string2) < 0) {
                    n = n2;
                    bl = true;
                }
                ++n2;
            }
            vector2.insertElementAt(string, n);
        }
        return vector2;
    }

    public Vector split(File file) throws FileNotFoundException, IOException, ZipException {
        return this.split(file, 2048);
    }

    public Vector split(File file, int n) throws FileNotFoundException, IOException, ZipException {
        int n2;
        File file2;
        long l;
        ManifestMap manifestMap;
        JarMap jarMap;
        Vector<File> vector;
        block26: {
            if (file == null) {
                throw new NullPointerException("sourceJarFile");
            }
            if (n < 1) {
                throw new IllegalArgumentException("splitSizeKbytes (" + n + ")");
            }
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            if (this.verbose_) {
                System.out.println("Source file is " + file.getAbsolutePath());
                System.out.println("Split size is " + n + " kilobytes");
            }
            vector = new Vector<File>();
            jarMap = null;
            manifestMap = null;
            Long l2 = new Long(n);
            l = l2 * 1024L;
            file2 = null;
            n2 = 0;
            file2 = JarMaker.setupSplitJarFile(file, n2++);
            if (file.length() > l) break block26;
            JarMaker.copyFile(file, file2);
            vector.addElement(file2);
            Vector<File> vector2 = vector;
            Object var31_14 = null;
            if (manifestMap != null) {
                manifestMap.close();
            }
            if (jarMap != null) {
                jarMap.close();
            }
            return vector2;
        }
        try {
            block27: {
                try {
                    jarMap = new JarMap(file, this.verbose_);
                    manifestMap = new ManifestMap(jarMap);
                    boolean bl = jarMap.hasManifest();
                    int n3 = jarMap.getSizeOfZipMetadataPerEntry();
                    int n4 = jarMap.getSizeOfZipMetadataPerZip();
                    if (bl) {
                        n4 += n3 + 2 * MANIFEST_ENTRY_NAME.length();
                    }
                    Vector<String> vector3 = new Vector<String>();
                    long l3 = n4;
                    Vector<String> vector4 = new Vector<String>();
                    Vector vector5 = new Vector();
                    Enumeration enumeration = jarMap.elements();
                    while (enumeration.hasMoreElements()) {
                        int n5;
                        byte[] byArray;
                        String string = (String)enumeration.nextElement();
                        ZipEntry zipEntry = jarMap.getEntry(string);
                        if (zipEntry == null) {
                            throw new RuntimeException("Programming error: No JarMap entry for " + string);
                        }
                        if (zipEntry.isDirectory()) {
                            vector4.addElement(string);
                        }
                        long l4 = zipEntry.getSize();
                        long l5 = n3 + 2 * string.length();
                        String string2 = zipEntry.getComment();
                        if (string2 != null) {
                            l5 += (long)string2.length();
                        }
                        if ((byArray = zipEntry.getExtra()) != null) {
                            l5 += (long)(2 * byArray.length);
                        }
                        if (bl) {
                            l5 += (long)manifestMap.getEntrySize(string);
                        }
                        if (l4 + l5 + (long)n4 + (long)(n5 = JarMaker.determineDirMetadataSize(vector5 = JarMaker.generateDirEntries(string, vector4), n3)) >= l) {
                            Vector<String> vector6 = new Vector<String>();
                            vector6.addElement(string);
                            JarMaker.writeJarEntries(vector6, file2, jarMap, manifestMap, l, this.verbose_);
                            if (file2.length() > l) {
                                System.err.println("Warning: Oversize ZIP entry " + string);
                                System.err.println("         was written to file " + file2.getAbsolutePath() + ".");
                            }
                            vector.addElement(file2);
                            file2 = JarMaker.setupSplitJarFile(file, n2++);
                            continue;
                        }
                        if (l3 + l4 + l5 + (long)n5 > l) {
                            JarMaker.writeJarEntries(vector3, file2, jarMap, manifestMap, l, this.verbose_);
                            vector3.removeAllElements();
                            vector.addElement(file2);
                            file2 = JarMaker.setupSplitJarFile(file, n2++);
                            l3 = n4;
                            vector4.removeAllElements();
                            vector5 = JarMaker.generateDirEntries(string, vector4);
                            n5 = JarMaker.determineDirMetadataSize(vector5, n3);
                        }
                        vector3.addElement(string);
                        JarMaker.copyVector(vector5, vector4, false);
                        l3 += l4 + l5 + (long)n5;
                    }
                    if (vector3.size() == 0) break block27;
                    JarMaker.writeJarEntries(vector3, file2, jarMap, manifestMap, l, this.verbose_);
                    vector3.removeAllElements();
                    vector.addElement(file2);
                }
                catch (ZipException zipException) {
                    System.err.println("Error: ZipException when splitting file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(zipException.toString());
                    throw zipException;
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when splitting file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
            }
            Object var31_15 = null;
            if (manifestMap != null) {
                manifestMap.close();
            }
            if (jarMap != null) {
                jarMap.close();
            }
        }
        catch (Throwable throwable) {
            Object var31_16 = null;
            if (manifestMap != null) {
                manifestMap.close();
            }
            if (jarMap != null) {
                jarMap.close();
            }
            throw throwable;
        }
        return vector;
    }

    static Vector validateList(Vector vector, String string, String string2, boolean bl) {
        if (vector == null) {
            throw new NullPointerException("list");
        }
        if (string == null) {
            throw new NullPointerException("parmName");
        }
        if (string2 == null) {
            throw new NullPointerException("className");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Programming error: Class not found: " + string2);
        }
        Vector vector2 = new Vector(vector.size());
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object == null) {
                throw new NullPointerException(string);
            }
            if (!clazz.isInstance(object)) {
                String string3 = object.getClass().getName();
                throw new IllegalArgumentException(string + " (object of class " + string3 + ")");
            }
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException(string + " (" + n2 + ")");
                }
            } else if (object instanceof String) {
                String string4 = ((String)object).trim();
                if (string4.length() == 0) {
                    throw new IllegalArgumentException(string + "()");
                }
                object = string4;
            }
            if (!vector2.contains(object)) {
                vector2.addElement(object);
            }
            ++n;
        }
        return vector2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeJarEntries(Vector vector, File file, JarMap jarMap, ManifestMap manifestMap, long l, boolean bl) throws FileNotFoundException, IOException, ZipException {
        BufferedOutputStream bufferedOutputStream;
        ZipOutputStream zipOutputStream;
        block25: {
            if (vector == null) {
                throw new NullPointerException("entryNames");
            }
            if (file == null) {
                throw new NullPointerException("outFile");
            }
            if (jarMap == null) {
                throw new NullPointerException("jarMap");
            }
            if (manifestMap == null) {
                throw new NullPointerException("manifestMap");
            }
            if (bl) {
                System.out.println("writeJarEntries( " + file.getName() + " )");
            }
            zipOutputStream = null;
            bufferedOutputStream = null;
            InputStream inputStream = null;
            try {
                try {
                    Object object;
                    String string;
                    Object object2;
                    Object object3;
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);
                    zipOutputStream = new ZipOutputStream(bufferedOutputStream);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (jarMap.hasManifest()) {
                        object3 = manifestMap.getHeader();
                        if (((String)object3).length() != 0) {
                            stringBuffer.append((String)object3);
                        }
                        object2 = vector.elements();
                        while (object2.hasMoreElements()) {
                            string = (String)object2.nextElement();
                            object = manifestMap.get(string);
                            if (object == null) continue;
                            stringBuffer.append((String)object);
                        }
                    }
                    if (stringBuffer.length() != 0) {
                        object3 = stringBuffer.toString().getBytes();
                        object2 = new ZipEntry(MANIFEST_ENTRY_NAME);
                        ((ZipEntry)object2).setSize(((Vector<E>)object3).length);
                        try {
                            zipOutputStream.putNextEntry((ZipEntry)object2);
                            zipOutputStream.write((byte[])object3);
                            ((FilterOutputStream)zipOutputStream).flush();
                            bufferedOutputStream.flush();
                            zipOutputStream.closeEntry();
                            bufferedOutputStream.flush();
                        }
                        catch (ZipException zipException) {
                            System.err.println("Error: ZipException for manifest entry");
                            System.err.println("       " + ((ZipEntry)object2).getName() + ":");
                            System.err.println(zipException.toString());
                            throw zipException;
                        }
                        catch (IOException iOException) {
                            System.err.println("Error: IOException for manifest entry");
                            System.err.println("       " + ((ZipEntry)object2).getName() + ":");
                            System.err.println(iOException.toString());
                            throw iOException;
                        }
                    }
                    object3 = new Vector<String>();
                    object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        string = (String)object2.nextElement();
                        object = jarMap.getEntry(string);
                        if (object == null) {
                            System.err.println("Error: Entry not found in source file: " + string);
                            continue;
                        }
                        Vector vector2 = JarMaker.generateDirEntries(string, object3);
                        Enumeration enumeration = vector2.elements();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            ZipEntry zipEntry = new ZipEntry(string2);
                            zipEntry.setSize(0L);
                            zipOutputStream.putNextEntry(zipEntry);
                            ((FilterOutputStream)zipOutputStream).flush();
                            bufferedOutputStream.flush();
                            zipOutputStream.closeEntry();
                            bufferedOutputStream.flush();
                            ((Vector)object3).addElement(string2);
                        }
                        inputStream = jarMap.getInputStream((ZipEntry)object);
                        JarMaker.copyZipEntry((ZipEntry)object, inputStream, zipOutputStream);
                        ((FilterOutputStream)zipOutputStream).flush();
                        bufferedOutputStream.flush();
                        zipOutputStream.closeEntry();
                        bufferedOutputStream.flush();
                        inputStream.close();
                        if (!((ZipEntry)object).isDirectory()) continue;
                        ((Vector)object3).addElement(string);
                    }
                    if (file.length() > l) {
                        System.err.println("Error: Generated file exceeds specified size:");
                        System.err.println("       " + file.getAbsolutePath());
                    }
                }
                catch (ZipException zipException) {
                    System.err.println("Error: ZipException when writing to file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(zipException.toString());
                    throw zipException;
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when writing to file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
                Object var20_22 = null;
                if (inputStream == null) break block25;
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (bufferedOutputStream == null) throw throwable;
                bufferedOutputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        if (bufferedOutputStream == null) return;
        bufferedOutputStream.close();
    }

    public static void main(String[] stringArray) {
        try {
            JarMaker jarMaker = new JarMaker();
            if (jarMaker.parseArgs(stringArray, false)) {
                if (jarMaker.isSplit()) {
                    File file = jarMaker.getSourceJar();
                    int n = jarMaker.getSplitSize();
                    jarMaker.split(file, n);
                } else if (jarMaker.isExtract()) {
                    File file = jarMaker.getSourceJar();
                    File file2 = jarMaker.getExtractionDirectory();
                    jarMaker.extract(file, file2);
                } else {
                    File file = jarMaker.getSourceJar();
                    File file3 = jarMaker.getDestinationJar();
                    jarMaker.makeJar(file, file3);
                }
            } else {
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        catch (Error error) {
            System.err.println(error.toString());
            System.exit(1);
        }
        System.exit(0);
    }

    class ManifestMap {
        private Vector entryList_ = new Vector();
        private Hashtable entryMap_ = new Hashtable();
        private JarMap jarMap_;

        ManifestMap(JarMap jarMap) throws IOException, ZipException {
            if (jarMap == null) {
                throw new NullPointerException("jarMap");
            }
            this.jarMap_ = jarMap;
            ZipEntry zipEntry = this.jarMap_.getEntry(JarMaker.MANIFEST_ENTRY_NAME);
            if (zipEntry == null) {
                System.err.println("Warning: Source file has no manifest.  No manifest will be created.");
            } else {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(jarMap.getInputStream(zipEntry)));
                boolean bl = false;
                boolean bl2 = false;
                while (bufferedReader.ready()) {
                    String string = bufferedReader.readLine();
                    if (string == null) continue;
                    if (string.startsWith(JarMaker.MANIFEST_NAME_KEYWORD)) {
                        StringBuffer stringBuffer = new StringBuffer();
                        String string2 = string.substring(JarMaker.MANIFEST_NAME_KEYWORD.length()).trim();
                        stringBuffer.append(string);
                        stringBuffer.append('\n');
                        while (bufferedReader.ready() && string.length() != 0) {
                            string = bufferedReader.readLine();
                            if (string == null) continue;
                            stringBuffer.append(string);
                            stringBuffer.append('\n');
                        }
                        String string3 = stringBuffer.toString();
                        this.entryMap_.put(string2, string3);
                        this.entryList_.addElement(string2);
                        continue;
                    }
                    if (!bl && string.startsWith(JarMaker.MANIFEST_VERSION_KEYWORD)) {
                        bl = true;
                        this.entryMap_.put(JarMaker.MANIFEST_VERSION_KEYWORD, string + '\n');
                        continue;
                    }
                    if (bl2 || !string.startsWith(JarMaker.MANIFEST_REQVERS_KEYWORD)) continue;
                    bl2 = true;
                    this.entryMap_.put(JarMaker.MANIFEST_REQVERS_KEYWORD, string + '\n');
                }
                bufferedReader.close();
            }
        }

        void close() {
            if (JarMaker.this.verbose_) {
                System.out.println("Closing manifest");
            }
            this.entryList_.removeAllElements();
            this.entryMap_.clear();
            this.jarMap_ = null;
        }

        boolean contains(String string) {
            return this.entryList_.contains(string);
        }

        Enumeration elements() {
            return this.entryList_.elements();
        }

        String get(String string) {
            return (String)this.entryMap_.get(string);
        }

        int getEntrySize(String string) {
            int n = 0;
            String string2 = (String)this.entryMap_.get(string);
            if (string2 != null) {
                n = string2.length();
            }
            return n;
        }

        String getHeader() {
            String string = this.get(JarMaker.MANIFEST_VERSION_KEYWORD);
            String string2 = this.get(JarMaker.MANIFEST_REQVERS_KEYWORD);
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
    }

    class JarMap {
        private ZipFile zipFile_;
        private ZipEntry manifest_;
        private Vector entryList_ = new Vector();
        private File jarFile_;
        private boolean verbose_;
        private int zipfileCommentLength_;

        JarMap(File file, boolean bl) throws IOException, ZipException {
            if (file == null) {
                throw new NullPointerException("jarFile");
            }
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            this.zipFile_ = new ZipFile(file);
            this.jarFile_ = file;
            this.verbose_ = bl;
            this.manifest_ = this.zipFile_.getEntry(JarMaker.MANIFEST_ENTRY_NAME);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 2048);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                this.entryList_.addElement(zipEntry.getName());
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            ((InputStream)bufferedInputStream).close();
            this.entryList_.removeElement(JarMaker.MANIFEST_ENTRY_NAME);
        }

        void close() {
            if (this.verbose_) {
                System.out.println("Closing source file");
            }
            this.entryList_.removeAllElements();
            this.manifest_ = null;
            if (this.zipFile_ != null) {
                try {
                    this.zipFile_.close();
                }
                catch (Exception exception) {
                    System.err.println("Error: While closing source file:");
                    System.err.println(exception.toString());
                }
                this.zipFile_ = null;
            }
        }

        boolean contains(String string) {
            return this.entryList_.contains(string);
        }

        Enumeration elements() {
            return this.entryList_.elements();
        }

        Enumeration entries() {
            return this.zipFile_.entries();
        }

        Vector getEntryNames() {
            return this.entryList_;
        }

        ZipEntry getEntry(String string) {
            return this.zipFile_.getEntry(string);
        }

        InputStream getInputStream(ZipEntry zipEntry) throws IOException, ZipException {
            return this.zipFile_.getInputStream(zipEntry);
        }

        ZipEntry getManifest() {
            return this.manifest_;
        }

        int getSizeOfZipMetadataPerZip() {
            int n = 0;
            n += 22;
            return n += this.zipfileCommentLength_;
        }

        int getSizeOfZipMetadataPerEntry() throws IOException, UnsupportedEncodingException {
            return 88;
        }

        boolean hasManifest() {
            return this.manifest_ != null;
        }
    }

    class Arguments {
        private Vector unrecognizedArgs_ = new Vector();
        private boolean optionsAreSufficient_;
        private boolean expectingSource_;
        private boolean expectingDestination_;
        private boolean expectingFileRequired_;
        private boolean expectingFileExcluded_;
        private boolean expectingAdditionalFile_;
        private boolean expectingFilesDir_;
        private boolean expectingPackage_;
        private boolean expectingPackageExcluded_;
        private boolean expectingExtractionDir_;
        private boolean expectingSplitSize_;

        Arguments() {
        }

        String[] getUnrecognized() {
            Object[] objectArray = new String[this.unrecognizedArgs_.size()];
            this.unrecognizedArgs_.copyInto(objectArray);
            return objectArray;
        }

        boolean isOptionInfoSufficient() {
            return this.optionsAreSufficient_;
        }

        boolean parse(String[] stringArray, JarMaker jarMaker, boolean bl) {
            boolean bl2 = false;
            Vector<String> vector = null;
            Vector<String> vector2 = null;
            Vector<File> vector3 = null;
            File file = null;
            Vector<String> vector4 = null;
            Vector<String> vector5 = null;
            Object var11_11 = null;
            boolean bl3 = true;
            this.unrecognizedArgs_ = new Vector();
            if (stringArray.length == 0) {
                System.err.println("Error: No options were specified.");
                if (!bl) {
                    this.printUsage(System.err);
                }
                return false;
            }
            boolean bl4 = false;
            boolean bl5 = true;
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                if (stringArray[i].charAt(0) == '-') {
                    object = stringArray[i].toLowerCase();
                    this.resetExpectations();
                    bl4 = false;
                    if (((String)object).equals("-s") || ((String)object).startsWith("-src") || ((String)object).startsWith("-so")) {
                        this.expectingSource_ = true;
                    } else if (((String)object).equals("-d") || ((String)object).startsWith("-dest")) {
                        this.expectingDestination_ = true;
                    } else if (((String)object).equals("-fx") || ((String)object).startsWith("-fileex") || ((String)object).startsWith("-filesex")) {
                        this.expectingFileExcluded_ = true;
                    } else if (((String)object).equals("-fr") || ((String)object).startsWith("-file") || ((String)object).equals("-rf") || ((String)object).startsWith("-req")) {
                        this.expectingFileRequired_ = true;
                    } else if (((String)object).equals("-afd") || ((String)object).startsWith("-additionalfilesdir")) {
                        this.expectingFilesDir_ = true;
                    } else if (((String)object).equals("-af") || ((String)object).startsWith("-additional")) {
                        this.expectingAdditionalFile_ = true;
                    } else if (((String)object).equals("-px") || ((String)object).startsWith("-packageex") || ((String)object).startsWith("-packagesex")) {
                        this.expectingPackageExcluded_ = true;
                    } else if (((String)object).equals("-p") || ((String)object).startsWith("-package")) {
                        this.expectingPackage_ = true;
                    } else if (((String)object).equals("-x") || ((String)object).startsWith("-extract")) {
                        jarMaker.setExtract(true);
                        this.expectingExtractionDir_ = true;
                    } else if (((String)object).startsWith("-sp")) {
                        jarMaker.setSplit(true);
                        this.expectingSplitSize_ = true;
                    } else if (((String)object).startsWith("-v")) {
                        jarMaker.setVerbose(true);
                    } else if (((String)object).startsWith("-h")) {
                        JarMaker.this.requestedUsageInfo_ = true;
                    } else {
                        this.unrecognizedArgs_.addElement(stringArray[i]);
                        if (!bl) {
                            System.err.println("Error: Unrecognized option: " + stringArray[i]);
                            bl4 = true;
                            bl3 = false;
                        }
                    }
                } else {
                    if (bl4) {
                        this.unrecognizedArgs_.addElement(stringArray[i]);
                        if (!bl) {
                            System.err.println("Error: Argument after unrecognized option: " + stringArray[i]);
                            bl3 = false;
                        }
                    } else if (bl5 || this.expectingSource_) {
                        this.expectingSource_ = false;
                        JarMaker.this.setSourceJar(new File(stringArray[i]));
                    } else if (this.expectingDestination_) {
                        this.expectingDestination_ = false;
                        JarMaker.this.setDestinationJar(new File(stringArray[i]));
                        bl2 = true;
                    } else if (this.expectingFileRequired_) {
                        object = new StringTokenizer(stringArray[i], ",");
                        if (((StringTokenizer)object).countTokens() != 0) {
                            this.expectingFileRequired_ = false;
                            if (vector == null) {
                                vector = new Vector<String>(((StringTokenizer)object).countTokens());
                            }
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                vector.addElement(((StringTokenizer)object).nextToken());
                            }
                        }
                    } else if (this.expectingFileExcluded_) {
                        object = new StringTokenizer(stringArray[i], ",");
                        if (((StringTokenizer)object).countTokens() != 0) {
                            this.expectingFileExcluded_ = false;
                            if (vector2 == null) {
                                vector2 = new Vector<String>(((StringTokenizer)object).countTokens());
                            }
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                vector2.addElement(((StringTokenizer)object).nextToken());
                            }
                        }
                    } else if (this.expectingPackage_) {
                        object = new StringTokenizer(stringArray[i], ",");
                        if (((StringTokenizer)object).countTokens() != 0) {
                            this.expectingPackage_ = false;
                            if (vector4 == null) {
                                vector4 = new Vector<String>(((StringTokenizer)object).countTokens());
                            }
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                vector4.addElement(((StringTokenizer)object).nextToken());
                            }
                        }
                    } else if (this.expectingPackageExcluded_) {
                        object = new StringTokenizer(stringArray[i], ",");
                        if (((StringTokenizer)object).countTokens() != 0) {
                            this.expectingPackageExcluded_ = false;
                            if (vector5 == null) {
                                vector5 = new Vector<String>(((StringTokenizer)object).countTokens());
                            }
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                vector5.addElement(((StringTokenizer)object).nextToken());
                            }
                        }
                    } else if (this.expectingAdditionalFile_) {
                        object = new StringTokenizer(stringArray[i], ",");
                        if (((StringTokenizer)object).countTokens() != 0) {
                            this.expectingAdditionalFile_ = false;
                            if (vector3 == null) {
                                vector3 = new Vector<File>(((StringTokenizer)object).countTokens());
                            }
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                vector3.addElement(new File(((StringTokenizer)object).nextToken()));
                            }
                        }
                    } else if (this.expectingFilesDir_) {
                        this.expectingFilesDir_ = false;
                        file = new File(stringArray[i]);
                    } else if (this.expectingExtractionDir_) {
                        this.expectingExtractionDir_ = false;
                        jarMaker.setExtractionDirectory(new File(stringArray[i]));
                    } else if (this.expectingSplitSize_) {
                        this.expectingSplitSize_ = false;
                        int n = 0;
                        boolean bl6 = false;
                        try {
                            n = Integer.parseInt(stringArray[i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Error: Non-integer split size: " + stringArray[i]);
                            bl3 = false;
                            bl6 = true;
                        }
                        if (!bl6) {
                            jarMaker.setSplitSize(n);
                        }
                    } else {
                        this.unrecognizedArgs_.addElement(stringArray[i]);
                        if (!bl) {
                            System.err.println("Error: Unrecognized argument: " + stringArray[i]);
                            bl3 = false;
                        }
                    }
                    bl4 = false;
                    this.resetExpectations();
                }
                bl5 = false;
            }
            this.resetExpectations();
            if (JarMaker.this.requestedUsageInfo_) {
                if (bl) {
                    return bl3;
                }
                this.printUsage(System.out);
                return false;
            }
            if (jarMaker.getSourceJar() == null) {
                System.err.println("Error: Source JAR or ZIP file was not specified.");
                bl3 = false;
            } else if (jarMaker.isSplit()) {
                this.optionsAreSufficient_ = true;
                jarMaker.setExtract(false);
                if (bl2 || vector != null || vector2 != null || vector4 != null || vector5 != null || vector3 != null) {
                    System.err.println("Warning: When -split is specified, all other options are ignored, except -source, and -verbose.");
                }
            } else {
                if (vector == null && vector2 == null && vector3 == null && vector4 == null && vector5 == null && !jarMaker.isExtract()) {
                    if (this.unrecognizedArgs_.size() == 0 || !bl) {
                        System.err.println("Error: Need to specify more options.");
                        bl3 = false;
                    }
                } else {
                    this.optionsAreSufficient_ = true;
                }
                if (jarMaker.isExtract() && (bl2 || vector3 != null)) {
                    System.err.println("Warning: When -extract is specified, the following options are ignored: -destination, -additionalFile, and -additionalFilesDirectory.");
                }
                if (!bl2) {
                    File file2 = JarMaker.setupDefaultDestinationJarFile(jarMaker.getSourceJar());
                    jarMaker.setDestinationJar(file2);
                }
                if (file == null) {
                    file = new File(System.getProperty("user.dir"));
                }
                if (vector3 != null) {
                    JarMaker.this.setAdditionalFiles(vector3, file);
                }
                if (vector != null) {
                    JarMaker.this.setFilesRequired(vector);
                }
                if (vector2 != null) {
                    JarMaker.this.setFilesExcluded(vector2);
                }
                if (vector4 != null) {
                    if (vector4.size() > 0) {
                        JarMaker.this.setPackages(vector4);
                    } else {
                        bl3 = false;
                    }
                }
                if (vector5 != null) {
                    if (vector5.size() > 0) {
                        JarMaker.this.setPackagesExcluded(vector5);
                    } else {
                        bl3 = false;
                    }
                }
            }
            if (!bl && !bl3) {
                this.printUsage(System.err);
            }
            return bl3;
        }

        private void printUsage(PrintStream printStream) {
            printStream.println("");
            printStream.println("Usage: ");
            printStream.println("");
            printStream.println("  JarMaker -source sourceJarFile");
            printStream.println("           [-destination jarFile]");
            printStream.println("           [-fileRequired entry1[,entry2[...]]]");
            printStream.println("           [-fileExcluded entry1[,entry2[...]]]");
            printStream.println("           [-additionalFile file1[,file2[...]]]");
            printStream.println("           [-additionalFilesDirectory directory");
            printStream.println("           [-package pkg1[,pkg2[...]]]");
            printStream.println("           [-packageExcluded pkg1[,pkg2[...]]]");
            printStream.println("           [-extract [directory]]");
            printStream.println("           [-split [kilobytes]]");
            printStream.println("           [-verbose]");
            printStream.println("           [-help]");
            printStream.println("");
            printStream.println("At least one of the following options must be specified: ");
            printStream.println("-fileRequired, -fileExcluded, -additionalFile, -package, -packageExcluded, -extract, -split");
        }

        private void resetExpectations() {
            if (this.expectingSource_) {
                System.err.println("Warning: No file specified after -source.");
            }
            if (this.expectingDestination_) {
                System.err.println("Warning: No file specified after -destination.");
            }
            if (this.expectingFileRequired_) {
                System.err.println("Warning: No file specified after -fileRequired.");
            }
            if (this.expectingAdditionalFile_) {
                System.err.println("Warning: No file specified after -additionalFile.");
            }
            if (this.expectingFilesDir_) {
                System.err.println("Warning: No directory specified after -additionalFilesDirectory.");
            }
            if (this.expectingPackage_) {
                System.err.println("Warning: No package specified after -package.");
            }
            if (this.expectingPackageExcluded_) {
                System.err.println("Warning: No package specified after -packageExcluded.");
            }
            this.expectingSource_ = false;
            this.expectingDestination_ = false;
            this.expectingFileRequired_ = false;
            this.expectingAdditionalFile_ = false;
            this.expectingFilesDir_ = false;
            this.expectingPackage_ = false;
            this.expectingPackageExcluded_ = false;
            this.expectingExtractionDir_ = false;
            this.expectingSplitSize_ = false;
        }
    }
}

