/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.AS400JPing;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class JPing {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String sys_;
    private static int srv_;
    private static boolean ssl_;
    private static long time_;
    private static ResourceBundle resource_;

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        if (stringArray.length == 0) {
            printWriter.println();
            JPing.usage();
        }
        try {
            JPing.parseParms(stringArray);
            AS400JPing aS400JPing = new AS400JPing(sys_, srv_, ssl_);
            aS400JPing.setTimeout(time_);
            aS400JPing.setPrintWriter(System.out);
            printWriter.println();
            printWriter.print(resource_.getString("JPING_VERIFYING"));
            printWriter.print(sys_);
            printWriter.println("...");
            printWriter.println();
            boolean bl = aS400JPing.ping();
            if (bl) {
                printWriter.println(resource_.getString("JPING_VERIFIED"));
            } else {
                printWriter.println(resource_.getString("JPING_NOTVERIFIED"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            if (Trace.isTraceOn()) {
                Trace.log(2, exception);
            }
            System.exit(0);
        }
    }

    private static void parseParms(String[] stringArray) throws Exception {
        String string;
        Vector<String> vector = new Vector<String>();
        vector.addElement("-service");
        vector.addElement("-ssl");
        vector.addElement("-timeout");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("-help", "-h");
        hashtable.put("-?", "-h");
        hashtable.put("-s", "-service");
        hashtable.put("-t", "-timeout");
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, vector, hashtable);
        if (commandLineArguments.getOptionValue("-h") != null) {
            JPing.usage();
        }
        sys_ = commandLineArguments.getOptionValue("");
        String string2 = commandLineArguments.getOptionValue("-service");
        if (string2 != null) {
            if (string2.equals("as-file")) {
                srv_ = 0;
            } else if (string2.equals("as-netprt")) {
                srv_ = 1;
            } else if (string2.equals("as-rmtcmd")) {
                srv_ = 2;
            } else if (string2.equals("as-dtaq")) {
                srv_ = 3;
            } else if (string2.equals("as-database")) {
                srv_ = 4;
            } else if (string2.equals("as-ddm")) {
                srv_ = 5;
            } else if (string2.equals("as-central")) {
                srv_ = 6;
            } else if (string2.equals("as-signon")) {
                srv_ = 7;
            } else {
                throw new ExtendedIllegalArgumentException("service", 2);
            }
        }
        if (commandLineArguments.getOptionValue("-ssl") != null) {
            ssl_ = true;
        }
        if ((string = commandLineArguments.getOptionValue("-timeout")) != null) {
            time_ = new Integer(string).intValue();
        }
    }

    static void usage() {
        System.out.println();
        System.out.println(resource_.getString("JPING_USAGE"));
        System.out.println(resource_.getString("JPING_HELP"));
        System.out.println(resource_.getString("JPING_SERVICE") + resource_.getString("JPING_SERVICE2") + resource_.getString("JPING_SERVICE3"));
        System.out.println(resource_.getString("JPING_SSL"));
        System.out.println(resource_.getString("JPING_TIMEOUT"));
        System.exit(0);
    }

    static {
        srv_ = 99;
        ssl_ = false;
        time_ = 20000L;
        resource_ = ResourceBundle.getBundle("utilities.UTMRI");
    }
}

