/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDBClob
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int length_ = 0;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private String value_;
    private Object savedObject_;

    SQLDBClob(int n, SQLConversionSettings sQLConversionSettings) {
        this.maxLength_ = n;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.value_ = "";
    }

    public Object clone() {
        return new SQLDBClob(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToInt(byArray, n);
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.value_ = convTable.byteArrayToString(byArray, n + 4, this.length_ * 2, bidiConversionProperties);
        this.savedObject_ = null;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        BinaryConverter.intToByteArray(this.length_, byArray, n);
        try {
            int n2 = this.settings_.getBidiStringType();
            if (n2 == -1) {
                n2 = convTable.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            convTable.stringToByteArray(this.value_, byArray, n + 4, this.maxLength_, bidiConversionProperties);
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            this.truncated_ = string.length() > this.maxLength_ ? string.length() - this.maxLength_ : 0;
        } else if (JDUtilities.JDBCLevel_ >= 20 && !(object instanceof Clob) && !(object instanceof Reader)) {
            JDError.throwSQLException(this, "07006");
        }
        this.savedObject_ = object;
        if (n != -1) {
            this.length_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        try {
            int n;
            Object object = this.savedObject_;
            if (this.savedObject_ instanceof String) {
                this.value_ = (String)object;
            } else if (object instanceof Reader) {
                if (this.length_ >= 0) {
                    try {
                        n = this.length_ < 262144 ? this.length_ : 262144;
                        Reader reader = (Reader)object;
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[n];
                        int n2 = 0;
                        int n3 = reader.read(cArray, 0, n);
                        while (n3 > -1 && n2 < this.length_) {
                            stringBuffer.append(cArray, 0, n3);
                            int n4 = this.length_ - (n2 += n3);
                            if (n4 < n) {
                                n = n4;
                            }
                            n3 = reader.read(cArray, 0, n);
                        }
                        this.value_ = stringBuffer.toString();
                    }
                    catch (IOException iOException) {
                        JDError.throwSQLException((Object)this, "HY000", iOException);
                    }
                } else {
                    JDError.throwSQLException(this, "07006");
                }
            } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
                Clob clob = (Clob)object;
                this.value_ = clob.getSubString(1L, (int)clob.length());
            } else {
                JDError.throwSQLException(this, "07006");
            }
            n = this.value_.length();
            if (n > this.maxLength_) {
                this.value_ = this.value_.substring(0, this.maxLength_);
                this.truncated_ = n - this.maxLength_;
            } else {
                this.truncated_ = 0;
            }
            this.length_ = this.value_.length();
        }
        finally {
            this.savedObject_ = null;
        }
    }

    public int getSQLType() {
        return 11;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCClob";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "DBCLOB";
    }

    public int getMaximumPrecision() {
        return 0x3FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 412;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "DBCLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new HexReaderInputStream(new StringReader(this.value_));
    }

    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        try {
            return BinaryConverter.stringToBytes(this.value_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new StringReader(this.value_);
    }

    public Clob getClob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new AS400JDBCClob(this.value_, this.maxLength_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new AS400JDBCClob(this.value_, this.maxLength_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return this.value_;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        try {
            return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }
}

