/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IntegerHashtable;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobEnumeration;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Tracker;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class JobList
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final int SELECTION_JOB_NAME = 1;
    public static final String SELECTION_JOB_NAME_ALL = "*ALL";
    public static final String SELECTION_JOB_NAME_CURRENT = "*CURRENT";
    public static final String SELECTION_JOB_NAME_ONLY = "*";
    public static final int SELECTION_USER_NAME = 2;
    public static final String SELECTION_USER_NAME_ALL = "*ALL";
    public static final String SELECTION_USER_NAME_CURRENT = "*CURRENT";
    public static final int SELECTION_JOB_NUMBER = 3;
    public static final String SELECTION_JOB_NUMBER_ALL = "*ALL";
    public static final int SELECTION_JOB_TYPE = 4;
    public static final String SELECTION_JOB_TYPE_ALL = "*";
    public static final int SELECTION_PRIMARY_JOB_STATUS_ACTIVE = 5;
    public static final int SELECTION_PRIMARY_JOB_STATUS_JOBQ = 6;
    public static final int SELECTION_PRIMARY_JOB_STATUS_OUTQ = 7;
    public static final int SELECTION_ACTIVE_JOB_STATUS = 8;
    public static final int SELECTION_JOB_QUEUE_STATUS_SCHEDULE = 9;
    public static final int SELECTION_JOB_QUEUE_STATUS_HELD = 10;
    public static final int SELECTION_JOB_QUEUE_STATUS_READY = 11;
    public static final int SELECTION_JOB_QUEUE = 12;
    public static final int SELECTION_INITIAL_USER = 13;
    public static final int SELECTION_SERVER_TYPE = 14;
    public static final String SELECTION_SERVER_TYPE_ALL = "*ALL";
    public static final String SELECTION_SERVER_TYPE_BLANK = "*BLANK";
    public static final int SELECTION_JOB_TYPE_ENHANCED = 17;
    public static final Integer SELECTION_JOB_TYPE_ENHANCED_ALL_BATCH = new Integer(200);
    public static final Integer SELECTION_JOB_TYPE_ENHANCED_ALL_INTERACTIVE = new Integer(900);
    public static final Integer SELECTION_JOB_TYPE_ENHANCED_ALL_PRESTART = new Integer(1600);
    private static final ProgramParameter ERROR_CODE = new ProgramParameter(new byte[8]);
    static final IntegerHashtable sortableKeys_ = new IntegerHashtable();
    private AS400 system_;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private String selectionJobName_ = "*ALL";
    private String selectionUserName_ = "*ALL";
    private String selectionJobNumber_ = "*ALL";
    private String selectionJobType_ = "*";
    private boolean selectActiveJobs_ = true;
    private boolean selectJobQueueJobs_ = true;
    private boolean selectOutQueueJobs_ = true;
    private String[] activeStatuses_ = new String[1];
    private int currentActiveStatus_ = 0;
    private boolean selectHeldJobs_ = true;
    private boolean selectScheduledJobs_ = true;
    private boolean selectReadyJobs_ = true;
    private String[] jobQueues_ = new String[1];
    private int currentJobQueue_ = 0;
    private String[] initialUsers_ = new String[1];
    private int currentInitialUser_ = 0;
    private String[] serverTypes_ = new String[1];
    private int currentServerType_ = 0;
    private int[] enhancedJobTypes_ = new int[1];
    private int currentEnhancedJobType_ = 0;
    private int length_;
    private int recordLength_;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private int numKeysReturned_;
    private int[] keyFieldsReturned_;
    private char[] keyTypesReturned_;
    private int[] keyLengthsReturned_;
    private int[] keyOffsetsReturned_;
    private int currentKey_ = 0;
    private int[] keys_ = new int[1];
    private int currentSortKey_ = 0;
    private int[] sortKeys_ = new int[1];
    private boolean[] sortOrders_ = new boolean[1];
    private Vector trackers_;

    public JobList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobList object.");
        }
    }

    public JobList(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobList object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobAttributeToRetrieve(int n) {
        Object object;
        if (n < 101) {
            Trace.log(2, "Value of parameter 'attribute' is not valid: " + n);
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        switch (n) {
            case 11000: 
            case 11001: 
            case 11002: 
            case 11003: 
            case 11004: 
            case 11005: 
            case 11006: 
            case 11007: {
                return;
            }
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 414: 
            case 416: 
            case 417: 
            case 904: 
            case 905: 
            case 1609: 
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: 
            case 10004: 
            case 10005: 
            case 10006: 
            case 10007: 
            case 10008: {
                Trace.log(2, "Value of parameter 'attribute' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("attribute", 2);
            }
            case 1920: 
            case 1921: {
                n = 403;
                break;
            }
            case 21011: 
            case 21012: 
            case 21013: 
            case 21014: {
                n = 2101;
                break;
            }
        }
        if (this.currentKey_ >= this.keys_.length) {
            object = this.keys_;
            this.keys_ = new int[((int[])object).length * 2];
            System.arraycopy(object, 0, this.keys_, 0, ((int[])object).length);
        }
        this.keys_[this.currentKey_++] = n;
        JobList jobList = this;
        object = jobList;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobAttributeToSortOn(int n, boolean bl) {
        Object object;
        if (n < 101) {
            Trace.log(2, "Value of parameter 'attribute' is not valid: " + n);
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        switch (n) {
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 414: 
            case 416: 
            case 417: 
            case 904: 
            case 905: 
            case 1609: 
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: 
            case 10004: 
            case 10005: 
            case 10006: 
            case 10007: 
            case 10008: {
                Trace.log(2, "Value of parameter 'attribute' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("attribute", 2);
            }
        }
        if (this.currentSortKey_ >= this.sortKeys_.length) {
            object = this.sortKeys_;
            this.sortKeys_ = new int[((int[])object).length * 2];
            System.arraycopy(object, 0, this.sortKeys_, 0, ((int[])object).length);
            boolean[] blArray = this.sortOrders_;
            this.sortOrders_ = new boolean[blArray.length * 2];
            System.arraycopy(blArray, 0, this.sortOrders_, 0, blArray.length);
        }
        this.sortKeys_[this.currentSortKey_] = n;
        this.sortOrders_[this.currentSortKey_++] = bl;
        JobList jobList = this;
        object = jobList;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobSelectionCriteria(int n, Object object) throws PropertyVetoException {
        Object object2;
        if (object == null) {
            Trace.log(2, "Parameter 'selectionValue' is null.");
            throw new NullPointerException("selectionValue");
        }
        switch (n) {
            case 1: {
                this.setName((String)object);
                break;
            }
            case 2: {
                this.setUser((String)object);
                break;
            }
            case 3: {
                this.setNumber((String)object);
                break;
            }
            case 4: {
                this.selectionJobType_ = ((String)object).toUpperCase();
                break;
            }
            case 5: {
                this.selectActiveJobs_ = (Boolean)object;
                break;
            }
            case 6: {
                this.selectJobQueueJobs_ = (Boolean)object;
                break;
            }
            case 7: {
                this.selectOutQueueJobs_ = (Boolean)object;
                break;
            }
            case 8: {
                object2 = ((String)object).toUpperCase();
                if (this.currentActiveStatus_ >= this.activeStatuses_.length) {
                    String[] stringArray = this.activeStatuses_;
                    this.activeStatuses_ = new String[stringArray.length * 2];
                    System.arraycopy(stringArray, 0, this.activeStatuses_, 0, stringArray.length);
                }
                this.activeStatuses_[this.currentActiveStatus_++] = object2;
                break;
            }
            case 9: {
                this.selectScheduledJobs_ = (Boolean)object;
                break;
            }
            case 10: {
                this.selectHeldJobs_ = (Boolean)object;
                break;
            }
            case 11: {
                this.selectReadyJobs_ = (Boolean)object;
                break;
            }
            case 12: {
                String string = (String)object;
                QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = qSYSObjectPathName.getObjectName();
                stringBuffer.append(string2);
                for (int i = string2.length(); i < 10; ++i) {
                    stringBuffer.append(' ');
                }
                String string3 = qSYSObjectPathName.getLibraryName();
                stringBuffer.append(string3);
                if (this.currentJobQueue_ >= this.jobQueues_.length) {
                    String[] stringArray = this.jobQueues_;
                    this.jobQueues_ = new String[stringArray.length * 2];
                    System.arraycopy(stringArray, 0, this.jobQueues_, 0, stringArray.length);
                }
                this.jobQueues_[this.currentJobQueue_++] = stringBuffer.toString();
                break;
            }
            case 13: {
                String string = ((String)object).toUpperCase();
                if (this.currentInitialUser_ >= this.initialUsers_.length) {
                    String[] stringArray = this.initialUsers_;
                    this.initialUsers_ = new String[stringArray.length * 2];
                    System.arraycopy(stringArray, 0, this.initialUsers_, 0, stringArray.length);
                }
                this.initialUsers_[this.currentInitialUser_++] = string;
                break;
            }
            case 14: {
                String string = ((String)object).toUpperCase();
                if (this.currentServerType_ >= this.serverTypes_.length) {
                    String[] stringArray = this.serverTypes_;
                    this.serverTypes_ = new String[stringArray.length * 2];
                    System.arraycopy(stringArray, 0, this.serverTypes_, 0, stringArray.length);
                }
                this.serverTypes_[this.currentServerType_++] = string;
                break;
            }
            case 17: {
                int n2 = (Integer)object;
                if (this.currentEnhancedJobType_ >= this.enhancedJobTypes_.length) {
                    int[] nArray = this.enhancedJobTypes_;
                    this.enhancedJobTypes_ = new int[nArray.length * 2];
                    System.arraycopy(nArray, 0, this.enhancedJobTypes_, 0, nArray.length);
                }
                this.enhancedJobTypes_[this.currentEnhancedJobType_++] = n2;
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'selectionType' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("selectionType", 2);
            }
        }
        object2 = this;
        synchronized (object2) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobAttributesToRetrieve() {
        this.currentKey_ = 0;
        this.keys_ = new int[1];
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobAttributesToSortOn() {
        this.currentSortKey_ = 0;
        this.sortKeys_ = new int[1];
        this.sortOrders_ = new boolean[1];
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobSelectionCriteria() throws PropertyVetoException {
        this.setName("*ALL");
        this.setUser("*ALL");
        this.setNumber("*ALL");
        this.selectionJobType_ = "*";
        this.selectActiveJobs_ = true;
        this.selectJobQueueJobs_ = true;
        this.selectOutQueueJobs_ = true;
        this.activeStatuses_ = new String[1];
        this.currentActiveStatus_ = 0;
        this.selectHeldJobs_ = true;
        this.selectScheduledJobs_ = true;
        this.selectReadyJobs_ = true;
        this.jobQueues_ = new String[1];
        this.currentJobQueue_ = 0;
        this.initialUsers_ = new String[1];
        this.currentInitialUser_ = 0;
        this.serverTypes_ = new String[1];
        this.currentServerType_ = 0;
        this.enhancedJobTypes_ = new int[1];
        this.currentEnhancedJobType_ = 0;
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobList jobList = this;
        synchronized (jobList) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobList jobList = this;
        synchronized (jobList) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] programParameterArray;
        ProgramCall programCall;
        if (Trace.traceOn_) {
            Trace.log(1, "Closing job list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        if (Trace.traceOn_ && this.trackers_ != null) {
            int n = 0;
            for (int i = 0; i < this.trackers_.size(); ++i) {
                Tracker tracker = (Tracker)this.trackers_.elementAt(i);
                if (tracker.isSet()) {
                    ++n;
                }
                tracker.set(false);
            }
            if (n > 0) {
                Trace.log(4, "The job list on the server is possibly in use by " + n + " or more enumerations as a result of a call to JobList.getJobs().");
            }
        }
        if (!(programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYCLST.PGM", programParameterArray = new ProgramParameter[]{new ProgramParameter(this.handle_), ERROR_CODE})).run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        this.handle_ = null;
        this.closeHandle_ = false;
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for job list invoked.");
        }
        if (this.system_.isConnected(2)) {
            this.close();
        }
        super.finalize();
    }

    public synchronized Enumeration getJobs() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        Tracker tracker = new Tracker();
        if (this.trackers_ == null) {
            this.trackers_ = new Vector();
        }
        this.trackers_.addElement(tracker);
        for (int i = this.trackers_.size() - 1; i >= 0; --i) {
            Tracker tracker2 = (Tracker)this.trackers_.elementAt(i);
            if (tracker2.isSet()) continue;
            this.trackers_.removeElementAt(i);
        }
        return new JobEnumeration(this, this.length_, tracker);
    }

    public Job[] getJobs(int n, int n2) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job list, list offset: " + n + ", number:", n2);
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'listOffset' is not valid:", n);
            throw new ExtendedIllegalArgumentException("listOffset (" + n + ")", 4);
        }
        if (n2 < 0 && n != -1) {
            Trace.log(2, "Value of parameter 'number' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("number (" + n2 + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (n2 == 0 && n != -1) {
            return new Job[0];
        }
        if (n == -1) {
            n2 = this.length_;
            n = 0;
        } else if (n + n2 > this.length_) {
            n2 = this.length_ - n;
        }
        int n3 = this.recordLength_ * n2;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(this.handle_), new ProgramParameter(80), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(BinaryConverter.intToByteArray(n + 1)), ERROR_CODE};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYGTLE.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        Job[] jobArray = new Job[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < jobArray.length) {
            String string = converter.byteArrayToString(byArray, n5, 10);
            String string2 = converter.byteArrayToString(byArray, n5 + 10, 10);
            String string3 = converter.byteArrayToString(byArray, n5 + 20, 6);
            String string4 = converter.byteArrayToString(byArray, n5 + 42, 10);
            String string5 = converter.byteArrayToString(byArray, n5 + 52, 1);
            String string6 = converter.byteArrayToString(byArray, n5 + 53, 1);
            jobArray[n4] = new Job(this.system_, string.trim(), string2.trim(), string3.trim(), string4, string5, string6);
            for (int i = 0; i < this.numKeysReturned_; ++i) {
                int n6 = this.keyOffsetsReturned_[i];
                if (this.keyTypesReturned_[i] == 'C') {
                    String string7 = converter.byteArrayToString(byArray, n5 + n6, this.keyLengthsReturned_[i]);
                    jobArray[n4].setValueInternal(this.keyFieldsReturned_[i], string7);
                    continue;
                }
                if (this.keyLengthsReturned_[i] > 4) {
                    jobArray[n4].setAsLong(this.keyFieldsReturned_[i], BinaryConverter.byteArrayToLong(byArray, n5 + n6));
                    continue;
                }
                jobArray[n4].setAsInt(this.keyFieldsReturned_[i], BinaryConverter.byteArrayToInt(byArray, n5 + n6));
            }
            ++n4;
            n5 += this.recordLength_;
        }
        return jobArray;
    }

    public int getLength() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job list length.");
        }
        try {
            if (this.handle_ == null || this.closeHandle_) {
                this.load();
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Exception caught getting length of job list:", (Throwable)exception);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.selectionJobName_);
        }
        return this.selectionJobName_;
    }

    public String getNumber() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting number: " + this.selectionJobNumber_);
        }
        return this.selectionJobNumber_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public String getUser() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user: " + this.selectionUserName_);
        }
        return this.selectionUserName_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading job list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        byte[] byArray = new byte[4 + this.currentSortKey_ * 12];
        BinaryConverter.intToByteArray(this.currentSortKey_, byArray, 0);
        int n6 = 4;
        for (n5 = 0; n5 < this.currentSortKey_; ++n5) {
            int n7 = sortableKeys_.get(this.sortKeys_[n5]);
            short s = 4;
            switch (this.sortKeys_[n5]) {
                case 302: 
                case 304: 
                case 409: 
                case 501: 
                case 1008: 
                case 1014: 
                case 1016: 
                case 1204: 
                case 1302: 
                case 1303: 
                case 1401: 
                case 1402: 
                case 1605: 
                case 1606: 
                case 1801: 
                case 1802: 
                case 1907: 
                case 2002: 
                case 2004: 
                case 2102: {
                    s = 0;
                    n7 = 4;
                    break;
                }
                case 1305: 
                case 2009: {
                    s = 9;
                    n7 = 4;
                    break;
                }
                case 312: 
                case 313: 
                case 1406: {
                    s = 9;
                    n7 = 8;
                    break;
                }
            }
            n4 = 0;
            switch (this.sortKeys_[n5]) {
                case 11001: {
                    n4 = 1;
                    n7 = 10;
                    break;
                }
                case 11006: {
                    n4 = 11;
                    n7 = 10;
                    break;
                }
                case 11002: {
                    n4 = 21;
                    n7 = 6;
                    break;
                }
                case 11000: 
                case 11007: {
                    n4 = 27;
                    n7 = 16;
                    break;
                }
                case 11003: {
                    n4 = 43;
                    n7 = 10;
                    break;
                }
                case 11005: {
                    n4 = 53;
                    n7 = 1;
                    break;
                }
                case 11004: {
                    n4 = 54;
                    n7 = 1;
                    break;
                }
                default: {
                    n4 = 61;
                    n3 = 0;
                    while (this.keys_[n3] != this.sortKeys_[n5]) {
                        n4 += sortableKeys_.get(this.keys_[n3]);
                        ++n3;
                    }
                    break block5;
                }
            }
            BinaryConverter.intToByteArray(n4, byArray, 4 + n5 * 12);
            BinaryConverter.intToByteArray(n7, byArray, 8 + n5 * 12);
            BinaryConverter.shortToByteArray(s, byArray, 12 + n5 * 12);
            byArray[14 + n5 * 12] = this.sortOrders_[n5] ? -15 : -14;
        }
        n5 = (this.selectActiveJobs_ ? 1 : 0) + (this.selectJobQueueJobs_ ? 1 : 0) + (this.selectOutQueueJobs_ ? 1 : 0);
        n6 = this.selectJobQueueJobs_ ? (this.selectHeldJobs_ ? 1 : 0) + (this.selectScheduledJobs_ ? 1 : 0) + (this.selectReadyJobs_ ? 1 : 0) : 0;
        byte[] byArray2 = new byte[108 + n5 * 10 + this.currentActiveStatus_ * 4 + n6 * 10 + this.currentJobQueue_ * 20 + this.currentInitialUser_ * 10 + this.currentServerType_ * 30 + this.currentEnhancedJobType_ * 4];
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        for (n4 = 0; n4 < 26; ++n4) {
            byArray2[n4] = 64;
        }
        converter.stringToByteArray(this.selectionJobName_.toUpperCase(), byArray2, 0);
        converter.stringToByteArray(this.selectionUserName_.toUpperCase(), byArray2, 10);
        converter.stringToByteArray(this.selectionJobNumber_, byArray2, 20);
        converter.stringToByteArray(this.selectionJobType_, byArray2, 26);
        n4 = 108;
        if (n5 > 0) {
            BinaryConverter.intToByteArray(n4, byArray2, 28);
            BinaryConverter.intToByteArray(n5, byArray2, 32);
            if (this.selectActiveJobs_) {
                System.arraycopy(new byte[]{92, -63, -61, -29, -55, -27, -59, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
            if (this.selectJobQueueJobs_) {
                System.arraycopy(new byte[]{92, -47, -42, -62, -40, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
            if (this.selectOutQueueJobs_) {
                System.arraycopy(new byte[]{92, -42, -28, -29, -40, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
        }
        if (this.currentActiveStatus_ > 0) {
            n3 = 0;
            for (n2 = 0; n2 < this.currentKey_ && n3 == 0; ++n2) {
                if (this.keys_[n2] != 101) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                this.addJobAttributeToRetrieve(101);
            }
            BinaryConverter.intToByteArray(n4, byArray2, 36);
            BinaryConverter.intToByteArray(this.currentActiveStatus_, byArray2, 40);
            for (n2 = 0; n2 < this.currentActiveStatus_; ++n2) {
                converter.stringToByteArray(this.activeStatuses_[n2], byArray2, n4, 4);
                n4 += 4;
            }
        }
        if (n6 > 0) {
            n3 = 0;
            for (n2 = 0; n2 < this.currentKey_ && n3 == 0; ++n2) {
                if (this.keys_[n2] != 1903) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                this.addJobAttributeToRetrieve(1903);
            }
            BinaryConverter.intToByteArray(n4, byArray2, 44);
            BinaryConverter.intToByteArray(n6, byArray2, 48);
            if (this.selectHeldJobs_) {
                System.arraycopy(new byte[]{-56, -45, -60, 64, 64, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
            if (this.selectScheduledJobs_) {
                System.arraycopy(new byte[]{-30, -61, -60, 64, 64, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
            if (this.selectReadyJobs_) {
                System.arraycopy(new byte[]{-39, -45, -30, 64, 64, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
        }
        if (this.currentJobQueue_ > 0) {
            n3 = 0;
            for (n2 = 0; n2 < this.currentKey_ && n3 == 0; ++n2) {
                if (this.keys_[n2] != 1004) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                this.addJobAttributeToRetrieve(1004);
            }
            BinaryConverter.intToByteArray(n4, byArray2, 52);
            BinaryConverter.intToByteArray(this.currentJobQueue_, byArray2, 56);
            for (n2 = 0; n2 < this.currentJobQueue_; ++n2) {
                for (n = 0; n < 20; ++n) {
                    byArray2[n + n4] = 64;
                }
                converter.stringToByteArray(this.jobQueues_[n2], byArray2, n4, 20);
                n4 += 20;
            }
        }
        if (this.currentInitialUser_ > 0) {
            n3 = 0;
            for (n2 = 0; n2 < this.currentKey_ && n3 == 0; ++n2) {
                if (this.keys_[n2] != 305) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                this.addJobAttributeToRetrieve(305);
            }
            BinaryConverter.intToByteArray(n4, byArray2, 60);
            BinaryConverter.intToByteArray(this.currentInitialUser_, byArray2, 64);
            for (n2 = 0; n2 < this.currentInitialUser_; ++n2) {
                for (n = 0; n < 10; ++n) {
                    byArray2[n + n4] = 64;
                }
                converter.stringToByteArray(this.initialUsers_[n2], byArray2, n4, 10);
                n4 += 10;
            }
        }
        if (this.currentServerType_ > 0) {
            n3 = 0;
            for (n2 = 0; n2 < this.currentKey_ && n3 == 0; ++n2) {
                if (this.keys_[n2] != 1911) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                this.addJobAttributeToRetrieve(1911);
            }
            BinaryConverter.intToByteArray(n4, byArray2, 68);
            BinaryConverter.intToByteArray(this.currentServerType_, byArray2, 72);
            for (n2 = 0; n2 < this.currentServerType_; ++n2) {
                for (n = 0; n < 30; ++n) {
                    byArray2[n + n4] = 64;
                }
                converter.stringToByteArray(this.serverTypes_[n2], byArray2, n4, 30);
                n4 += 30;
            }
        }
        if (this.currentEnhancedJobType_ > 0) {
            n3 = 0;
            for (n2 = 0; n2 < this.currentKey_ && n3 == 0; ++n2) {
                if (this.keys_[n2] != 1016) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                this.addJobAttributeToRetrieve(1016);
            }
            BinaryConverter.intToByteArray(n4, byArray2, 92);
            BinaryConverter.intToByteArray(this.currentEnhancedJobType_, byArray2, 96);
            for (n2 = 0; n2 < this.currentEnhancedJobType_; ++n2) {
                BinaryConverter.intToByteArray(this.enhancedJobTypes_[n2], byArray2, n4);
                n4 += 4;
            }
        }
        n3 = 4 + 20 * this.currentKey_;
        byte[] byArray3 = new byte[4 * this.currentKey_];
        for (n = 0; n < this.currentKey_; ++n) {
            BinaryConverter.intToByteArray(this.keys_[n], byArray3, n * 4);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(new byte[]{-42, -45, -47, -62, -16, -14, -16, -16}), new ProgramParameter(n3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(byArray), new ProgramParameter(byArray2), new ProgramParameter(BinaryConverter.intToByteArray(byArray2.length)), new ProgramParameter(BinaryConverter.intToByteArray(this.currentKey_)), new ProgramParameter(byArray3), ERROR_CODE, new ProgramParameter(new byte[]{-42, -45, -47, -30, -16, -14, -16, -16})};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLJOB.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray4 = programParameterArray[5].getOutputData();
        ListUtilities.checkListStatus(byArray4[30]);
        this.handle_ = new byte[4];
        System.arraycopy(byArray4, 8, this.handle_, 0, 4);
        this.length_ = BinaryConverter.byteArrayToInt(byArray4, 0);
        this.recordLength_ = BinaryConverter.byteArrayToInt(byArray4, 12);
        byte[] byArray5 = programParameterArray[3].getOutputData();
        this.numKeysReturned_ = BinaryConverter.byteArrayToInt(byArray5, 0);
        this.keyFieldsReturned_ = new int[this.numKeysReturned_];
        this.keyTypesReturned_ = new char[this.numKeysReturned_];
        this.keyLengthsReturned_ = new int[this.numKeysReturned_];
        this.keyOffsetsReturned_ = new int[this.numKeysReturned_];
        n4 = 4;
        for (int i = 0; i < this.numKeysReturned_; ++i) {
            this.keyFieldsReturned_[i] = BinaryConverter.byteArrayToInt(byArray5, n4 + 4);
            this.keyTypesReturned_[i] = converter.byteArrayToString(byArray5, n4 + 8, 1).charAt(0);
            this.keyLengthsReturned_[i] = BinaryConverter.byteArrayToInt(byArray5, n4 + 12);
            this.keyOffsetsReturned_[i] = BinaryConverter.byteArrayToInt(byArray5, n4 + 16);
            n4 += 20;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded job list, length: " + this.length_ + ", record length: " + this.recordLength_ + ", handle:", this.handle_);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobList jobList = this;
            synchronized (jobList) {
                this.selectionJobName_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.selectionJobName_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("name", string2, string3);
        }
        JobList jobList = this;
        synchronized (jobList) {
            this.selectionJobName_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("name", string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumber(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting number: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobList jobList = this;
            synchronized (jobList) {
                this.selectionJobNumber_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.selectionJobNumber_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("number", string2, string3);
        }
        JobList jobList = this;
        synchronized (jobList) {
            this.selectionJobNumber_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("number", string2, string3);
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobList jobList = this;
            synchronized (jobList) {
                this.selectionUserName_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.selectionUserName_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("user", string2, string3);
        }
        JobList jobList = this;
        synchronized (jobList) {
            this.selectionUserName_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("user", string2, string3);
        }
    }

    static {
        sortableKeys_.put(101, 4);
        sortableKeys_.put(102, 1);
        sortableKeys_.put(103, 4);
        sortableKeys_.put(201, 10);
        sortableKeys_.put(302, 4);
        sortableKeys_.put(303, 2);
        sortableKeys_.put(304, 4);
        sortableKeys_.put(305, 10);
        sortableKeys_.put(306, 1);
        sortableKeys_.put(307, 4);
        sortableKeys_.put(311, 10);
        sortableKeys_.put(312, 8);
        sortableKeys_.put(313, 8);
        sortableKeys_.put(401, 13);
        sortableKeys_.put(402, 13);
        sortableKeys_.put(403, 8);
        sortableKeys_.put(404, 8);
        sortableKeys_.put(405, 4);
        sortableKeys_.put(406, 1);
        sortableKeys_.put(407, 1);
        sortableKeys_.put(408, 10);
        sortableKeys_.put(409, 4);
        sortableKeys_.put(410, 13);
        sortableKeys_.put(412, 4);
        sortableKeys_.put(413, 1);
        sortableKeys_.put(418, 13);
        sortableKeys_.put(501, 4);
        sortableKeys_.put(502, 1);
        sortableKeys_.put(601, 10);
        sortableKeys_.put(602, 1);
        sortableKeys_.put(701, 1);
        sortableKeys_.put(901, 10);
        sortableKeys_.put(1001, 15);
        sortableKeys_.put(1002, 7);
        sortableKeys_.put(1003, 20);
        sortableKeys_.put(1004, 20);
        sortableKeys_.put(1005, 2);
        sortableKeys_.put(1006, 8);
        sortableKeys_.put(1007, 10);
        sortableKeys_.put(1008, 4);
        sortableKeys_.put(1012, 10);
        sortableKeys_.put(1013, 1);
        sortableKeys_.put(1014, 4);
        sortableKeys_.put(1015, 1);
        sortableKeys_.put(1016, 4);
        sortableKeys_.put(1018, 10);
        sortableKeys_.put(1201, 3);
        sortableKeys_.put(1202, 1);
        sortableKeys_.put(1203, 10);
        sortableKeys_.put(1204, 4);
        sortableKeys_.put(1205, 10);
        sortableKeys_.put(1301, 8);
        sortableKeys_.put(1302, 4);
        sortableKeys_.put(1303, 4);
        sortableKeys_.put(1304, 4);
        sortableKeys_.put(1305, 4);
        sortableKeys_.put(1306, 10);
        sortableKeys_.put(1307, 1);
        sortableKeys_.put(1401, 4);
        sortableKeys_.put(1402, 4);
        sortableKeys_.put(1406, 8);
        sortableKeys_.put(1501, 20);
        sortableKeys_.put(1502, 2);
        sortableKeys_.put(1601, 10);
        sortableKeys_.put(1602, 30);
        sortableKeys_.put(1603, 10);
        sortableKeys_.put(1604, 10);
        sortableKeys_.put(1605, 4);
        sortableKeys_.put(1606, 4);
        sortableKeys_.put(1801, 4);
        sortableKeys_.put(1802, 4);
        sortableKeys_.put(1803, 80);
        sortableKeys_.put(1901, 20);
        sortableKeys_.put(1902, 10);
        sortableKeys_.put(1903, 10);
        sortableKeys_.put(1904, 26);
        sortableKeys_.put(1906, 20);
        sortableKeys_.put(1907, 4);
        sortableKeys_.put(1908, 10);
        sortableKeys_.put(1911, 30);
        sortableKeys_.put(1982, 10);
        sortableKeys_.put(2001, 1);
        sortableKeys_.put(2002, 4);
        sortableKeys_.put(2003, 10);
        sortableKeys_.put(2004, 4);
        sortableKeys_.put(2008, 4);
        sortableKeys_.put(2009, 4);
        sortableKeys_.put(2101, 24);
        sortableKeys_.put(2102, 4);
    }
}

