/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnectionHandle;
import com.ibm.as400.access.AS400JDBCManagedConnectionPoolDataSource;
import com.ibm.as400.access.AS400JDBCManagedDataSource;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JDConnectionPoolKey;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ResourceBundleLoader;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import java.util.TreeSet;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

final class JDConnectionPoolManager
implements ConnectionEventListener {
    private static final boolean DEBUG = false;
    private static final boolean GATHER_STATS = false;
    private static final boolean TESTING_ERROR_EVENTS = false;
    private final TreeSet activeConnections_ = new TreeSet(new JDAgeComparator());
    private final HashSet activeConnectionsInError_ = new HashSet();
    private final HashMap[] availableConnections_ = new HashMap[]{new HashMap(100), new HashMap(100), null};
    private final LinkedHashSet[] availableConnectionsIdledSequence_ = new LinkedHashSet[]{new LinkedHashSet(), new LinkedHashSet(), null};
    private final ArrayList condemnedConnections_ = new ArrayList(100);
    private final HashSet invalidatedKeys_ = new HashSet();
    private AS400JDBCManagedDataSource logger_;
    private AS400JDBCManagedConnectionPoolDataSource cpds_;
    private int initialPoolSize_;
    private int minPoolSize_;
    private int maxPoolSize_;
    private long maxIdleTime_;
    private long propertyCycle_;
    private long maxLifetime_;
    private long maintainerInterval_;
    private long reaperInterval_;
    private long scavengerInterval_;
    private int condemnedListLengthThreshold_;
    private long minSwapInterval_;
    private int numConnectionsCreated_;
    private int numConnectionsDestroyed_;
    private final Object connectionsCreatedLock_ = new Object();
    private final Object connectionsDestroyedLock_ = new Object();
    private boolean poolSizeLimited_;
    private boolean connectionLifetimeLimited_;
    private boolean reuseConnections_;
    private int minDefaultStackSize_;
    private JDPoolMaintainer poolMaintainer_;
    private Thread maintainerDaemon_;
    private JDPoolReaper poolReaper_;
    private Thread reaperDaemon_;
    private JDPoolScavenger poolScavenger_;
    private Thread scavengerDaemon_;
    private boolean keepDaemonsAlive_ = true;
    private final Object maintainerSnoozeLock_ = new Object();
    private final Object maintainerSleepLock_ = new Object();
    private final Object reaperSleepLock_ = new Object();
    private final Object scavengerSleepLock_ = new Object();
    private boolean poolPaused_ = false;
    private final Object poolPauseLock_ = new Object();
    private boolean fillingPool_;
    private boolean poolClosed_;
    private boolean poolClosedCompletely_;
    private boolean needMoreConnections_;
    private long timeLastSwapAttempted_ = 0L;
    private boolean swapInProgress_;
    private final Object swapLock_ = new Object();
    private boolean healthCheckInProgress_;
    private final Object healthCheckLock_ = new Object();
    private static final int FOREGROUND = 0;
    private static final int BACKGROUND = 1;
    private static final int HOLD = 2;
    private static final int SYNC_NONE = 10;
    private static final int SYNC_ALL = 11;
    private int maintainerDaemonCycles_ = 0;
    private int reaperDaemonCycles_ = 0;
    private int scavengerDaemonCycles_ = 0;
    private int numGetConnectionCalls_received_ = 0;
    private int numGetConnectionCalls_succeeded_ = 0;
    private int numGetConnectionCalls_returnedNull_ = 0;
    private int numGetConnectionCalls_whileClosing_ = 0;
    private int connectionsReturnedToPool_ = 0;
    private int connectionErrorsOccurred_ = 0;
    private int staleConnectionsIdentified_ = 0;
    private int expiredConnectionsIdentifiedByReaper_ = 0;
    private int expiredConnectionsIdentifiedWhenReturned_ = 0;
    private int surplusPrecreatedConnectionsRemoved_ = 0;
    private int survivingConnectionsRemoved_ = 0;
    private int condemnedConnectionsRemoved_ = 0;
    private int swapsAttempted_ = 0;
    private int swapsSucceeded_ = 0;
    private int swapsFailed_ = 0;
    private int swapsFailed_notWorthIt_ = 0;
    private int swapsSucceeded_foreground_ = 0;
    private int swapsSucceeded_background_ = 0;
    private int swapsFailed_foreground_ = 0;
    private int swapsFailed_background_ = 0;
    private int swapsFailed_premature_ = 0;
    private int swapsFailed_foreground_inProgress_ = 0;
    private int swapsFailed_background_inProgress_ = 0;
    private int swapsFailed_foreground_daemonAwake_ = 0;

    JDConnectionPoolManager(AS400JDBCManagedDataSource aS400JDBCManagedDataSource, AS400JDBCManagedConnectionPoolDataSource aS400JDBCManagedConnectionPoolDataSource) {
        this.logger_ = aS400JDBCManagedDataSource;
        this.cpds_ = aS400JDBCManagedConnectionPoolDataSource;
        this.initialPoolSize_ = aS400JDBCManagedConnectionPoolDataSource.getInitialPoolSize();
        this.minPoolSize_ = aS400JDBCManagedConnectionPoolDataSource.getMinPoolSize();
        this.maxPoolSize_ = aS400JDBCManagedConnectionPoolDataSource.getMaxPoolSize();
        this.reuseConnections_ = aS400JDBCManagedConnectionPoolDataSource.isReuseConnections();
        this.maxIdleTime_ = aS400JDBCManagedConnectionPoolDataSource.getMaxIdleTime() * 1000;
        this.maxLifetime_ = aS400JDBCManagedConnectionPoolDataSource.getMaxLifetime() * 1000;
        this.maintainerInterval_ = this.propertyCycle_ = (long)(aS400JDBCManagedConnectionPoolDataSource.getPropertyCycle() * 1000);
        this.reaperInterval_ = 1800000L;
        this.scavengerInterval_ = this.maintainerInterval_ * 20L;
        if (this.maxLifetime_ == 0L) {
            this.connectionLifetimeLimited_ = false;
        } else {
            this.connectionLifetimeLimited_ = true;
            this.reaperInterval_ = this.maxLifetime_ / 3L;
        }
        this.minSwapInterval_ = 50L;
        if (this.maxPoolSize_ == 0) {
            this.poolSizeLimited_ = false;
        } else {
            this.poolSizeLimited_ = true;
            if (this.maxPoolSize_ < this.minPoolSize_) {
                if (JDTrace.isTraceOn()) {
                    this.logWarning("minPoolSize (" + this.minPoolSize_ + ") exceeds maxPoolSize (" + this.maxPoolSize_ + ")");
                }
                this.maxPoolSize_ = this.minPoolSize_ + 5;
            }
            if (this.initialPoolSize_ > this.maxPoolSize_) {
                if (JDTrace.isTraceOn()) {
                    this.logWarning("initialPoolSize (" + this.initialPoolSize_ + ") exceeds maxPoolSize (" + this.maxPoolSize_ + ")");
                }
                this.initialPoolSize_ = this.minPoolSize_;
            }
        }
        this.condemnedListLengthThreshold_ = Math.max(3, this.minPoolSize_ / 50);
        this.minDefaultStackSize_ = this.reuseConnections_ ? 4 : 1;
        this.fillPool(Math.max(1, this.initialPoolSize_ / 2), 0);
        this.fillPool(this.initialPoolSize_ / 2, 1);
        this.poolMaintainer_ = new JDPoolMaintainer();
        this.maintainerDaemon_ = new Thread((Runnable)this.poolMaintainer_, "PoolMaintainerDaemon");
        this.maintainerDaemon_.setDaemon(true);
        this.maintainerDaemon_.start();
        this.poolScavenger_ = new JDPoolScavenger();
        this.scavengerDaemon_ = new Thread((Runnable)this.poolScavenger_, "PoolScavengerDaemon");
        this.scavengerDaemon_.setDaemon(true);
        this.scavengerDaemon_.start();
        if (this.connectionLifetimeLimited_) {
            this.poolReaper_ = new JDPoolReaper();
            this.reaperDaemon_ = new Thread((Runnable)this.poolReaper_, "PoolReaperDaemon");
            this.reaperDaemon_.setDaemon(true);
            this.reaperDaemon_.start();
        }
    }

    private final boolean areDaemonsAlive() {
        boolean bl = true;
        if (!this.maintainerDaemon_.isAlive()) {
            bl = false;
            this.logError("The maintainerDaemon_ is no longer running");
        }
        if (!this.scavengerDaemon_.isAlive()) {
            bl = false;
            this.logError("The scavengerDaemon_ is no longer running");
        }
        if (this.connectionLifetimeLimited_ && !this.reaperDaemon_.isAlive()) {
            bl = false;
            this.logError("The reaperDaemon_ is no longer running");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean checkHealth(boolean bl) {
        Object object;
        boolean bl2 = true;
        boolean bl3 = this.healthCheckInProgress_;
        if (!bl3) {
            object = this.healthCheckLock_;
            synchronized (object) {
                if (this.healthCheckInProgress_) {
                    bl3 = true;
                } else {
                    this.healthCheckInProgress_ = true;
                }
            }
        }
        if (bl3) {
            return true;
        }
        try {
            this.pausePool();
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.swapInProgress_) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.swapInProgress_) {
                // empty if block
            }
            object = this.activeConnections_;
            synchronized (object) {
                HashMap hashMap = this.availableConnections_[0];
                synchronized (hashMap) {
                    HashMap hashMap2 = this.availableConnections_[1];
                    synchronized (hashMap2) {
                        ArrayList arrayList = this.condemnedConnections_;
                        synchronized (arrayList) {
                            Object object2 = this.connectionsCreatedLock_;
                            synchronized (object2) {
                                Object object3 = this.connectionsDestroyedLock_;
                                synchronized (object3) {
                                    int n;
                                    int n2 = 0;
                                    for (n = 0; n <= 1; ++n) {
                                        int n3 = 0;
                                        JDConnectionPoolKey[] jDConnectionPoolKeyArray = this.availableConnections_[n].keySet().toArray(new JDConnectionPoolKey[0]);
                                        for (int i = 0; i < jDConnectionPoolKeyArray.length; ++i) {
                                            Stack stack = (Stack)this.availableConnections_[n].get(jDConnectionPoolKeyArray[i]);
                                            if (stack == null) continue;
                                            n3 += stack.size();
                                        }
                                        n2 += n3;
                                        if (this.availableConnectionsIdledSequence_[n].size() != n3) {
                                            bl2 = false;
                                            this.logError("Connection count mismatch for side " + n + ": #avail==" + n3 + " ; #idled==" + this.availableConnectionsIdledSequence_[n].size());
                                        }
                                        if (!this.poolClosedCompletely_ || n3 == 0) continue;
                                        bl2 = false;
                                        this.logError("Available connections in list " + n + " ==" + n3 + " after pool closed");
                                    }
                                    n = n2 + this.activeConnections_.size() + this.condemnedConnections_.size();
                                    if (n != this.numConnectionsCreated_ - this.numConnectionsDestroyed_) {
                                        this.logWarning("totalConnCount==" + n + "; numConnectionsCreated_==" + this.numConnectionsCreated_ + "; numConnectionsDestroyed_==" + this.numConnectionsDestroyed_ + " (difference: " + (this.numConnectionsCreated_ - this.numConnectionsDestroyed_) + ")");
                                    }
                                    if (this.poolClosedCompletely_) {
                                        if (this.availableConnections_[0].size() != 0) {
                                            bl2 = false;
                                            this.logError("Available connection list (foreground) is not empty after pool closed");
                                        }
                                        if (this.availableConnections_[1].size() != 0) {
                                            bl2 = false;
                                            this.logError("Available connection list (background) is not empty after pool closed");
                                        }
                                        if (this.activeConnections_.size() != 0) {
                                            bl2 = false;
                                            this.logError("Active connection count is " + this.activeConnections_.size() + " after pool closed");
                                        }
                                        if (this.activeConnectionsInError_.size() != 0) {
                                            bl2 = false;
                                            this.logError("Active(error) connection count is " + this.activeConnectionsInError_.size() + " after pool closed");
                                        }
                                        if (this.condemnedConnections_.size() != 0) {
                                            bl2 = false;
                                            this.logError("Condemned connection count is " + this.condemnedConnections_.size() + " after pool closed");
                                        }
                                        if (this.numConnectionsCreated_ != this.numConnectionsDestroyed_) {
                                            bl2 = false;
                                            this.logError("numConnectionsCreated_ == " + this.numConnectionsCreated_ + ", numConnectionsDestroyed_ == " + this.numConnectionsDestroyed_ + " after pool closed");
                                        }
                                    }
                                    if (bl) {
                                        String string = "\nswapsAttempted_==" + this.swapsAttempted_ + "\n" + "swapsSucceeded_==" + this.swapsSucceeded_ + "\n" + "swapsFailed_==" + this.swapsFailed_ + "\n" + "swapsFailed_notWorthIt_==" + this.swapsFailed_notWorthIt_ + "\n" + "swapsSucceeded_foreground_==" + this.swapsSucceeded_foreground_ + "\n" + "swapsSucceeded_background_==" + this.swapsSucceeded_background_ + "\n" + "swapsFailed_foreground_==" + this.swapsFailed_foreground_ + "\n" + "swapsFailed_background_==" + this.swapsFailed_background_ + "\n" + "swapsFailed_premature_==" + this.swapsFailed_premature_ + "\n" + "swapsFailed_foreground_inProgress_==" + this.swapsFailed_foreground_inProgress_ + "\n" + "swapsFailed_background_inProgress_==" + this.swapsFailed_background_inProgress_ + "\n" + "swapsFailed_foreground_daemonAwake_==" + this.swapsFailed_foreground_daemonAwake_ + "\n" + "maintainerDaemonCycles_==" + this.maintainerDaemonCycles_ + "\n" + "reaperDaemonCycles_==" + this.reaperDaemonCycles_ + "\n" + "scavengerDaemonCycles_==" + this.scavengerDaemonCycles_ + "\n" + "numGetConnectionCalls_received_==" + this.numGetConnectionCalls_received_ + "\n" + "numGetConnectionCalls_succeeded_==" + this.numGetConnectionCalls_succeeded_ + "\n" + "numGetConnectionCalls_returnedNull_==" + this.numGetConnectionCalls_returnedNull_ + "\n" + "numGetConnectionCalls_whileClosing_==" + this.numGetConnectionCalls_whileClosing_ + "\n" + "connectionsReturnedToPool_==" + this.connectionsReturnedToPool_ + "\n" + "connectionErrorsOccurred_==" + this.connectionErrorsOccurred_ + "\n" + "staleConnectionsIdentified_: " + this.staleConnectionsIdentified_ + "\n" + "expiredConnectionsIdentifiedByReaper_: " + this.expiredConnectionsIdentifiedByReaper_ + "\n" + "expiredConnectionsIdentifiedWhenReturned_: " + this.expiredConnectionsIdentifiedWhenReturned_ + "\n" + "surplusPrecreatedConnectionsRemoved_: " + this.surplusPrecreatedConnectionsRemoved_ + "\n" + "survivingConnectionsRemoved_: " + this.survivingConnectionsRemoved_ + "\n" + "condemnedConnectionsRemoved_: " + this.condemnedConnectionsRemoved_ + "\n" + "numConnectionsCreated_: " + this.numConnectionsCreated_ + "\n" + "numConnectionsDestroyed_: " + this.numConnectionsDestroyed_;
                                        this.logInformation(string);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!this.poolPaused_) {
                if (!this.fillingPool_) {
                    bl2 = false;
                }
                this.logError("The poolPaused_ flag is off during checkHealth()");
            }
            if (this.swapInProgress_) {
                bl2 = false;
                this.logError("The swapInProgress_ flag is on during checkHealth()");
            }
            if (!this.poolClosed_) {
                if (!this.areDaemonsAlive()) {
                    bl2 = false;
                }
                if (!this.keepDaemonsAlive_) {
                    bl2 = false;
                    this.logError("The keepDaemonsAlive_ flag is off when the poolClosed_ flag is off");
                }
                if (this.poolClosedCompletely_) {
                    bl2 = false;
                    this.logError("The poolClosedCompletely_ flag is on when the poolClosed_ flag is off");
                }
            } else if (this.poolClosedCompletely_) {
                if (this.maintainerDaemon_.isAlive()) {
                    bl2 = false;
                    this.logError("The maintainerDaemon_ is still running after closePool()");
                }
                if (this.scavengerDaemon_.isAlive()) {
                    bl2 = false;
                    this.logError("The scavengerDaemon_ is still running after closePool()");
                }
                if (this.reaperDaemon_.isAlive()) {
                    bl2 = false;
                    this.logError("The reaperDaemon_ is no still running after closePool()");
                }
                if (this.keepDaemonsAlive_) {
                    bl2 = false;
                    this.logError("The keepDaemonsAlive_ flag is on after pool has been closed");
                }
                if (this.fillingPool_) {
                    bl2 = false;
                    this.logError("The fillingPool_ flag is on after pool has been closed");
                }
                if (!this.poolClosed_) {
                    bl2 = false;
                    this.logError("The poolClosed_ flag is off after pool has been closed");
                }
                if (this.needMoreConnections_) {
                    bl2 = false;
                    this.logError("The needMoreConnections_ flag is on after pool has been closed");
                }
                if (this.poolMaintainer_.isAwake_) {
                    bl2 = false;
                    this.logError("The pool maintainer daemon's isAwake_ flag is still on after closePool()");
                }
                if (this.poolMaintainer_.snooze_) {
                    bl2 = false;
                    this.logError("The pool maintainer daemon's snooze_ flag is still on after closePool()");
                }
            }
        }
        finally {
            this.healthCheckInProgress_ = false;
            this.unpausePool();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void closePhysicalConnection(AS400JDBCPooledConnection aS400JDBCPooledConnection) {
        Object object;
        try {
            try {
                aS400JDBCPooledConnection.close();
            }
            catch (Exception exception) {
                if (JDTrace.isTraceOn()) {
                    this.logException("Exception when closing physical connection", exception);
                }
                Object var4_3 = null;
                Object object3 = this.connectionsDestroyedLock_;
                synchronized (object3) {
                    ++this.numConnectionsDestroyed_;
                    return;
                }
            }
            catch (Throwable throwable) {
                if (JDTrace.isTraceOn()) {
                    this.logError(throwable.getMessage());
                }
                Object var4_4 = null;
                Object object4 = this.connectionsDestroyedLock_;
                synchronized (object4) {
                    ++this.numConnectionsDestroyed_;
                    return;
                }
            }
            Object var4_2 = null;
            object = this.connectionsDestroyedLock_;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Object object2 = this.connectionsDestroyedLock_;
            synchronized (object2) {
                ++this.numConnectionsDestroyed_;
                throw throwable;
            }
        }
        synchronized (object) {
            ++this.numConnectionsDestroyed_;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closePool() {
        Object object;
        if (this.poolClosed_) {
            return;
        }
        this.logInformation("Closing connection pool");
        this.poolClosed_ = true;
        if (JDTrace.isTraceOn()) {
            this.logInformation(ResourceBundleLoader.getText("AS400CP_SHUTDOWN"));
        }
        try {
            this.needMoreConnections_ = false;
            this.poolPaused_ = false;
            this.keepDaemonsAlive_ = false;
            this.poolMaintainer_.snooze_ = false;
            object = this.maintainerSnoozeLock_;
            synchronized (object) {
                this.poolMaintainer_.snooze_ = false;
                this.maintainerSnoozeLock_.notify();
            }
            this.wakeMaintainerDaemon();
            this.wakeScavengerDaemon();
            this.wakeReaperDaemon();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.maintainerDaemon_.join(10000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.scavengerDaemon_.join(10000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.poolReaper_ != null) {
            try {
                this.reaperDaemon_.join(10000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object = this.activeConnections_;
        synchronized (object) {
            this.activeConnections_.notifyAll();
        }
        object = this.availableConnections_[0];
        synchronized (object) {
            this.availableConnections_[0].notifyAll();
        }
        object = this.availableConnections_[1];
        synchronized (object) {
            this.availableConnections_[1].notifyAll();
        }
        object = this.condemnedConnections_;
        synchronized (object) {
            this.condemnedConnections_.notifyAll();
        }
        object = this.connectionsCreatedLock_;
        synchronized (object) {
            this.connectionsCreatedLock_.notifyAll();
        }
        object = this.connectionsDestroyedLock_;
        synchronized (object) {
            this.connectionsDestroyedLock_.notifyAll();
        }
        object = this.activeConnections_;
        synchronized (object) {
            HashMap hashMap = this.availableConnections_[0];
            synchronized (hashMap) {
                HashMap hashMap2 = this.availableConnections_[1];
                synchronized (hashMap2) {
                    ArrayList arrayList = this.condemnedConnections_;
                    synchronized (arrayList) {
                        Iterator iterator;
                        try {
                            for (int i = 0; i <= 1; ++i) {
                                JDConnectionPoolKey[] jDConnectionPoolKeyArray = this.availableConnections_[i].keySet().toArray(new JDConnectionPoolKey[0]);
                                for (int j = 0; j < jDConnectionPoolKeyArray.length; ++j) {
                                    Stack stack = (Stack)this.availableConnections_[i].get(jDConnectionPoolKeyArray[j]);
                                    if (stack == null) continue;
                                    iterator = ((AbstractList)stack).iterator();
                                    while (iterator.hasNext()) {
                                        AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)iterator.next();
                                        this.closePhysicalConnection(aS400JDBCPooledConnection);
                                    }
                                    stack.clear();
                                }
                                this.availableConnections_[i].clear();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.availableConnectionsIdledSequence_[0].clear();
                        this.availableConnectionsIdledSequence_[1].clear();
                        try {
                            iterator = this.activeConnections_.iterator();
                            while (iterator.hasNext()) {
                                AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)iterator.next();
                                this.closePhysicalConnection(aS400JDBCPooledConnection);
                            }
                            this.activeConnections_.clear();
                            this.activeConnectionsInError_.clear();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            iterator = ((AbstractList)this.condemnedConnections_).iterator();
                            while (iterator.hasNext()) {
                                AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)iterator.next();
                                this.closePhysicalConnection(aS400JDBCPooledConnection);
                            }
                            this.condemnedConnections_.clear();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        this.logInformation(ResourceBundleLoader.getText("AS400CP_SHUTDOWNCOMP"));
        this.poolClosedCompletely_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent connectionEvent) {
        boolean bl;
        if (this.poolClosed_) {
            return;
        }
        this.pauseIfPoolPaused(0L);
        AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)connectionEvent.getSource();
        if (JDTrace.isTraceOn()) {
            this.logInformation(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_RETCONN"), new String[]{this.cpds_.getServerName(), aS400JDBCPooledConnection.getPoolKey().getUser()}));
        }
        TreeSet treeSet = this.activeConnections_;
        synchronized (treeSet) {
            if (this.poolClosed_) {
                return;
            }
            bl = this.activeConnections_.remove(aS400JDBCPooledConnection);
            if (aS400JDBCPooledConnection.fatalConnectionErrorOccurred_) {
                this.activeConnectionsInError_.remove(aS400JDBCPooledConnection);
            }
        }
        if (bl) {
            long l = System.currentTimeMillis();
            if (this.reuseConnections_ && !aS400JDBCPooledConnection.fatalConnectionErrorOccurred_ && !this.isExpired(aS400JDBCPooledConnection, l - this.maxLifetime_)) {
                aS400JDBCPooledConnection.returned();
                JDConnectionPoolKey jDConnectionPoolKey = aS400JDBCPooledConnection.getPoolKey();
                HashMap hashMap = this.availableConnections_[0];
                synchronized (hashMap) {
                    Stack<AS400JDBCPooledConnection> stack = (Stack<AS400JDBCPooledConnection>)this.availableConnections_[0].get(jDConnectionPoolKey);
                    if (stack == null) {
                        stack = new Stack<AS400JDBCPooledConnection>();
                        this.availableConnections_[0].put(jDConnectionPoolKey, stack);
                    }
                    stack.push(aS400JDBCPooledConnection);
                    this.availableConnectionsIdledSequence_[0].add(aS400JDBCPooledConnection);
                    aS400JDBCPooledConnection.timeWhenPoolStatusLastModified_ = l;
                }
            } else {
                ArrayList arrayList = this.condemnedConnections_;
                synchronized (arrayList) {
                    this.condemnedConnections_.add(aS400JDBCPooledConnection);
                }
            }
        } else if (JDTrace.isTraceOn()) {
            this.logDiagnostic("connectionClosed(): The returned connection was not found on the 'active connections' list: " + aS400JDBCPooledConnection.toString());
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        this.logException("connectionErrorOccurred", connectionEvent.getSQLException());
        if (this.poolClosed_) {
            return;
        }
        this.pauseIfPoolPaused(0L);
        AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)connectionEvent.getSource();
        this.activeConnectionsInError_.add(aS400JDBCPooledConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createNewConnection(JDConnectionPoolKey jDConnectionPoolKey, boolean bl, String string) {
        if (this.poolClosed_) {
            return;
        }
        if (this.isPoolFull()) {
            return;
        }
        if (JDTrace.isTraceOn()) {
            this.logInformation(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_FILLING"), new String[]{new Integer(1).toString(), this.cpds_.getServerName(), jDConnectionPoolKey.getUser()}));
        }
        AS400JDBCPooledConnection aS400JDBCPooledConnection = null;
        boolean bl2 = false;
        try {
            try {
                aS400JDBCPooledConnection = bl ? (AS400JDBCPooledConnection)this.cpds_.getPooledConnection() : (AS400JDBCPooledConnection)this.cpds_.getPooledConnection(jDConnectionPoolKey.getUser(), string);
                Object object = this.connectionsCreatedLock_;
                synchronized (object) {
                    ++this.numConnectionsCreated_;
                }
                aS400JDBCPooledConnection.addConnectionEventListener(this);
                aS400JDBCPooledConnection.setPoolKey(jDConnectionPoolKey);
                object = this.availableConnections_[0];
                synchronized (object) {
                    Stack<AS400JDBCPooledConnection> stack = (Stack<AS400JDBCPooledConnection>)this.availableConnections_[0].get(jDConnectionPoolKey);
                    if (stack == null) {
                        stack = new Stack<AS400JDBCPooledConnection>();
                        this.availableConnections_[0].put(jDConnectionPoolKey, stack);
                    }
                    if (!this.isPoolOverFull()) {
                        stack.push(aS400JDBCPooledConnection);
                        this.availableConnectionsIdledSequence_[0].add(aS400JDBCPooledConnection);
                        bl2 = true;
                        aS400JDBCPooledConnection.timeWhenPoolStatusLastModified_ = System.currentTimeMillis();
                    }
                }
                Object var10_11 = null;
                if (!bl2 && aS400JDBCPooledConnection != null) {
                    this.closePhysicalConnection(aS400JDBCPooledConnection);
                }
            }
            catch (SQLException sQLException) {
                this.wakeMaintainerDaemon();
                this.logException(ResourceBundleLoader.getText("AS400CP_FILLEXC"), sQLException);
                Object var10_12 = null;
                if (!bl2 && aS400JDBCPooledConnection != null) {
                    this.closePhysicalConnection(aS400JDBCPooledConnection);
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!bl2 && aS400JDBCPooledConnection != null) {
                this.closePhysicalConnection(aS400JDBCPooledConnection);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fillPool(int n, int n2) {
        block27: {
            if (this.poolClosed_) {
                return;
            }
            if (this.isPoolFull()) {
                return;
            }
            if (this.poolSizeLimited_ && n + this.getConnectionCount(10) > this.maxPoolSize_) {
                n = this.maxPoolSize_ - this.getConnectionCount(10);
            }
            if (n < 1) {
                return;
            }
            JDConnectionPoolKey jDConnectionPoolKey = this.cpds_.getConnectionPoolKey();
            AS400JDBCPooledConnection[] aS400JDBCPooledConnectionArray = null;
            int n4 = 0;
            int n3 = 0;
            this.pauseIfPoolPaused(0L);
            this.fillingPool_ = true;
            try {
                try {
                    Stack<AS400JDBCPooledConnection> stack;
                    block26: {
                        Object object;
                        aS400JDBCPooledConnectionArray = new AS400JDBCPooledConnection[n];
                        try {
                            for (int i = 0; i < n; ++n4, ++i) {
                                stack = (AS400JDBCPooledConnection)this.cpds_.getPooledConnection();
                                ((AS400JDBCPooledConnection)((Object)stack)).addConnectionEventListener(this);
                                ((AS400JDBCPooledConnection)((Object)stack)).setPoolKey(jDConnectionPoolKey);
                                aS400JDBCPooledConnectionArray[i] = stack;
                            }
                            Object var10_11 = null;
                            if (n4 == 0) break block26;
                            object = this.connectionsCreatedLock_;
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            if (n4 == 0) throw throwable;
                            Object object2 = this.connectionsCreatedLock_;
                            synchronized (object2) {
                                this.numConnectionsCreated_ += n4;
                                throw throwable;
                            }
                        }
                        synchronized (object) {
                            this.numConnectionsCreated_ += n4;
                        }
                    }
                    if (JDTrace.isTraceOn()) {
                        this.logInformation(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_FILLING"), new String[]{new Integer(n).toString(), this.cpds_.getServerName(), jDConnectionPoolKey.getUser()}));
                    }
                    HashMap hashMap = this.availableConnections_[n2];
                    synchronized (hashMap) {
                        stack = (Stack)this.availableConnections_[n2].get(jDConnectionPoolKey);
                        if (stack == null) {
                            stack = new Stack<AS400JDBCPooledConnection>();
                            this.availableConnections_[n2].put(jDConnectionPoolKey, stack);
                        }
                        if (this.isPoolOverFull()) {
                            n -= Math.max(0, this.getConnectionCount(11) - this.maxPoolSize_);
                        }
                        long l = System.currentTimeMillis();
                        for (int i = 0; i < n; ++n3, ++i) {
                            stack.push(aS400JDBCPooledConnectionArray[i]);
                            this.availableConnectionsIdledSequence_[n2].add(aS400JDBCPooledConnectionArray[i]);
                            aS400JDBCPooledConnectionArray[i].timeWhenPoolStatusLastModified_ = l;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    this.wakeMaintainerDaemon();
                    this.logException(ResourceBundleLoader.getText("AS400CP_FILLEXC"), sQLException);
                    Object var15_19 = null;
                    if (n4 > n3) {
                        for (int i = n3; i < n4 && i < aS400JDBCPooledConnectionArray.length; ++i) {
                            this.closePhysicalConnection(aS400JDBCPooledConnectionArray[i]);
                        }
                    }
                    this.fillingPool_ = false;
                    return;
                }
                Object var15_18 = null;
                if (n4 <= n3) break block27;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                if (n4 > n3) {
                    for (int i = n3; i < n4 && i < aS400JDBCPooledConnectionArray.length; ++i) {
                        this.closePhysicalConnection(aS400JDBCPooledConnectionArray[i]);
                    }
                }
                this.fillingPool_ = false;
                throw throwable;
            }
            for (int i = n3; i < n4 && i < aS400JDBCPooledConnectionArray.length; ++i) {
                this.closePhysicalConnection(aS400JDBCPooledConnectionArray[i]);
            }
        }
        this.fillingPool_ = false;
    }

    protected void finalize() throws Throwable {
        this.closePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getConnectionCount(int n) {
        switch (n) {
            case 10: {
                return this.numConnectionsCreated_ - this.numConnectionsDestroyed_;
            }
            case 11: {
                Object object = this.connectionsCreatedLock_;
                synchronized (object) {
                    Object object2 = this.connectionsDestroyedLock_;
                    synchronized (object2) {
                        return this.numConnectionsCreated_ - this.numConnectionsDestroyed_;
                    }
                }
            }
        }
        this.logError("Internal error: JDConnectionPoolManager.getConnectionCount(" + n + ")");
        return this.numConnectionsCreated_ - this.numConnectionsDestroyed_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AS400JDBCConnectionHandle getConnection(JDConnectionPoolKey jDConnectionPoolKey, String string) {
        AbstractList abstractList;
        boolean bl;
        if (this.poolClosed_) {
            return null;
        }
        this.pauseIfPoolPaused(0L);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (jDConnectionPoolKey == null) {
            jDConnectionPoolKey = this.cpds_.getConnectionPoolKey();
            bl = true;
        } else {
            bl = jDConnectionPoolKey.equals(this.cpds_.getConnectionPoolKey());
        }
        AS400JDBCPooledConnection aS400JDBCPooledConnection = null;
        boolean bl5 = false;
        Object object = this.availableConnections_[0];
        synchronized (object) {
            if (this.poolClosed_) {
                return null;
            }
            for (int i = 0; aS400JDBCPooledConnection == null && i < 3; ++i) {
                abstractList = (Stack)this.availableConnections_[0].get(jDConnectionPoolKey);
                if (abstractList != null && !((Stack)abstractList).empty()) {
                    aS400JDBCPooledConnection = (AS400JDBCPooledConnection)((Stack)abstractList).pop();
                    this.availableConnectionsIdledSequence_[0].remove(aS400JDBCPooledConnection);
                    if (bl && ((Stack)abstractList).empty()) {
                        bl5 = true;
                    }
                }
                if (aS400JDBCPooledConnection != null) continue;
                if (!bl3) {
                    this.swapConnectionLists(0, jDConnectionPoolKey);
                    bl3 = true;
                    continue;
                }
                if (bl4 || this.isPoolFull()) continue;
                this.createNewConnection(jDConnectionPoolKey, bl, string);
                bl4 = true;
            }
        }
        object = null;
        if (aS400JDBCPooledConnection != null) {
            try {
                object = aS400JDBCPooledConnection.getConnectionHandle();
            }
            catch (SQLException sQLException) {
                this.logException(ResourceBundleLoader.getText("AS400CP_FILLEXC"), sQLException);
                abstractList = this.condemnedConnections_;
                synchronized (abstractList) {
                    this.condemnedConnections_.add(aS400JDBCPooledConnection);
                }
                aS400JDBCPooledConnection = null;
            }
        }
        if (aS400JDBCPooledConnection != null) {
            TreeSet treeSet = this.activeConnections_;
            synchronized (treeSet) {
                this.activeConnections_.add(aS400JDBCPooledConnection);
                aS400JDBCPooledConnection.timeWhenPoolStatusLastModified_ = System.currentTimeMillis();
            }
        }
        if (aS400JDBCPooledConnection == null && bl) {
            bl5 = true;
        }
        if (!this.needMoreConnections_ && (bl5 || this.isPoolFull() || this.getConnectionCount(10) < this.minPoolSize_)) {
            this.needMoreConnections_ = true;
            this.wakeMaintainerDaemon();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void invalidate(JDConnectionPoolKey jDConnectionPoolKey) {
        if (this.poolClosed_) {
            return;
        }
        HashSet hashSet = this.invalidatedKeys_;
        synchronized (hashSet) {
            this.invalidatedKeys_.add(jDConnectionPoolKey);
        }
    }

    private final boolean isExpired(AS400JDBCPooledConnection aS400JDBCPooledConnection, long l) {
        return aS400JDBCPooledConnection.timeWhenCreated_ < l;
    }

    private final boolean isStale(AS400JDBCPooledConnection aS400JDBCPooledConnection, long l) {
        return aS400JDBCPooledConnection.timeWhenPoolStatusLastModified_ < l;
    }

    private final boolean isPoolFull() {
        return this.poolSizeLimited_ && this.getConnectionCount(10) >= this.maxPoolSize_;
    }

    private final boolean isPoolOverFull() {
        return this.poolSizeLimited_ && this.getConnectionCount(10) > this.maxPoolSize_;
    }

    private final void logDiagnostic(String string) {
        this.logger_.logDiagnostic(string);
    }

    private final void logError(String string) {
        this.logger_.logError(string);
    }

    private final void logException(String string, Exception exception) {
        this.logger_.logException(string, exception);
    }

    private final void logInformation(String string) {
        this.logger_.logInformation(string);
    }

    private final void logWarning(String string) {
        this.logger_.logWarning(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pauseIfPoolPaused(long l) {
        while (this.poolPaused_) {
            try {
                Object object = this.poolPauseLock_;
                synchronized (object) {
                    if (this.poolPaused_) {
                        this.poolPauseLock_.wait(l);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pausePool() {
        this.poolPaused_ = true;
        Object object = this.poolPauseLock_;
        synchronized (object) {
            this.poolPaused_ = true;
        }
    }

    private final boolean isBackgroundListLongerThanForegroundList(JDConnectionPoolKey jDConnectionPoolKey) {
        Stack stack;
        Stack stack2 = (Stack)this.availableConnections_[1].get(jDConnectionPoolKey);
        return stack2 != null && stack2.size() != 0 && ((stack = (Stack)this.availableConnections_[0].get(jDConnectionPoolKey)) == null || stack.size() < stack2.size());
    }

    private final void swapAvailLists() {
        this.availableConnections_[2] = this.availableConnections_[0];
        this.availableConnections_[0] = this.availableConnections_[1];
        this.availableConnections_[1] = this.availableConnections_[2];
        this.availableConnections_[2] = null;
        this.availableConnectionsIdledSequence_[2] = this.availableConnectionsIdledSequence_[0];
        this.availableConnectionsIdledSequence_[0] = this.availableConnectionsIdledSequence_[1];
        this.availableConnectionsIdledSequence_[1] = this.availableConnectionsIdledSequence_[2];
        this.availableConnectionsIdledSequence_[2] = null;
    }

    /*
     * Exception decompiling
     */
    private final boolean swapConnectionLists(int var1_1, JDConnectionPoolKey var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 32[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unpausePool() {
        this.poolPaused_ = false;
        Object object = this.poolPauseLock_;
        synchronized (object) {
            this.poolPaused_ = false;
            this.poolPauseLock_.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wakeMaintainerDaemon() {
        Object object = this.maintainerSleepLock_;
        synchronized (object) {
            this.maintainerSleepLock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wakeReaperDaemon() {
        Object object = this.reaperSleepLock_;
        synchronized (object) {
            this.reaperSleepLock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wakeScavengerDaemon() {
        Object object = this.scavengerSleepLock_;
        synchronized (object) {
            this.scavengerSleepLock_.notify();
        }
    }

    static /* synthetic */ long access$500(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.maintainerInterval_;
    }

    static /* synthetic */ Object access$1000(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.maintainerSleepLock_;
    }

    static /* synthetic */ Object access$1200(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.maintainerSnoozeLock_;
    }

    static /* synthetic */ boolean access$1400(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.isPoolFull();
    }

    static /* synthetic */ HashMap[] access$1600(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.availableConnections_;
    }

    static /* synthetic */ HashSet access$1700(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.invalidatedKeys_;
    }

    static /* synthetic */ LinkedHashSet[] access$1900(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.availableConnectionsIdledSequence_;
    }

    static /* synthetic */ int access$2300(JDConnectionPoolManager jDConnectionPoolManager, int n) {
        return jDConnectionPoolManager.getConnectionCount(n);
    }

    static /* synthetic */ int access$2400(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.maxPoolSize_;
    }

    static /* synthetic */ AS400JDBCManagedConnectionPoolDataSource access$2500(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.cpds_;
    }

    static /* synthetic */ int access$2600(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.minDefaultStackSize_;
    }

    static /* synthetic */ void access$2700(JDConnectionPoolManager jDConnectionPoolManager, int n, int n2) {
        jDConnectionPoolManager.fillPool(n, n2);
    }

    static /* synthetic */ boolean access$2800(JDConnectionPoolManager jDConnectionPoolManager) {
        return jDConnectionPoolManager.needMoreConnections_;
    }

    static /* synthetic */ boolean access$2900(JDConnectionPoolManager jDConnectionPoolManager, int n, JDConnectionPoolKey jDConnectionPoolKey) {
        return jDConnectionPoolManager.swapConnectionLists(n, jDConnectionPoolKey);
    }

    static /* synthetic */ long access$3302(JDConnectionPoolManager jDConnectionPoolManager, long l) {
        jDConnectionPoolManager.minSwapInterval_ = l;
        return jDConnectionPoolManager.minSwapInterval_;
    }

    private final class JDPoolScavenger
    implements Runnable {
        private static final String DAEMON_NAME = "Scavenger daemon";

        private JDPoolScavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            JDConnectionPoolManager.this.logInformation("Scavenger daemon started with scavengerInterval_ = " + JDConnectionPoolManager.this.scavengerInterval_ + " msecs");
            ArrayList<AS400JDBCPooledConnection> arrayList = new ArrayList<AS400JDBCPooledConnection>(JDConnectionPoolManager.this.minPoolSize_);
            long l = 0L;
            long l2 = 0L;
            try {
                while (JDConnectionPoolManager.this.keepDaemonsAlive_) {
                    Object var13_10;
                    block25: {
                        block24: {
                            block23: {
                                try {
                                    try {
                                        Iterator iterator;
                                        long l3 = JDConnectionPoolManager.this.scavengerInterval_ - l;
                                        if (l3 > 0L) {
                                            try {
                                                iterator = JDConnectionPoolManager.this.scavengerSleepLock_;
                                                synchronized (iterator) {
                                                    JDConnectionPoolManager.this.scavengerSleepLock_.wait(l3);
                                                }
                                            }
                                            catch (InterruptedException interruptedException) {}
                                        } else if (JDTrace.isTraceOn()) {
                                            JDConnectionPoolManager.this.logWarning("Scavenger daemon did not sleep");
                                        }
                                        if (!JDConnectionPoolManager.this.keepDaemonsAlive_) {
                                            var13_10 = null;
                                            break block23;
                                        }
                                        JDConnectionPoolManager.this.pauseIfPoolPaused(0L);
                                        l2 = System.currentTimeMillis();
                                        iterator = JDConnectionPoolManager.this.condemnedConnections_;
                                        synchronized (iterator) {
                                            if (!JDConnectionPoolManager.this.keepDaemonsAlive_) {
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 21, 8, 14] lbl30 : MonitorExitStatement: MONITOREXIT : var8_6
                                                break block24;
                                            }
                                            Iterator iterator2 = ((AbstractList)JDConnectionPoolManager.this.condemnedConnections_).iterator();
                                            while (iterator2.hasNext()) {
                                                AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)iterator2.next();
                                                iterator2.remove();
                                                arrayList.add(aS400JDBCPooledConnection);
                                            }
                                        }
                                        iterator = ((AbstractList)arrayList).iterator();
                                        while (iterator.hasNext()) {
                                            JDConnectionPoolManager.this.closePhysicalConnection((AS400JDBCPooledConnection)iterator.next());
                                            iterator.remove();
                                        }
                                        break block25;
                                    }
                                    catch (Exception exception) {
                                        if (JDTrace.isTraceOn()) {
                                            JDConnectionPoolManager.this.logException("Exception caught by Scavenger daemon", exception);
                                        }
                                        var13_10 = null;
                                        l = System.currentTimeMillis() - l2;
                                        if (!JDConnectionPoolManager.this.isPoolOverFull()) continue;
                                        JDConnectionPoolManager.this.wakeReaperDaemon();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    var13_10 = null;
                                    l = System.currentTimeMillis() - l2;
                                    if (!JDConnectionPoolManager.this.isPoolOverFull()) throw throwable;
                                    JDConnectionPoolManager.this.wakeReaperDaemon();
                                    throw throwable;
                                }
                            }
                            l = System.currentTimeMillis() - l2;
                            if (!JDConnectionPoolManager.this.isPoolOverFull()) return;
                            JDConnectionPoolManager.this.wakeReaperDaemon();
                            return;
                        }
                        var13_10 = null;
                        l = System.currentTimeMillis() - l2;
                        if (!JDConnectionPoolManager.this.isPoolOverFull()) return;
                        JDConnectionPoolManager.this.wakeReaperDaemon();
                        return;
                    }
                    var13_10 = null;
                    l = System.currentTimeMillis() - l2;
                    if (!JDConnectionPoolManager.this.isPoolOverFull()) continue;
                    JDConnectionPoolManager.this.wakeReaperDaemon();
                }
                return;
            }
            finally {
                JDConnectionPoolManager.this.logInformation("Scavenger daemon has stopped");
            }
        }
    }

    private final class JDPoolReaper
    implements Runnable {
        private static final String DAEMON_NAME = "Reaper daemon";

        private JDPoolReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JDConnectionPoolManager.this.logInformation("Reaper daemon started with reaperInterval_ = " + JDConnectionPoolManager.this.reaperInterval_ + " msecs and maxLifetime_ = " + JDConnectionPoolManager.this.maxLifetime_ + " msecs");
            ArrayList<Object> arrayList = new ArrayList<Object>(JDConnectionPoolManager.this.minPoolSize_);
            long l = 0L;
            long l2 = 0L;
            try {
                while (JDConnectionPoolManager.this.keepDaemonsAlive_) {
                    try {
                        int n;
                        Object object;
                        long l3 = JDConnectionPoolManager.this.reaperInterval_ - l;
                        if (l3 > 0L) {
                            try {
                                Object object2 = JDConnectionPoolManager.this.reaperSleepLock_;
                                synchronized (object2) {
                                    JDConnectionPoolManager.this.reaperSleepLock_.wait(l3);
                                }
                            }
                            catch (InterruptedException interruptedException) {}
                        } else if (JDTrace.isTraceOn()) {
                            JDConnectionPoolManager.this.logWarning("Reaper daemon did not sleep");
                        }
                        if (!JDConnectionPoolManager.this.keepDaemonsAlive_) break;
                        JDConnectionPoolManager.this.pauseIfPoolPaused(JDConnectionPoolManager.this.reaperInterval_);
                        l2 = System.currentTimeMillis();
                        long l4 = l2 - JDConnectionPoolManager.this.maxLifetime_;
                        arrayList.clear();
                        Object object3 = JDConnectionPoolManager.this.activeConnections_;
                        synchronized (object3) {
                            block31: {
                                if (JDConnectionPoolManager.this.keepDaemonsAlive_) break block31;
                                break;
                            }
                            Iterator iterator = JDConnectionPoolManager.this.activeConnections_.iterator();
                            while (iterator.hasNext() && JDConnectionPoolManager.this.isExpired((AS400JDBCPooledConnection)(object = (AS400JDBCPooledConnection)iterator.next()), l4)) {
                                if (!JDConnectionPoolManager.this.isStale((AS400JDBCPooledConnection)object, l2 - JDConnectionPoolManager.this.maxIdleTime_)) continue;
                                iterator.remove();
                                if (((AS400JDBCPooledConnection)object).fatalConnectionErrorOccurred_) {
                                    JDConnectionPoolManager.this.activeConnectionsInError_.remove(object);
                                }
                                arrayList.add(object);
                            }
                        }
                        object3 = ((AbstractList)arrayList).iterator();
                        object = JDConnectionPoolManager.this.condemnedConnections_;
                        synchronized (object) {
                            while (object3.hasNext()) {
                                JDConnectionPoolManager.this.condemnedConnections_.add(object3.next());
                                object3.remove();
                            }
                            n = JDConnectionPoolManager.this.condemnedConnections_.size();
                        }
                        if (n <= JDConnectionPoolManager.this.condemnedListLengthThreshold_) continue;
                        JDConnectionPoolManager.this.wakeScavengerDaemon();
                    }
                    catch (Exception exception) {
                        if (!JDTrace.isTraceOn()) continue;
                        JDConnectionPoolManager.this.logException("Exception caught by Reaper daemon", exception);
                    }
                    finally {
                        l = System.currentTimeMillis() - l2;
                    }
                }
            }
            finally {
                JDConnectionPoolManager.this.logInformation("Reaper daemon has stopped");
            }
        }
    }

    private final class JDPoolMaintainer
    implements Runnable {
        private static final String DAEMON_NAME = "Maintainer daemon";
        boolean isAwake_ = true;
        boolean snooze_ = false;

        private JDPoolMaintainer() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private final class JDAgeComparator
    implements Comparator {
        private JDAgeComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                long l = ((AS400JDBCPooledConnection)object).timeWhenCreated_;
                long l2 = ((AS400JDBCPooledConnection)object2).timeWhenCreated_;
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                if (object.hashCode() < object2.hashCode()) {
                    return -1;
                }
                if (object.hashCode() > object2.hashCode()) {
                    return 1;
                }
                return 0;
            }
            catch (ClassCastException classCastException) {
                JDConnectionPoolManager.this.logException("Exception when comparing connections", classCastException);
                throw new InternalErrorException(6);
            }
        }
    }
}

