/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogUserFilterParam;

public class XLogFilter {
    private static final int LOG_TIME_BUFFER = 2;
    public static String MAX_ACTIONLIST_SCAN_DURATION = "oozie.service.XLogStreamingService.actionlist.max.log.scan.duration";
    public static String MAX_SCAN_DURATION = "oozie.service.XLogStreamingService.max.log.scan.duration";
    private Map<String, Integer> logLevels;
    private final Map<String, String> filterParams = new HashMap<String, String>();
    private static List<String> parameters = new ArrayList<String>();
    private boolean noFilter;
    private Pattern filterPattern;
    private XLogUserFilterParam userLogFilter;
    private Date endDate;
    private Date startDate;
    private boolean isActionList = false;
    private String formattedEndDate;
    private String formattedStartDate;
    private static final String DEFAULT_REGEX = "[^\\]]*";
    public static final String ALLOW_ALL_REGEX = "(.*)";
    private static final String TIMESTAMP_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)";
    private static final String WHITE_SPACE_REGEX = "\\s+";
    private static final String LOG_LEVEL_REGEX = "(\\w+)";
    private static final String PREFIX_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)\\s+(\\w+)\\s+";
    private static final Pattern SPLITTER_PATTERN = Pattern.compile("(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)\\s+(\\w+)\\s+(.*)");

    public XLogFilter() {
        this(new XLogUserFilterParam());
    }

    public XLogFilter(XLogUserFilterParam userLogFilter) {
        for (int i = 0; i < parameters.size(); ++i) {
            this.filterParams.put(parameters.get(i), DEFAULT_REGEX);
        }
        this.logLevels = null;
        this.noFilter = true;
        this.filterPattern = null;
        this.setUserLogFilter(userLogFilter);
    }

    public void setLogLevel(String logLevel) {
        if (logLevel != null && logLevel.trim().length() > 0) {
            this.logLevels = new HashMap<String, Integer>();
            String[] levels = logLevel.split("\\|");
            for (int i = 0; i < levels.length; ++i) {
                String s = levels[i].trim().toUpperCase();
                try {
                    XLog.Level.valueOf(s);
                }
                catch (Exception ex) {
                    continue;
                }
                this.logLevels.put(levels[i].toUpperCase(), 1);
            }
        }
    }

    public void setParameter(String filterParam, String value) {
        if (this.filterParams.containsKey(filterParam)) {
            this.noFilter = false;
            this.filterParams.put(filterParam, value);
        }
    }

    public static void defineParameter(String filterParam) {
        parameters.add(filterParam);
    }

    public boolean isFilterPresent() {
        return !this.noFilter || this.logLevels != null;
    }

    public boolean matches(ArrayList<String> logParts) {
        if (this.getStartDate() != null && logParts.get(0).substring(0, 19).compareTo(this.getFormattedStartDate()) < 0) {
            return false;
        }
        String logLevel = logParts.get(1);
        String logMessage = logParts.get(2);
        if (this.logLevels == null || this.logLevels.containsKey(logLevel.toUpperCase())) {
            Matcher logMatcher = this.filterPattern.matcher(logMessage);
            return logMatcher.matches();
        }
        return false;
    }

    public ArrayList<String> splitLogMessage(String logLine) {
        Matcher splitter = SPLITTER_PATTERN.matcher(logLine);
        if (splitter.matches()) {
            ArrayList<String> logParts = new ArrayList<String>();
            logParts.add(splitter.group(1));
            logParts.add(splitter.group(2));
            logParts.add(splitter.group(3));
            return logParts;
        }
        return null;
    }

    public void constructPattern() {
        if (this.noFilter && this.logLevels == null) {
            this.filterPattern = Pattern.compile(ALLOW_ALL_REGEX);
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.noFilter) {
            sb.append(ALLOW_ALL_REGEX);
        } else {
            sb.append("(.* ");
            for (int i = 0; i < parameters.size(); ++i) {
                sb.append(parameters.get(i) + "\\[");
                sb.append(this.filterParams.get(parameters.get(i)) + "\\] ");
            }
            sb.append(".*)");
        }
        if (!StringUtils.isEmpty((String)this.userLogFilter.getSearchText())) {
            sb.append(this.userLogFilter.getSearchText() + ".*");
        }
        this.filterPattern = Pattern.compile(sb.toString());
    }

    public static void reset() {
        parameters.clear();
    }

    @VisibleForTesting
    public final Map<String, String> getFilterParams() {
        return this.filterParams;
    }

    public XLogUserFilterParam getUserLogFilter() {
        return this.userLogFilter;
    }

    public void setUserLogFilter(XLogUserFilterParam userLogFilter) {
        this.userLogFilter = userLogFilter;
        this.setLogLevel(userLogFilter.getLogLevel());
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getFormattedEndDate() {
        return this.formattedEndDate;
    }

    public String getFormattedStartDate() {
        return this.formattedStartDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public boolean isDebugMode() {
        return this.userLogFilter.isDebug();
    }

    public int getLogLimit() {
        return this.userLogFilter.getLimit();
    }

    public String getDebugMessage() {
        return "Log start time = " + this.getStartDate() + ". Log end time = " + this.getEndDate() + ". User Log Filter = " + this.getUserLogFilter() + System.getProperty("line.separator");
    }

    public boolean isActionList() {
        return this.isActionList;
    }

    public void setActionList(boolean isActionList) {
        this.isActionList = isActionList;
    }

    private void calculateScanDate(Date jobStartTime, Date jobEndTime) throws IOException {
        this.startDate = this.userLogFilter.getStartDate() != null ? this.userLogFilter.getStartDate() : (this.userLogFilter.getStartOffset() != -1 ? this.adjustOffset(jobStartTime, this.userLogFilter.getStartOffset()) : jobStartTime);
        this.endDate = this.userLogFilter.getEndDate() != null ? this.userLogFilter.getEndDate() : (this.userLogFilter.getEndOffset() != -1 ? (this.userLogFilter.getStartDate() != null ? this.adjustOffset(this.startDate, this.userLogFilter.getEndOffset()) : this.adjustOffset(jobStartTime, this.userLogFilter.getEndOffset())) : jobEndTime);
        if (this.getUserLogFilter().getRecent() != -1) {
            this.startDate = this.adjustOffset(this.endDate, this.userLogFilter.getRecent() * -1);
        }
        if (this.userLogFilter.getStartDate() == null) {
            this.startDate = this.adjustOffset(this.startDate, -2);
        }
        if (this.userLogFilter.getEndDate() == null) {
            this.endDate = this.adjustOffset(this.endDate, 2);
        }
        this.formattedEndDate = XLogUserFilterParam.dt.get().format(this.getEndDate());
        this.formattedStartDate = XLogUserFilterParam.dt.get().format(this.getStartDate());
    }

    public void calculateAndValidateDateRange(Date jobStartTime, Date jobEndTime) throws IOException {
        if (jobStartTime == null || jobEndTime == null) {
            return;
        }
        this.calculateScanDate(jobStartTime, jobEndTime);
        if (this.startDate.after(this.endDate)) {
            throw new IOException("Start time should be less than end time. startTime = " + this.startDate + " endtime = " + this.endDate);
        }
        long diffHours = (this.endDate.getTime() - this.startDate.getTime()) / 3600000L;
        if (this.isActionList) {
            int actionLogDuration = ConfigurationService.getInt(MAX_ACTIONLIST_SCAN_DURATION);
            if (actionLogDuration == -1) {
                return;
            }
            if (diffHours > (long)actionLogDuration) {
                throw new IOException("Request log streaming time range with action list is higher than configured. Please reduce the scan time range. Input range (hours) = " + diffHours + " system allowed (hours) with action list = " + actionLogDuration);
            }
        } else {
            int logDuration = ConfigurationService.getInt(MAX_SCAN_DURATION);
            if (logDuration == -1) {
                return;
            }
            if (diffHours > (long)logDuration) {
                throw new IOException("Request log streaming time range is higher than configured. Please reduce the scan time range. For coord jobs you can provide action list to reduce log scan time range. Input range (hours) = " + diffHours + " system allowed (hours) = " + logDuration);
            }
        }
    }

    public Date adjustOffset(Date date, int offset) throws IOException {
        return DateUtils.addMinutes((Date)date, (int)offset);
    }
}

