/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.BundleJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionsGetFromCoordJobIdJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsCountNotForPurgeFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetForPurgeJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.eclipse.jgit.util.StringUtils;

public class PurgeXCommand
extends XCommand<Void> {
    private JPAService jpaService = null;
    private int wfOlderThan;
    private int coordOlderThan;
    private int bundleOlderThan;
    private boolean purgeOldCoordAction = false;
    private final int limit;
    private List<String> wfList;
    private List<String> coordActionList;
    private List<String> coordList;
    private List<String> bundleList;
    private int wfDel;
    private int coordDel;
    private int coordActionDel;
    private int bundleDel;
    private static final long DAY_IN_MS = 86400000L;

    public PurgeXCommand(int wfOlderThan, int coordOlderThan, int bundleOlderThan, int limit) {
        this(wfOlderThan, coordOlderThan, bundleOlderThan, limit, false);
    }

    public PurgeXCommand(int wfOlderThan, int coordOlderThan, int bundleOlderThan, int limit, boolean purgeOldCoordAction) {
        super("purge", "purge", 0);
        this.wfOlderThan = wfOlderThan;
        this.coordOlderThan = coordOlderThan;
        this.bundleOlderThan = bundleOlderThan;
        this.purgeOldCoordAction = purgeOldCoordAction;
        this.limit = limit;
        this.wfList = new ArrayList<String>();
        this.coordActionList = new ArrayList<String>();
        this.coordList = new ArrayList<String>();
        this.bundleList = new ArrayList<String>();
        this.wfDel = 0;
        this.coordDel = 0;
        this.bundleDel = 0;
    }

    @Override
    protected void loadState() throws CommandException {
        block9: {
            try {
                this.jpaService = Services.get().get(JPAService.class);
                if (this.jpaService != null) {
                    int size;
                    do {
                        size = this.wfList.size();
                        this.wfList.addAll((Collection<String>)this.jpaService.execute(new WorkflowJobsGetForPurgeJPAExecutor(this.wfOlderThan, this.wfList.size(), this.limit)));
                    } while (size != this.wfList.size());
                    if (this.purgeOldCoordAction) {
                        this.LOG.debug("Purging workflows of long running coordinators is turned on");
                        do {
                            size = this.coordActionList.size();
                            long olderThan = this.wfOlderThan;
                            List<WorkflowJobBean> jobBeans = WorkflowJobQueryExecutor.getInstance().getList(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_COMPLETED_COORD_WORKFLOWS_OLDER_THAN, olderThan, this.coordActionList.size(), this.limit);
                            for (WorkflowJobBean bean : jobBeans) {
                                this.coordActionList.add(bean.getParentId());
                                this.wfList.add(bean.getId());
                            }
                        } while (size != this.coordActionList.size());
                    }
                    do {
                        size = this.coordList.size();
                        this.coordList.addAll((Collection<String>)this.jpaService.execute(new CoordJobsGetForPurgeJPAExecutor(this.coordOlderThan, this.coordList.size(), this.limit)));
                    } while (size != this.coordList.size());
                    do {
                        size = this.bundleList.size();
                        this.bundleList.addAll((Collection<String>)this.jpaService.execute(new BundleJobsGetForPurgeJPAExecutor(this.bundleOlderThan, this.bundleList.size(), this.limit)));
                    } while (size != this.bundleList.size());
                    break block9;
                }
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            catch (XException ex) {
                throw new CommandException(ex);
            }
        }
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.info("STARTED Purge to purge Workflow Jobs older than [{0}] days, Coordinator Jobs older than [{1}] days, and Bundlejobs older than [{2}] days.", this.wfOlderThan, this.coordOlderThan, this.bundleOlderThan);
        if (!this.wfList.isEmpty()) {
            try {
                this.processWorkflows(this.wfList);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        if (!this.coordActionList.isEmpty()) {
            try {
                this.purgeCoordActions(this.coordActionList);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        if (!this.coordList.isEmpty()) {
            try {
                this.processCoordinators(this.coordList);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        if (!this.bundleList.isEmpty()) {
            try {
                this.processBundles(this.bundleList);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        this.LOG.info("ENDED Purge deleted [{0}] workflows, [{1}] coordinatorActions, [{2}] coordinators, [{3}] bundles", this.wfDel, this.coordActionDel, this.coordDel, this.bundleDel);
        return null;
    }

    private void processWorkflows(List<String> wfs) throws JPAExecutorException {
        List<String> wfsToPurge = this.processWorkflowsHelper(wfs);
        this.purgeWorkflows(wfsToPurge);
    }

    private List<String> processWorkflowsHelper(List<String> wfs) throws JPAExecutorException {
        if (wfs.isEmpty()) {
            return wfs;
        }
        ArrayList<String> subwfs = new ArrayList<String>();
        ArrayList<String> wfsToPurge = new ArrayList<String>();
        for (String wfId : wfs) {
            int size;
            ArrayList<WorkflowJobBean> swfBeanList = new ArrayList<WorkflowJobBean>();
            do {
                size = swfBeanList.size();
                swfBeanList.addAll((Collection)this.jpaService.execute(new WorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor(wfId, swfBeanList.size(), this.limit)));
            } while (size != swfBeanList.size());
            List<String> children = this.fetchTerminatedWorkflow(swfBeanList);
            if (children.size() != swfBeanList.size()) continue;
            subwfs.addAll(children);
            wfsToPurge.add(wfId);
        }
        wfsToPurge.addAll(this.processWorkflowsHelper(subwfs));
        return wfsToPurge;
    }

    private List<String> fetchTerminatedWorkflow(List<WorkflowJobBean> wfBeanList) {
        ArrayList<String> children = new ArrayList<String>();
        long wfOlderThanMS = System.currentTimeMillis() - (long)this.wfOlderThan * 86400000L;
        for (WorkflowJobBean wfjBean : wfBeanList) {
            Date wfEndTime = wfjBean.getEndTime();
            boolean isFinished = wfjBean.inTerminalState();
            if (isFinished && wfEndTime != null && wfEndTime.getTime() < wfOlderThanMS) {
                children.add(wfjBean.getId());
                continue;
            }
            Date lastModificationTime = wfjBean.getLastModifiedTime();
            if (!isFinished || lastModificationTime == null || lastModificationTime.getTime() >= wfOlderThanMS) continue;
            children.add(wfjBean.getId());
        }
        return children;
    }

    private void processCoordinators(List<String> coords) throws JPAExecutorException {
        ArrayList<String> wfsToPurge = new ArrayList<String>();
        ArrayList<String> actionsToPurge = new ArrayList<String>();
        ArrayList<String> coordsToPurge = new ArrayList<String>();
        for (String coordId : coords) {
            int size;
            ArrayList<WorkflowJobBean> wfjBeanList = new ArrayList<WorkflowJobBean>();
            do {
                size = wfjBeanList.size();
                wfjBeanList.addAll((Collection)this.jpaService.execute(new WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor(coordId, wfjBeanList.size(), this.limit)));
            } while (size != wfjBeanList.size());
            List<String> workflowChildren = this.fetchTerminatedWorkflow(wfjBeanList);
            if (workflowChildren.size() != wfjBeanList.size()) continue;
            this.LOG.debug("Purging coordinator " + coordId);
            wfsToPurge.addAll(workflowChildren);
            coordsToPurge.add(coordId);
            ArrayList actionChildren = new ArrayList();
            do {
                size = actionChildren.size();
                actionChildren.addAll(this.jpaService.execute(new CoordActionsGetFromCoordJobIdJPAExecutor(coordId, actionChildren.size(), this.limit)));
            } while (size != actionChildren.size());
            actionsToPurge.addAll(actionChildren);
        }
        this.processWorkflows(wfsToPurge);
        this.purgeCoordActions(actionsToPurge);
        this.purgeCoordinators(coordsToPurge);
    }

    private void processBundles(List<String> bundles) throws JPAExecutorException {
        ArrayList<String> coordsToPurge = new ArrayList<String>();
        ArrayList<String> bundlesToPurge = new ArrayList<String>();
        for (String bundleId : bundles) {
            int size;
            long numChildrenNotReady = this.jpaService.execute(new CoordJobsCountNotForPurgeFromParentIdJPAExecutor(this.coordOlderThan, bundleId));
            if (numChildrenNotReady != 0L) continue;
            bundlesToPurge.add(bundleId);
            this.LOG.debug("Purging bundle " + bundleId);
            ArrayList children = new ArrayList();
            do {
                size = children.size();
                children.addAll(this.jpaService.execute(new CoordJobsGetFromParentIdJPAExecutor(bundleId, children.size(), this.limit)));
            } while (size != children.size());
            coordsToPurge.addAll(children);
        }
        this.processCoordinators(coordsToPurge);
        this.purgeBundles(bundlesToPurge);
    }

    private void purgeWorkflows(List<String> wfs) throws JPAExecutorException {
        this.wfDel += wfs.size();
        Collections.reverse(wfs);
        int startIndex = 0;
        while (startIndex < wfs.size()) {
            int endIndex = startIndex + this.limit < wfs.size() ? startIndex + this.limit : wfs.size();
            List<String> wfsForDelete = wfs.subList(startIndex, endIndex);
            this.LOG.debug("Deleting workflows: " + StringUtils.join(wfsForDelete, (String)","));
            this.jpaService.execute(new WorkflowJobsDeleteJPAExecutor(wfsForDelete));
            startIndex = endIndex;
        }
    }

    private void purgeCoordActions(List<String> coordActions) throws JPAExecutorException {
        this.coordActionDel = coordActions.size();
        int startIndex = 0;
        while (startIndex < coordActions.size()) {
            int endIndex = startIndex + this.limit < coordActions.size() ? startIndex + this.limit : coordActions.size();
            List<String> coordActionsForDelete = coordActions.subList(startIndex, endIndex);
            this.LOG.debug("Deleting coordinator actions: " + StringUtils.join(coordActionsForDelete, (String)","));
            this.jpaService.execute(new CoordActionsDeleteJPAExecutor(coordActionsForDelete));
            startIndex = endIndex;
        }
    }

    private void purgeCoordinators(List<String> coords) throws JPAExecutorException {
        this.coordDel += coords.size();
        int startIndex = 0;
        while (startIndex < coords.size()) {
            int endIndex = startIndex + this.limit < coords.size() ? startIndex + this.limit : coords.size();
            List<String> coordsForDelete = coords.subList(startIndex, endIndex);
            this.LOG.debug("Deleting coordinators: " + StringUtils.join(coordsForDelete, (String)","));
            this.jpaService.execute(new CoordJobsDeleteJPAExecutor(coordsForDelete));
            startIndex = endIndex;
        }
    }

    private void purgeBundles(List<String> bundles) throws JPAExecutorException {
        this.bundleDel += bundles.size();
        int startIndex = 0;
        while (startIndex < bundles.size()) {
            int endIndex = startIndex + this.limit < bundles.size() ? startIndex + this.limit : bundles.size();
            List<String> bundlesForDelete = bundles.subList(startIndex, endIndex);
            this.LOG.debug("Deleting bundles: " + StringUtils.join(bundlesForDelete, (String)","));
            this.jpaService.execute(new BundleJobsDeleteJPAExecutor(bundlesForDelete));
            startIndex = endIndex;
        }
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

