/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.framework;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import pt.webdetails.cda.utils.PentahoHelper;
import pt.webdetails.cpf.utils.CharsetHelper;

public abstract class JsonCallHandler {
    private static Log logger = LogFactory.getLog(JsonCallHandler.class);
    public static final String ENCODING = "UTF-8";
    public static final int INDENT_FACTOR = 2;
    private HashMap<String, Method> methods = new HashMap();

    protected void registerMethod(String name, Method method) {
        method.setName(name);
        this.methods.put(name, method);
    }

    protected boolean hasPermission(Method method) {
        return PentahoHelper.isAdmin(PentahoSessionHolder.getSession());
    }

    public void handleCall(String methodName, IParameterProvider requParam, OutputStream out) {
        JSONObject result = null;
        Method method = this.methods.get(methodName);
        try {
            if (methodName == null) {
                result = JsonCallHandler.getErrorJson("No method received.");
            } else if (method == null) {
                result = JsonCallHandler.getErrorJson(MessageFormat.format("Method {0} not found.", methodName));
            } else if (!this.hasPermission(method)) {
                result = JsonCallHandler.getErrorJson(MessageFormat.format("Permission denied to call method {0}:{1}.", this.getClass().getName(), methodName));
            } else {
                try {
                    result = method.execute(requParam);
                }
                catch (JSONException e) {
                    logger.error((Object)MessageFormat.format("Error building JSON response in method {0}.", methodName), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)MessageFormat.format("Error executing method {0}.", methodName), (Throwable)e);
                    result = JsonCallHandler.createJsonResultFromException(e);
                }
            }
            IOUtils.write((String)result.toString(2), (OutputStream)out, (String)CharsetHelper.getEncoding());
        }
        catch (JSONException e) {
            logger.error((Object)"Error building JSON response", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Error writing to output stream", (Throwable)e);
        }
    }

    public static JSONObject createJsonResultFromException(Exception exc) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("status", (Object)ResponseStatus.ERROR);
        result.put("errorMsg", (Object)exc.getMessage());
        return result;
    }

    public static JSONObject getErrorJson(String msg) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("status", (Object)ResponseStatus.ERROR);
        result.put("errorMsg", (Object)msg);
        return result;
    }

    public static JSONObject getOKJson(Object obj) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("status", (Object)ResponseStatus.OK);
        result.put("result", obj);
        return result;
    }

    public static abstract class Method {
        private String name;

        public abstract JSONObject execute(IParameterProvider var1) throws Exception;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ResponseStatus {
        OK,
        ERROR;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static class JsonResultFields {
        public static final String STATUS = "status";
        public static final String ERROR_MSG = "errorMsg";
        public static final String RESULT = "result";
    }
}

