/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.services.BaseService;
import pt.webdetails.cda.services.ProcessedHtmlPage;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.Pair;

public class Previewer
extends ProcessedHtmlPage {
    private static Log logger = LogFactory.getLog(BaseService.class);
    private static final String SYS_PATH = "previewer";
    private static final String PAGE = "previewer.html";
    private static final String SYS_ABOUT_PATH = "static/about.html";
    private static final String UI_BACKEND_PREFIX = "PreviewerBackend.";
    private String cdaPath;

    public Previewer(IUrlProvider urlProvider, IContentAccessFactory access) {
        super(urlProvider, access);
    }

    @Override
    protected Iterable<Pair<String, String>> getBackendAssignments(IUrlProvider urlProvider) {
        String baseApi = urlProvider.getPluginBaseUrl();
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        pairs.add(new Pair((Object)"PreviewerBackend.PATH_doQuery", (Object)this.quote(baseApi, "doQuery")));
        pairs.add(new Pair((Object)"PreviewerBackend.PATH_unwrapQuery", (Object)this.quote(baseApi, "unwrapQuery")));
        pairs.add(new Pair((Object)"PreviewerBackend.PATH_listParameters", (Object)this.quote(baseApi, "listParameters")));
        pairs.add(new Pair((Object)"PreviewerBackend.PATH_listQueries", (Object)this.quote(baseApi, "listQueries")));
        pairs.add(new Pair((Object)"PreviewerBackend.PATH_cacheController", (Object)this.quote(baseApi, "cacheController")));
        pairs.add(new Pair((Object)"PreviewerBackend.PATH_about", (Object)this.quote(urlProvider.getPluginStaticBaseUrl(), SYS_ABOUT_PATH)));
        Locale locale = CdaEngine.getEnvironment().getLocale();
        pairs.add(new Pair((Object)"PreviewerBackend.PATH_page", (Object)this.quote(urlProvider.getPluginStaticBaseUrl(), SYS_PATH)));
        pairs.add(new Pair((Object)"PreviewerBackend.Path", (Object)this.quote(this.cdaPath)));
        pairs.add(new Pair((Object)"PreviewerBackend.LOCALE_locale", (Object)this.quote(locale.toString())));
        this.addDataTablesLocalization(pairs, "PreviewerBackend.LOCALE_dataTables", locale);
        return pairs;
    }

    private void addDataTablesLocalization(ArrayList<Pair<String, String>> pairs, String name, Locale locale) {
        IReadAccess reader = this.getSystemPath(SYS_PATH);
        String defaultDataTablesMessages = this.getDataTablesMessagesPath(null);
        String dataTablesMessages = this.getDataTablesMessagesPath(locale);
        String localization = "{}";
        try {
            if (reader.fileExists(dataTablesMessages)) {
                localization = Util.toString((InputStream)reader.getFileInputStream(dataTablesMessages));
            } else if (reader.fileExists(defaultDataTablesMessages)) {
                localization = Util.toString((InputStream)reader.getFileInputStream(defaultDataTablesMessages));
            } else {
                logger.error((Object)("previewer: localization not found: " + defaultDataTablesMessages));
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        pairs.add((Pair<String, String>)new Pair((Object)name, (Object)localization));
    }

    private String quote(String ... text) {
        return '\"' + StringUtils.join((Object[])text) + '\"';
    }

    private String getDataTablesMessagesPath(Locale locale) {
        String localeRep = locale == null ? "" : "_" + locale.toString();
        return String.format("dataTables/languages/Messages%s.json", localeRep);
    }

    public String previewQuery(String cdaPath) throws Exception {
        this.cdaPath = cdaPath;
        return this.processPage((PathOrigin)new StaticSystemOrigin(SYS_PATH), PAGE);
    }
}

