/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.push;

import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import pt.webdetails.cda.push.WebsocketJsonQueryEndpoint;

public class CdaPushQueryMessageHandler
implements MessageHandler.Whole<String> {
    private final Log logger = LogFactory.getLog(CdaPushQueryMessageHandler.class);
    private Session session;
    private IPentahoRequestContext requestContext;
    private WebsocketJsonQueryEndpoint websocketJsonQueryEndpoint;

    public CdaPushQueryMessageHandler(Session session, IPentahoRequestContext requestContext) {
        this.session = session;
        this.requestContext = requestContext;
        this.websocketJsonQueryEndpoint = new WebsocketJsonQueryEndpoint();
    }

    public void onMessage(String query) {
        try {
            PentahoRequestContextHolder.setRequestContext((IPentahoRequestContext)this.requestContext);
            AbstractAuthenticationToken principal = (AbstractAuthenticationToken)this.session.getUserPrincipal();
            if (principal.isAuthenticated()) {
                StandaloneSession pentahoSession = new StandaloneSession(principal.getName());
                PentahoSessionHolder.setSession((IPentahoSession)pentahoSession);
                SecurityHelper.getInstance().becomeUser(principal.getName());
            }
            this.websocketJsonQueryEndpoint.onMessage(query, this::processOutboundMessage);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing message. Closing websocket...", (Throwable)e);
            this.processErrorMessage(e.getMessage());
        }
    }

    public WebsocketJsonQueryEndpoint getWebsocketJsonQueryEndpoint() {
        return this.websocketJsonQueryEndpoint;
    }

    private void processOutboundMessage(String outboundMessage) {
        try {
            if (this.session.isOpen()) {
                this.session.getBasicRemote().sendText(outboundMessage);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error sending message. Closing websocket...", (Throwable)e);
            this.processErrorMessage("Error sending message");
        }
    }

    private void processErrorMessage(String errorMessage) {
        try {
            if (this.session.isOpen()) {
                this.session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, errorMessage));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error closing socket while processing error message [" + errorMessage + "]"), (Throwable)e);
        }
    }
}

