/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.push;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.web.websocket.WebsocketEndpointConfig;
import pt.webdetails.cda.push.CdaPushQueryMessageHandler;

public class CdaPushQueryEndpoint
extends Endpoint {
    private final Log logger = LogFactory.getLog(CdaPushQueryEndpoint.class);
    private CdaPushQueryMessageHandler queryHandler;

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        PentahoRequestContextHolder.setRequestContext(() -> (String)endpointConfig.getUserProperties().get(WebsocketEndpointConfig.getInstanceToReadProperties().getServletContextPathPropertyName()));
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        this.queryHandler = new CdaPushQueryMessageHandler(session, requestContext);
        this.queryHandler.getWebsocketJsonQueryEndpoint().onOpen(null);
        session.setMaxTextMessageBufferSize(Integer.parseInt(endpointConfig.getUserProperties().get(WebsocketEndpointConfig.getInstanceToReadProperties().getMaxMessagePropertyName()).toString()));
        session.setMaxBinaryMessageBufferSize(Integer.parseInt(endpointConfig.getUserProperties().get(WebsocketEndpointConfig.getInstanceToReadProperties().getMaxMessagePropertyName()).toString()));
        session.addMessageHandler((MessageHandler)this.queryHandler);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.queryHandler.getWebsocketJsonQueryEndpoint().onClose();
    }

    public void onError(Session session, Throwable throwable) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Error occurred in session id " + session.getId()), throwable);
        }
        this.queryHandler.getWebsocketJsonQueryEndpoint().onClose();
    }
}

