/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.table.TableModel;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromFileProducer;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class CdaPentahoKettleTransFromFileProducer
extends KettleTransFromFileProducer {
    private ParameterMapping[] definedVariableNames;
    private String[] definedArgumentNames;
    private transient Trans currentlyRunningTransformation;
    private Repository repository;

    public CdaPentahoKettleTransFromFileProducer(String repositoryName, String transformationFile, String stepName, String username, String password, String[] definedArgumentNames, ParameterMapping[] definedVariableNames) {
        super(repositoryName, transformationFile, stepName, username, password, definedArgumentNames, definedVariableNames);
        this.definedVariableNames = definedVariableNames;
        this.definedArgumentNames = definedArgumentNames;
    }

    private String[] fillArguments(DataRow parameters) {
        String[] params = new String[this.definedArgumentNames.length];
        for (int i = 0; i < this.definedArgumentNames.length; ++i) {
            String name = this.definedArgumentNames[i];
            Object value = parameters.get(name);
            params[i] = value == null ? null : String.valueOf(value);
        }
        return params;
    }

    private Repository connectToRepository() throws ReportDataFactoryException, KettleException {
        if (this.getRepositoryName() == null) {
            throw new NullPointerException();
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        try {
            repositoriesMeta.readData();
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(this.getRepositoryName());
        if (repositoryMeta == null) {
            return null;
        }
        Repository repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
        repository.init(repositoryMeta);
        repository.connect(this.getUsername(), this.getPassword());
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableModel performQuery(DataRow parameters, int queryLimit, ResourceManager resourceManager, ResourceKey resourceKey) throws KettleException, ReportDataFactoryException {
        if (this.getStepName() == null) {
            throw new ReportDataFactoryException("No step name defined.");
        }
        String[] params = this.fillArguments(parameters);
        Repository repository = this.connectToRepository();
        try {
            TransMeta transMeta = this.loadTransformation(repository, resourceManager, resourceKey);
            transMeta.setArguments(params);
            Trans trans = new Trans(transMeta);
            for (ParameterMapping mapping : this.definedVariableNames) {
                String sourceName = mapping.getName();
                String variableName = mapping.getAlias();
                Object value = parameters.get(sourceName);
                if (value == null) continue;
                trans.setParameterValue(variableName, String.valueOf(value));
            }
            transMeta.setInternalKettleVariables();
            trans.prepareExecution(transMeta.getArguments());
            TableProducer tableProducer = null;
            List stepList = trans.getSteps();
            for (StepMetaDataCombi aStepList : stepList) {
                if (!this.getStepName().equals(aStepList.stepname)) continue;
                RowMetaInterface row = transMeta.getStepFields(this.getStepName());
                tableProducer = new TableProducer(row, queryLimit, this.isStopOnError());
                aStepList.step.addRowListener((RowListener)tableProducer);
                break;
            }
            if (tableProducer == null) {
                throw new ReportDataFactoryException("Cannot find the specified transformation step " + this.getStepName());
            }
            this.currentlyRunningTransformation = trans;
            trans.startThreads();
            trans.waitUntilFinished();
            trans.cleanup();
            if (trans.getErrors() > 0) {
                throw new KettleException("Transformation finished with errors");
            }
            TableModel tableModel = tableProducer.getTableModel();
            return tableModel;
        }
        finally {
            this.currentlyRunningTransformation = null;
            if (repository != null) {
                repository.disconnect();
            }
        }
    }

    public void cancelQuery() {
        Trans currentlyRunningTransformation = this.currentlyRunningTransformation;
        if (currentlyRunningTransformation != null) {
            currentlyRunningTransformation.stopAll();
            this.currentlyRunningTransformation = null;
        }
    }

    public TableModel performQuery(DataRow parameters, int queryLimit, DataFactoryContext context) throws KettleException, ReportDataFactoryException {
        ArgumentNullException.validate((String)"context", (Object)context);
        ArgumentNullException.validate((String)"parameters", (Object)parameters);
        String targetStepName = this.getStepName();
        if (targetStepName == null) {
            throw new ReportDataFactoryException("No step name defined.");
        }
        Repository repo = this.repository == null ? this.connectToRepository() : this.repository;
        try {
            TransMeta transMeta = this.loadTransformation(repo, context.getResourceManager(), context.getContextKey());
            transMeta.setRepository(repo);
            TableModel tableModel = this.performQueryOnTransformation(parameters, queryLimit, context, transMeta);
            return tableModel;
        }
        catch (EvaluationException | ParseException e) {
            throw new ReportDataFactoryException("Failed to evaluate parameter", e);
        }
        finally {
            if (repo != null) {
                repo.disconnect();
            }
        }
    }

    protected String computeFullFilename(ResourceKey key) {
        while (key != null) {
            Object schema = key.getSchema();
            if (!"pentaho2".equals(schema) && !"pt.webdetails.cda.settings.CdaRepositoryResourceLoader:".equals(schema)) {
                key = key.getParent();
                continue;
            }
            Object identifier = key.getIdentifier();
            if (identifier instanceof String) {
                String file = (String)identifier;
                String fileName = PentahoSystem.getApplicationContext().getSolutionPath(file);
                if (fileName != null) {
                    return fileName;
                }
            }
            key = key.getParent();
        }
        return super.computeFullFilename(key);
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    protected static class TableProducer
    implements RowListener {
        private TypedTableModel tableModel;
        private int rowsWritten;
        private RowMetaInterface rowMeta;
        private int queryLimit;
        private boolean stopOnError;
        private boolean firstCall;
        private boolean error;

        private TableProducer(RowMetaInterface rowMeta, int queryLimit, boolean stopOnError) {
            this.rowMeta = rowMeta;
            this.queryLimit = queryLimit;
            this.stopOnError = stopOnError;
            this.firstCall = true;
        }

        public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (this.firstCall) {
                this.tableModel = this.createTableModel(rowMeta);
                this.firstCall = false;
            }
            if (this.queryLimit > 0 && this.rowsWritten > this.queryLimit) {
                return;
            }
            try {
                ++this.rowsWritten;
                int count = this.tableModel.getColumnCount();
                Object[] dataRow = new Object[count];
                block13: for (int columnNo = 0; columnNo < count; ++columnNo) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                    switch (valueMeta.getType()) {
                        case 6: {
                            dataRow[columnNo] = rowMeta.getBigNumber(row, columnNo);
                            continue block13;
                        }
                        case 4: {
                            dataRow[columnNo] = rowMeta.getBoolean(row, columnNo);
                            continue block13;
                        }
                        case 3: {
                            dataRow[columnNo] = rowMeta.getDate(row, columnNo);
                            continue block13;
                        }
                        case 5: {
                            dataRow[columnNo] = rowMeta.getInteger(row, columnNo);
                            continue block13;
                        }
                        case 0: {
                            dataRow[columnNo] = rowMeta.getString(row, columnNo);
                            continue block13;
                        }
                        case 1: {
                            dataRow[columnNo] = rowMeta.getNumber(row, columnNo);
                            continue block13;
                        }
                        case 2: {
                            dataRow[columnNo] = rowMeta.getString(row, columnNo);
                            continue block13;
                        }
                        case 8: {
                            dataRow[columnNo] = rowMeta.getBinary(row, columnNo);
                            continue block13;
                        }
                        default: {
                            dataRow[columnNo] = rowMeta.getString(row, columnNo);
                        }
                    }
                }
                this.tableModel.addRow(dataRow);
            }
            catch (KettleValueException kve) {
                throw new KettleStepException((Throwable)kve);
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }

        private TypedTableModel createTableModel(RowMetaInterface rowMeta) {
            int colCount = rowMeta.size();
            String[] fieldNames = new String[colCount];
            Class[] fieldTypes = new Class[colCount];
            block10: for (int columnNo = 0; columnNo < colCount; ++columnNo) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                fieldNames[columnNo] = valueMeta.getName();
                switch (valueMeta.getType()) {
                    case 6: {
                        fieldTypes[columnNo] = BigDecimal.class;
                        continue block10;
                    }
                    case 4: {
                        fieldTypes[columnNo] = Boolean.class;
                        continue block10;
                    }
                    case 3: {
                        fieldTypes[columnNo] = Date.class;
                        continue block10;
                    }
                    case 5: {
                        fieldTypes[columnNo] = Integer.class;
                        continue block10;
                    }
                    case 0: {
                        fieldTypes[columnNo] = String.class;
                        continue block10;
                    }
                    case 1: {
                        fieldTypes[columnNo] = Double.class;
                        continue block10;
                    }
                    case 2: {
                        fieldTypes[columnNo] = String.class;
                        continue block10;
                    }
                    case 8: {
                        fieldTypes[columnNo] = byte[].class;
                        continue block10;
                    }
                    default: {
                        fieldTypes[columnNo] = String.class;
                    }
                }
            }
            return new TypedTableModel(fieldNames, fieldTypes);
        }

        public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        }

        public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (this.stopOnError) {
                throw new KettleStepException("Aborting transformation due to error detected");
            }
            this.error = true;
        }

        public TableModel getTableModel() throws ReportDataFactoryException {
            if (this.stopOnError && this.error) {
                throw new ReportDataFactoryException("Transformation produced an error.");
            }
            if (this.tableModel == null) {
                return this.createTableModel(this.rowMeta);
            }
            return this.tableModel;
        }
    }
}

