/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.monitor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.services.CacheMonitor;
import pt.webdetails.cda.utils.PentahoHelper;
import pt.webdetails.cda.utils.framework.JsonCallHandler;

public class CacheMonitorHandler
extends JsonCallHandler {
    private static CacheMonitorHandler _instance;
    private CacheMonitor monitor = new CacheMonitor();

    public static synchronized CacheMonitorHandler getInstance() {
        if (_instance == null) {
            _instance = new CacheMonitorHandler();
        }
        return _instance;
    }

    public CacheMonitorHandler() {
        this.registerMethods();
    }

    protected boolean hasPermission(IPentahoSession session, JsonCallHandler.Method method) {
        return method.getName().equals("cacheOverview") || PentahoHelper.isAdmin(session);
    }

    private void registerMethods() {
        this.registerMethod("cached", new JsonCallHandler.Method(){

            @Override
            public JSONObject execute(IParameterProvider params) throws JSONException, ExporterException, IOException {
                String cdaSettingsId = params.getStringParameter("cdaSettingsId", null);
                String dataAccessId = params.getStringParameter("dataAccessId", null);
                return CacheMonitorHandler.this.monitor.listQueriesInCache(cdaSettingsId, dataAccessId);
            }
        });
        this.registerMethod("cacheOverview", new JsonCallHandler.Method(){

            @Override
            public JSONObject execute(IParameterProvider params) throws JSONException {
                String cdaSettingsId = params.getStringParameter("cdaSettingsId", null);
                return CacheMonitorHandler.this.monitor.getCachedQueriesOverview(cdaSettingsId);
            }
        });
        this.registerMethod("getDetails", new JsonCallHandler.Method(){

            @Override
            public JSONObject execute(IParameterProvider params) throws UnsupportedEncodingException, JSONException, ExporterException, IOException, ClassNotFoundException {
                String encodedCacheKey = params.getStringParameter("key", null);
                return CacheMonitorHandler.this.monitor.getCacheQueryTable(encodedCacheKey);
            }
        });
        this.registerMethod("removeCache", new JsonCallHandler.Method(){

            @Override
            public JSONObject execute(IParameterProvider params) throws JSONException, UnsupportedEncodingException, IOException, ClassNotFoundException {
                String serializedCacheKey = params.getStringParameter("key", null);
                return CacheMonitorHandler.this.monitor.removeQueryFromCache(serializedCacheKey);
            }
        });
        this.registerMethod("removeAll", new JsonCallHandler.Method(){

            @Override
            public JSONObject execute(IParameterProvider params) throws JSONException {
                String cdaSettingsId = params.getStringParameter("cdaSettingsId", null);
                String dataAccessId = params.getStringParameter("dataAccessId", null);
                return CacheMonitorHandler.this.monitor.removeAll(cdaSettingsId, dataAccessId);
            }
        });
        this.registerMethod("shutdown", new JsonCallHandler.Method(){

            @Override
            public JSONObject execute(IParameterProvider params) throws Exception {
                return CacheMonitorHandler.this.monitor.shutdown();
            }
        });
    }
}

