/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.endpoints;

import java.io.IOException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import pt.webdetails.cda.services.CacheMonitor;
import pt.webdetails.cda.utils.framework.JsonCallHandler;

@Path(value="/{plugin}/api/cacheMonitor")
public class CacheMonitorEndpoint {
    private static final int INDENT_FACTOR = 2;

    @GET
    @Path(value="/cacheOverview")
    @Produces(value={"application/json"})
    public String cacheOverview(@QueryParam(value="cdaSettingsId") String cdaSettingsId) throws WebApplicationException, IOException {
        this.checkAdminPermission();
        try {
            return this.getMonitor().getCachedQueriesOverview(cdaSettingsId).toString(2);
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="/cached")
    @Produces(value={"application/json"})
    public String getCached(@QueryParam(value="cdaSettingsId") String cdaSettingsId, @QueryParam(value="dataAccessId") String dataAccessId) throws WebApplicationException, IOException {
        this.checkAdminPermission();
        try {
            return this.getMonitor().listQueriesInCache(cdaSettingsId, dataAccessId).toString(2);
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="/getDetails")
    @Produces(value={"application/json"})
    public String getCached(@FormParam(value="key") String encodedCacheKey) throws WebApplicationException, IOException {
        this.checkAdminPermission();
        try {
            return this.getMonitor().getCacheQueryTable(encodedCacheKey).toString(2);
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="/removeCache")
    @Produces(value={"application/json"})
    public String removeCache(@FormParam(value="key") String encodedCacheKey) throws WebApplicationException, IOException {
        this.checkAdminPermission();
        try {
            return this.getMonitor().removeQueryFromCache(encodedCacheKey).toString(2);
        }
        catch (Exception e) {
            return this.getJsonError(e);
        }
    }

    @POST
    @Path(value="/removeAll")
    @Produces(value={"application/json"})
    public String removeAll(@FormParam(value="cdaSettingsId") String cdaSettingsId, @FormParam(value="dataAccessId") String dataAccessId) throws WebApplicationException, IOException {
        this.checkAdminPermission();
        try {
            return this.getMonitor().removeAll(cdaSettingsId, dataAccessId).toString(2);
        }
        catch (Exception e) {
            return this.getJsonError(e);
        }
    }

    @POST
    @Path(value="/shutdown")
    @Produces(value={"application/json"})
    public String shutdown() throws WebApplicationException, IOException {
        this.checkAdminPermission();
        try {
            return this.getMonitor().shutdown().toString(2);
        }
        catch (Exception e) {
            return this.getJsonError(e);
        }
    }

    private String getJsonError(Exception e) throws WebApplicationException {
        try {
            return JsonCallHandler.getErrorJson(e.getLocalizedMessage()).toString(2);
        }
        catch (JSONException e1) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private void checkAdminPermission() throws WebApplicationException {
        if (!SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private CacheMonitor getMonitor() {
        return new CacheMonitor();
    }

    public String removeAllInterPlugin(@QueryParam(value="cdaSettingsId") String cdaSettingsId, @QueryParam(value="dataAccessId") String dataAccessId) throws WebApplicationException, IOException {
        return this.removeAll(cdaSettingsId, dataAccessId);
    }
}

