/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultDetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultGroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.DetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.FieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.GroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.AbstractWizardStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.util.FieldWrapper;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.util.SourceFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.util.XulGroupDefinition;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class LayoutStep
extends AbstractWizardStep {
    private static final String LAYOUT_STEP_OVERLAY = "org/pentaho/reporting/engine/classic/wizard/ui/xul/res/layout_step_Overlay.xul";
    private static final String ELEMENTS_PROPERTY_NAME = "elements";
    private static final String NOT_DISABLED_PROPERTY_NAME = "!disabled";
    private static final String SELECTABLE_FIELDS_PROPERTY_NAME = "selectableFields";
    private static final String GROUP_FIELDS_PROPERTY_NAME = "groupFields";
    private static final String DETAIL_FIELDS_PROPERTY_NAME = "detailFields";
    private static final String SELECTED_INDICES_PROPERTY_NAME = "selectedIndices";
    protected static final String AVAILABLE_COLUMNS_LIST_ID = "available_columns_list";
    protected static final String GROUP_FIELDS_LIST_ID = "group_fields_list";
    protected static final String DETAIL_FIELDS_LIST_ID = "detail_fields_list";
    private static final String MOVE_TO_GROUPS_BTN_ID = "move_to_groups_btn";
    private static final String MOVE_TO_DETAILS_BTN_ID = "move_to_details_btn";
    private static final String MOVE_GROUP_UP_BTN_ID = "move_group_up_btn";
    private static final String MOVE_GROUP_DOWN_BTN_ID = "move_group_down_btn";
    private static final String REMOVE_GROUP_ITEM_BTN_ID = "remove_group_item_btn";
    private static final String MOVE_DETAIL_UP_BTN_ID = "move_detail_up_btn";
    private static final String MOVE_DETAIL_DOWN_BTN_ID = "move_detail_down_btn";
    private static final String REMOVE_DETAIL_ITEM_BTN_ID = "remove_detail_item_btn";
    private static final String PREVIEW_BUTTON_ID = "layout_preview_btn";
    private Binding previewBinding;
    private Binding selectableFieldsBinding;
    private Binding groupsBinding;
    private Binding detailsBinding;
    private ArrayList<SourceFieldDefinition> selectableFields = new ArrayList();
    protected static final int[] EMPTY_SELECTION = new int[0];

    @Override
    public void setBindings() {
        ListSelectionToBooleanConverter listToBooleanConverter = new ListSelectionToBooleanConverter();
        MoveUpBindingConverter moveUpBindingConverter = new MoveUpBindingConverter();
        this.getBindingFactory().setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.selectableFieldsBinding = this.getBindingFactory().createBinding((Object)this, SELECTABLE_FIELDS_PROPERTY_NAME, AVAILABLE_COLUMNS_LIST_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
        this.groupsBinding = this.getBindingFactory().createBinding((Object)this, GROUP_FIELDS_PROPERTY_NAME, GROUP_FIELDS_LIST_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
        this.detailsBinding = this.getBindingFactory().createBinding((Object)this, DETAIL_FIELDS_PROPERTY_NAME, DETAIL_FIELDS_LIST_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
        this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
        this.getBindingFactory().createBinding(AVAILABLE_COLUMNS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, MOVE_TO_GROUPS_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{listToBooleanConverter});
        this.getBindingFactory().createBinding(AVAILABLE_COLUMNS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, MOVE_TO_DETAILS_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{listToBooleanConverter});
        this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
        this.getBindingFactory().createBinding(GROUP_FIELDS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, MOVE_GROUP_UP_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{moveUpBindingConverter});
        this.getBindingFactory().createBinding(GROUP_FIELDS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, MOVE_GROUP_DOWN_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{new MoveDownBindingConverter((XulListbox)this.getDocument().getElementById(GROUP_FIELDS_LIST_ID))});
        this.getBindingFactory().createBinding(GROUP_FIELDS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, REMOVE_GROUP_ITEM_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{listToBooleanConverter});
        this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
        this.getBindingFactory().createBinding(DETAIL_FIELDS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, MOVE_DETAIL_UP_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{moveUpBindingConverter});
        this.getBindingFactory().createBinding(DETAIL_FIELDS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, MOVE_DETAIL_DOWN_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{new MoveDownBindingConverter((XulListbox)this.getDocument().getElementById(DETAIL_FIELDS_LIST_ID))});
        this.getBindingFactory().createBinding(DETAIL_FIELDS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, REMOVE_DETAIL_ITEM_BTN_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[]{listToBooleanConverter});
        this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
        this.previewBinding = this.getBindingFactory().createBinding((Object)this, "previewable", PREVIEW_BUTTON_ID, NOT_DISABLED_PROPERTY_NAME, new BindingConvertor[0]);
    }

    @Override
    public void stepActivating() {
        super.stepActivating();
        try {
            this.previewBinding.fireSourceChanged();
            this.selectableFieldsBinding.fireSourceChanged();
            this.groupsBinding.fireSourceChanged();
            this.detailsBinding.fireSourceChanged();
        }
        catch (Exception e) {
            if (this.getDesignTimeContext() != null) {
                this.getDesignTimeContext().error(e);
            }
            DebugLog.log((Object)e);
        }
        if (this.getEditorModel().isRelationalModel()) {
            this.populateSourceList();
            this.setDetailFields(this.getDetailFields());
            this.setGroupFields(this.getGroupFields());
        } else {
            this.setValid(false);
        }
    }

    private void populateSourceList() {
        DataSchemaModel dataSchemaModel = this.getEditorModel().getDataSchema();
        DataSchema dataSchema = dataSchemaModel.getDataSchema();
        Object[] names = dataSchema.getNames();
        Arrays.sort(names);
        ArrayList<SourceFieldDefinition> fields = new ArrayList<SourceFieldDefinition>();
        for (int i = 0; i < names.length; ++i) {
            Object fieldName = names[i];
            if (fieldName == null || this.isFilteredField(dataSchema, (String)fieldName)) continue;
            SourceFieldDefinition fieldDefinition = new SourceFieldDefinition((String)fieldName, dataSchema);
            fields.add(fieldDefinition);
        }
        this.setSelectableFields(fields);
    }

    private boolean isFilteredField(DataSchema dataSchema, String fieldName) {
        DefaultDataAttributeContext dac = new DefaultDataAttributeContext();
        DataAttributes attributes = dataSchema.getAttributes(fieldName);
        Object source = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, (DataAttributeContext)dac);
        if ("environment".equals(source)) {
            return true;
        }
        if ("parameter".equals(source)) {
            return true;
        }
        Object indexColumn = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "indexed-column", Boolean.class, (DataAttributeContext)dac);
        return Boolean.TRUE.equals(indexColumn);
    }

    public List<FieldWrapper> getDetailFields() {
        ArrayList<FieldWrapper> fields = new ArrayList<FieldWrapper>();
        DataSchema schema = this.getEditorModel().getDataSchema().getDataSchema();
        for (DetailFieldDefinition field : this.getEditorModel().getReportSpec().getDetailFieldDefinitions()) {
            fields.add(new FieldWrapper((FieldDefinition)field, schema));
        }
        return fields;
    }

    public void setDetailFields(List<FieldWrapper> detailFields) {
        List<FieldWrapper> oldFields = this.getDetailFields();
        DetailFieldDefinition[] fields = new DetailFieldDefinition[detailFields.size()];
        for (int i = 0; i < detailFields.size(); ++i) {
            FieldWrapper fieldWrapper = detailFields.get(i);
            fields[i] = (DetailFieldDefinition)fieldWrapper.getFieldDefinition();
        }
        this.getEditorModel().getReportSpec().setDetailFieldDefinitions(fields);
        this.setPreviewable(!detailFields.isEmpty());
        this.setFinishable(!detailFields.isEmpty());
        this.setValid(!detailFields.isEmpty());
        this.firePropertyChange(DETAIL_FIELDS_PROPERTY_NAME, oldFields, detailFields);
    }

    public List<FieldWrapper> getGroupFields() {
        ArrayList<FieldWrapper> groups = new ArrayList<FieldWrapper>();
        DataSchema schema = this.getEditorModel().getDataSchema().getDataSchema();
        for (GroupDefinition group : this.getEditorModel().getReportSpec().getGroupDefinitions()) {
            groups.add(new FieldWrapper((FieldDefinition)group, schema));
        }
        return groups;
    }

    public void setGroupFields(List<FieldWrapper> groupFields) {
        List<FieldWrapper> oldGroups = this.getGroupFields();
        GroupDefinition[] fields = new GroupDefinition[groupFields.size()];
        for (int i = 0; i < groupFields.size(); ++i) {
            FieldWrapper fieldWrapper = groupFields.get(i);
            fields[i] = (GroupDefinition)fieldWrapper.getFieldDefinition();
        }
        this.getEditorModel().getReportSpec().setGroupDefinitions(fields);
        this.firePropertyChange(GROUP_FIELDS_PROPERTY_NAME, oldGroups, groupFields);
    }

    @Override
    public void createPresentationComponent(XulDomContainer mainWizardContainer) throws XulException {
        super.createPresentationComponent(mainWizardContainer);
        mainWizardContainer.loadOverlay(LAYOUT_STEP_OVERLAY);
        mainWizardContainer.addEventHandler((XulEventHandler)new SelectFieldsAndGroupsEventHandler());
    }

    public ArrayList<SourceFieldDefinition> getSelectableFields() {
        return this.selectableFields;
    }

    public void setSelectableFields(ArrayList<SourceFieldDefinition> selectableFields) {
        if (selectableFields == null) {
            throw new NullPointerException();
        }
        ArrayList<SourceFieldDefinition> oldSelectableFields = this.selectableFields;
        this.selectableFields = selectableFields;
        this.firePropertyChange(SELECTABLE_FIELDS_PROPERTY_NAME, oldSelectableFields, this.selectableFields);
    }

    @Override
    public String getStepName() {
        return messages.getString("LAYOUT_STEP.Step_Name");
    }

    private static enum DIRECTION {
        UP,
        DOWN;

    }

    private static class MoveDownBindingConverter
    extends BindingConvertor<int[], Boolean> {
        private XulListbox list;

        private MoveDownBindingConverter(XulListbox list) {
            this.list = list;
        }

        public Boolean sourceToTarget(int[] value) {
            Arrays.sort(value);
            return value.length > 0 && value[value.length - 1] < this.list.getElements().size() - 1;
        }

        public int[] targetToSource(Boolean value) {
            return null;
        }
    }

    private static class MoveUpBindingConverter
    extends BindingConvertor<int[], Boolean> {
        private MoveUpBindingConverter() {
        }

        public Boolean sourceToTarget(int[] value) {
            Arrays.sort(value);
            return value.length > 0 && value[0] > 0;
        }

        public int[] targetToSource(Boolean value) {
            return null;
        }
    }

    private static class ListSelectionToBooleanConverter
    extends BindingConvertor<int[], Boolean> {
        private ListSelectionToBooleanConverter() {
        }

        public Boolean sourceToTarget(int[] value) {
            return value.length > 0;
        }

        public int[] targetToSource(Boolean value) {
            return null;
        }
    }

    protected class SelectFieldsAndGroupsEventHandler
    extends AbstractXulEventHandler {
        protected SelectFieldsAndGroupsEventHandler() {
        }

        public String getName() {
            return "layout_controller";
        }

        private int[] getNewSelections(int[] oldSelectedRows, DIRECTION direction) {
            int offset = direction == DIRECTION.DOWN ? 1 : -1;
            int[] newSelectedRows = new int[oldSelectedRows.length];
            for (int i = 0; i < oldSelectedRows.length; ++i) {
                newSelectedRows[i] = oldSelectedRows[i] + offset;
            }
            return newSelectedRows;
        }

        public void doMoveToGroups() {
            XulListbox availableList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.AVAILABLE_COLUMNS_LIST_ID);
            int[] selectedIndices = availableList.getSelectedIndices();
            List<FieldWrapper> groups = LayoutStep.this.getGroupFields();
            DataSchema schema = LayoutStep.this.getEditorModel().getDataSchema().getDataSchema();
            for (int i : selectedIndices) {
                SourceFieldDefinition group = LayoutStep.this.getSelectableFields().get(i);
                DefaultGroupDefinition xulGroup = new DefaultGroupDefinition();
                xulGroup.setField(group.getFieldName());
                FieldWrapper wrapper = new FieldWrapper((FieldDefinition)xulGroup, schema);
                groups.add(wrapper);
                DefaultGroupDefinition definition = (DefaultGroupDefinition)wrapper.getFieldDefinition();
                new XulGroupDefinition(definition, schema);
            }
            LayoutStep.this.setGroupFields(groups);
        }

        public void doMoveToDetails() {
            XulListbox availableList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.AVAILABLE_COLUMNS_LIST_ID);
            int[] selectedIndices = availableList.getSelectedIndices();
            List<FieldWrapper> details = LayoutStep.this.getDetailFields();
            DataSchema schema = LayoutStep.this.getEditorModel().getDataSchema().getDataSchema();
            for (int i : selectedIndices) {
                SourceFieldDefinition field = LayoutStep.this.getSelectableFields().get(i);
                DefaultDetailFieldDefinition xulField = new DefaultDetailFieldDefinition();
                xulField.setField(field.getFieldName());
                details.add(new FieldWrapper((FieldDefinition)xulField, schema));
            }
            LayoutStep.this.setDetailFields(details);
        }

        public void doMoveUpSelectedGroupItems() {
            List<FieldWrapper> groups = LayoutStep.this.getGroupFields();
            XulListbox groupList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.GROUP_FIELDS_LIST_ID);
            int[] selectedIndices = groupList.getSelectedIndices();
            Arrays.sort(selectedIndices);
            for (int selectedRow : selectedIndices) {
                FieldWrapper group = groups.remove(selectedRow);
                groups.add(selectedRow - 1, group);
            }
            LayoutStep.this.setGroupFields(groups);
            groupList.setSelectedIndices(this.getNewSelections(selectedIndices, DIRECTION.UP));
        }

        public void doMoveDownSelectedGroupItems() {
            List<FieldWrapper> groups = LayoutStep.this.getGroupFields();
            XulListbox groupList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.GROUP_FIELDS_LIST_ID);
            int[] selectedIndices = groupList.getSelectedIndices();
            Arrays.sort(selectedIndices);
            this.reverseArray(selectedIndices);
            for (int selectedRow : selectedIndices) {
                FieldWrapper group = groups.remove(selectedRow);
                groups.add(selectedRow + 1, group);
            }
            LayoutStep.this.setGroupFields(groups);
            groupList.setSelectedIndices(this.getNewSelections(selectedIndices, DIRECTION.DOWN));
        }

        public void doRemoveSelectedGroupItems() {
            List<FieldWrapper> groups = LayoutStep.this.getGroupFields();
            XulListbox groupList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.GROUP_FIELDS_LIST_ID);
            for (int i = groupList.getSelectedIndices().length - 1; i >= 0; --i) {
                groups.remove(groupList.getSelectedIndices()[i]);
            }
            LayoutStep.this.setGroupFields(groups);
            groupList.setSelectedIndices(EMPTY_SELECTION);
        }

        public void doMoveUpSelectedDetailItems() {
            List<FieldWrapper> details = LayoutStep.this.getDetailFields();
            XulListbox detailList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.DETAIL_FIELDS_LIST_ID);
            int[] selectedIndices = detailList.getSelectedIndices();
            Arrays.sort(selectedIndices);
            for (int selectedRow : selectedIndices) {
                FieldWrapper detail = details.remove(selectedRow);
                details.add(selectedRow - 1, detail);
            }
            LayoutStep.this.setDetailFields(details);
            detailList.setSelectedIndices(this.getNewSelections(selectedIndices, DIRECTION.UP));
        }

        public void doMoveDownSelectedDetailItems() {
            List<FieldWrapper> details = LayoutStep.this.getDetailFields();
            XulListbox detailList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.DETAIL_FIELDS_LIST_ID);
            int[] selectedIndices = detailList.getSelectedIndices();
            Arrays.sort(selectedIndices);
            this.reverseArray(selectedIndices);
            for (int selectedRow : selectedIndices) {
                FieldWrapper detail = details.remove(selectedRow);
                details.add(selectedRow + 1, detail);
            }
            LayoutStep.this.setDetailFields(details);
            detailList.setSelectedIndices(this.getNewSelections(selectedIndices, DIRECTION.DOWN));
        }

        public void doRemoveSelectedDetailItems() {
            List<FieldWrapper> details = LayoutStep.this.getDetailFields();
            XulListbox detailList = (XulListbox)LayoutStep.this.getDocument().getElementById(LayoutStep.DETAIL_FIELDS_LIST_ID);
            for (int i = detailList.getSelectedIndices().length - 1; i >= 0; --i) {
                details.remove(detailList.getSelectedIndices()[i]);
            }
            LayoutStep.this.setDetailFields(details);
            detailList.setSelectedIndices(EMPTY_SELECTION);
        }

        private void reverseArray(int[] target) {
            for (int i = 0; i < target.length / 2; ++i) {
                int temp = target[i];
                target[i] = target[target.length - i - 1];
                target[target.length - i - 1] = temp;
            }
        }
    }
}

