/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.GetOpt;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModDNContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class LDAPModify
extends LDAPTool {
    private static boolean m_continuous = false;
    private static boolean m_force = false;
    private static boolean m_add = false;
    private static boolean m_binaryFiles = false;
    private static String m_rejectsFile = null;
    private static LDIF m_ldif = null;
    private static String m_file = null;

    private static LDAPAttribute checkFiles(LDAPAttribute lDAPAttribute) {
        LDAPAttribute lDAPAttribute2 = new LDAPAttribute(lDAPAttribute.getName());
        Enumeration enumeration = lDAPAttribute.getStringValues();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string != null && string.length() > 1) {
                    try {
                        File file = new File(string);
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byte[] byArray = new byte[(int)file.length()];
                        fileInputStream.read(byArray, 0, (int)file.length());
                        lDAPAttribute2.addValue(byArray);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        lDAPAttribute2.addValue(string);
                    }
                    catch (IOException iOException) {
                        System.err.println("Unable to read value from file " + string);
                        if (!m_continuous) {
                            System.exit(1);
                        }
                        lDAPAttribute2 = null;
                    }
                    continue;
                }
                lDAPAttribute2.addValue(string);
            }
        } else {
            System.err.println("Failed to do string conversion for " + lDAPAttribute.getName());
        }
        return lDAPAttribute2;
    }

    private static void doModify() throws IOException {
        Object object;
        Serializable serializable;
        PrintWriter printWriter = null;
        Object[] objectArray = null;
        if (!LDAPTool.m_justShow) {
            objectArray = LDAPTool.m_client.getConstraints();
            serializable = new Vector();
            if (LDAPTool.m_proxyControl != null) {
                ((Vector)serializable).addElement(LDAPTool.m_proxyControl);
            }
            if (LDAPTool.m_ordinary) {
                ((Vector)serializable).addElement(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
            }
            if (((Vector)serializable).size() > 0) {
                object = new LDAPControl[((Vector)serializable).size()];
                ((Vector)serializable).copyInto((Object[])object);
                objectArray.setServerControls((LDAPControl[])object);
            }
            objectArray.setReferrals(LDAPTool.m_referrals);
            if (LDAPTool.m_referrals) {
                LDAPTool.setDefaultReferralCredentials((LDAPConstraints)objectArray);
            }
            objectArray.setHopLimit(LDAPTool.m_hopLimit);
        }
        serializable = m_ldif.nextRecord();
        while (serializable != null) {
            Serializable serializable2;
            int n;
            LDAPAttribute[] lDAPAttributeArray;
            int n2;
            int n3;
            Serializable[] serializableArray;
            Object object2;
            LDAPControl[] lDAPControlArray;
            object = objectArray;
            if (!LDAPTool.m_justShow && (lDAPControlArray = ((LDIFRecord)serializable).getControls()) != null) {
                object2 = lDAPControlArray;
                serializableArray = objectArray.getServerControls();
                if (serializableArray != null) {
                    object2 = new LDAPControl[serializableArray.length + lDAPControlArray.length];
                    n3 = 0;
                    while (n3 < serializableArray.length) {
                        object2[n3] = serializableArray[n3];
                        ++n3;
                    }
                    n2 = 0;
                    while (n2 < lDAPControlArray.length) {
                        object2[n2 + serializableArray.length] = lDAPControlArray[n2];
                        ++n2;
                    }
                }
                object = (LDAPSearchConstraints)objectArray.clone();
                ((LDAPConstraints)object).setServerControls((LDAPControl[])object2);
            }
            lDAPControlArray = ((LDIFRecord)serializable).getContent();
            object2 = null;
            serializableArray = null;
            n3 = 0;
            n2 = 0;
            LDAPEntry lDAPEntry = null;
            if (lDAPControlArray instanceof LDIFModifyContent) {
                object2 = ((LDIFModifyContent)lDAPControlArray).getModifications();
            } else if (lDAPControlArray instanceof LDIFAddContent) {
                serializableArray = ((LDIFAddContent)lDAPControlArray).getAttributes();
            } else if (lDAPControlArray instanceof LDIFAttributeContent) {
                if (m_add) {
                    serializableArray = ((LDIFAttributeContent)lDAPControlArray).getAttributes();
                } else {
                    lDAPAttributeArray = ((LDIFAttributeContent)lDAPControlArray).getAttributes();
                    object2 = new LDAPModification[lDAPAttributeArray.length];
                    n = 0;
                    while (n < lDAPAttributeArray.length) {
                        object2[n] = new LDAPModification(2, lDAPAttributeArray[n]);
                        ++n;
                    }
                }
            } else if (lDAPControlArray instanceof LDIFDeleteContent) {
                n3 = 1;
            } else if (lDAPControlArray instanceof LDIFModDNContent) {
                n2 = 1;
            }
            if (serializableArray != null) {
                lDAPAttributeArray = new LDAPAttributeSet();
                n = 0;
                while (n < serializableArray.length) {
                    lDAPAttributeArray.add((LDAPAttribute)serializableArray[n]);
                    ++n;
                }
                lDAPEntry = new LDAPEntry(((LDIFRecord)serializable).getDN(), (LDAPAttributeSet)lDAPAttributeArray);
            }
            boolean bl = false;
            if (m_binaryFiles) {
                LDAPAttribute lDAPAttribute;
                if (object2 != null) {
                    n = 0;
                    while (n < ((LDAPControl[])object2).length) {
                        serializable2 = object2[n];
                        LDAPAttribute lDAPAttribute2 = ((LDAPModification)((Object)object2[n])).getAttribute();
                        lDAPAttribute = LDAPModify.checkFiles(lDAPAttribute2);
                        if (lDAPAttribute == null) {
                            bl = true;
                        } else {
                            object2[n] = new LDAPModification(((LDAPModification)serializable2).getOp(), lDAPAttribute);
                        }
                        ++n;
                    }
                } else if (serializableArray != null) {
                    LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                    int n4 = 0;
                    while (n4 < serializableArray.length) {
                        Serializable serializable3 = serializableArray[n4];
                        lDAPAttribute = LDAPModify.checkFiles((LDAPAttribute)serializable3);
                        if (lDAPAttribute == null) {
                            bl = true;
                            break;
                        }
                        lDAPAttributeSet.add(lDAPAttribute);
                        ++n4;
                    }
                    if (!bl) {
                        lDAPEntry = new LDAPEntry(((LDIFRecord)serializable).getDN(), lDAPAttributeSet);
                    }
                }
            }
            n = 0;
            if (!bl) {
                try {
                    if (object2 != null) {
                        serializable2 = new LDAPModificationSet();
                        System.out.println("\nmodifying entry " + ((LDIFRecord)serializable).getDN());
                        int n5 = 0;
                        while (n5 < ((LDAPControl[])object2).length) {
                            if (LDAPTool.m_verbose) {
                                System.out.println("\t" + object2[n5]);
                            }
                            ((LDAPModificationSet)serializable2).add(((LDAPModification)((Object)object2[n5])).getOp(), ((LDAPModification)((Object)object2[n5])).getAttribute());
                            ++n5;
                        }
                        if (!LDAPTool.m_justShow) {
                            LDAPTool.m_client.modify(((LDIFRecord)serializable).getDN(), (LDAPModificationSet)serializable2, (LDAPConstraints)object);
                        }
                    } else if (lDAPEntry != null) {
                        System.out.println("\nadding new entry " + lDAPEntry.getDN());
                        if (LDAPTool.m_verbose) {
                            serializable2 = lDAPEntry.getAttributeSet();
                            int n6 = 0;
                            while (n6 < ((LDAPAttributeSet)serializable2).size()) {
                                System.out.println("\t" + ((LDAPAttributeSet)serializable2).elementAt(n6));
                                ++n6;
                            }
                        }
                        if (!LDAPTool.m_justShow) {
                            LDAPTool.m_client.add(lDAPEntry, (LDAPConstraints)object);
                        }
                    } else if (n3 != 0) {
                        System.out.println("\ndeleting entry " + ((LDIFRecord)serializable).getDN());
                        if (!LDAPTool.m_justShow) {
                            LDAPTool.m_client.delete(((LDIFRecord)serializable).getDN(), (LDAPConstraints)object);
                        }
                    } else if (n2 != 0) {
                        System.out.println("\nmodifying RDN of entry " + ((LDIFRecord)serializable).getDN() + " and/or moving it beneath a new parent");
                        if (LDAPTool.m_verbose) {
                            System.out.println("\t" + lDAPControlArray.toString());
                        }
                        if (!LDAPTool.m_justShow) {
                            serializable2 = (LDIFModDNContent)lDAPControlArray;
                            LDAPTool.m_client.rename(((LDIFRecord)serializable).getDN(), ((LDIFModDNContent)serializable2).getRDN(), ((LDIFModDNContent)serializable2).getNewParent(), ((LDIFModDNContent)serializable2).getDeleteOldRDN(), (LDAPConstraints)object);
                            System.out.println("rename completed");
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    System.err.println(String.valueOf(((LDIFRecord)serializable).getDN()) + ": " + lDAPException.errorCodeToString());
                    if (lDAPException.getLDAPErrorMessage() != null) {
                        System.err.println("additional info: " + lDAPException.getLDAPErrorMessage());
                    }
                    if (!m_continuous) {
                        System.exit(1);
                    }
                    bl = true;
                    n = lDAPException.getLDAPResultCode();
                }
            }
            if (bl && m_rejectsFile != null) {
                try {
                    if (printWriter == null) {
                        printWriter = new PrintWriter(new FileOutputStream(m_rejectsFile));
                    }
                }
                catch (Exception exception) {}
                if (printWriter != null) {
                    printWriter.println("dn: " + ((LDIFRecord)serializable).getDN() + " # Error: " + n);
                    if (object2 != null) {
                        int n7 = 0;
                        while (n7 < ((LDAPControl[])object2).length) {
                            printWriter.println(((LDAPModification)((Object)object2[n7])).toString());
                            ++n7;
                        }
                    } else if (lDAPEntry != null) {
                        printWriter.println("Add " + lDAPEntry.toString());
                    } else if (n3 != 0) {
                        printWriter.println("Delete " + ((LDIFRecord)serializable).getDN());
                    } else if (n2 != 0) {
                        printWriter.println("ModDN " + ((LDIFModDNContent)lDAPControlArray).toString());
                    }
                    printWriter.flush();
                }
            }
            serializable = m_ldif.nextRecord();
        }
        System.exit(0);
    }

    private static void doUsage() {
        System.err.println("usage: LDAPModify [options]");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -c            continuous mode (do not stop on errors)");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -f file       read modifications from file instead of standard input");
        System.err.println("  -a            add entries");
        System.err.println("  -b            read values that start with / from files (for bin attrs)");
        System.err.println("  -n            show what would be done but don't actually do it");
        System.err.println("  -v            run in verbose mode");
        System.err.println("  -r            replace existing values by default");
        System.err.println("  -e rejectfile save rejected entries in 'rejfile'");
        System.err.println("  -y proxy-DN   DN to use for access control");
    }

    protected static void extractParameters(String[] stringArray) {
        String string = "abcHFre:f:";
        GetOpt getOpt = LDAPTool.extractParameters(string, stringArray);
        if (getOpt.hasOption('H')) {
            LDAPModify.doUsage();
            System.exit(0);
        }
        if (getOpt.hasOption('F')) {
            m_force = true;
        }
        if (getOpt.hasOption('a')) {
            m_add = true;
        }
        if (getOpt.hasOption('c')) {
            m_continuous = true;
        }
        if (getOpt.hasOption('r')) {
            m_add = false;
        }
        if (getOpt.hasOption('b')) {
            m_binaryFiles = true;
        }
        if (getOpt.hasOption('f')) {
            m_file = getOpt.getOptionParam('f');
        }
        if (getOpt.hasOption('e')) {
            m_rejectsFile = getOpt.getOptionParam('e');
        }
    }

    public static void main(String[] stringArray) {
        LDAPModify.extractParameters(stringArray);
        try {
            if (!LDAPTool.m_justShow) {
                LDAPTool.m_client = new LDAPConnection();
                LDAPTool.m_client.connect(LDAPTool.m_ldaphost, LDAPTool.m_ldapport);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: client connection failed!");
            System.exit(0);
        }
        try {
            if (!LDAPTool.m_justShow) {
                LDAPTool.m_client.authenticate(LDAPTool.m_version, LDAPTool.m_binddn, LDAPTool.m_passwd);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(0);
        }
        try {
            m_ldif = m_file != null ? new LDIF(m_file) : new LDIF();
        }
        catch (Exception exception) {
            if (m_file == null) {
                m_file = "stdin";
            }
            System.err.println("Failed to read LDIF file " + m_file + ", " + exception.toString());
            System.exit(0);
        }
        try {
            LDAPModify.doModify();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        try {
            if (!LDAPTool.m_justShow) {
                LDAPTool.m_client.disconnect();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        System.exit(0);
    }
}

