/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.pmd.util;

import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.repository.InMemoryMetadataDomainRepository;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdConnectionProvider;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class LoadRepositoryRunnable
implements Runnable {
    private IMetadataDomainRepository repository;
    private DesignTimeContext context;
    private String domainId;
    private String fileName;

    public LoadRepositoryRunnable(DesignTimeContext context, String domainId, String fileName) {
        this.context = context;
        this.domainId = domainId;
        this.fileName = fileName;
    }

    @Override
    public void run() {
        this.repository = this.buildDomainRepository();
    }

    private IMetadataDomainRepository buildDomainRepository() {
        try {
            AbstractReportDefinition report = this.context.getReport();
            MasterReport masterReport = DesignTimeUtil.getMasterReport((Element)report);
            ResourceKey contentBase = masterReport == null ? null : masterReport.getContentBase();
            ResourceManager resourceManager = DesignTimeUtil.getResourceManager((AbstractReportDefinition)report);
            return new PmdConnectionProvider().getMetadataDomainRepository(this.domainId, resourceManager, contentBase, this.fileName);
        }
        catch (Exception e) {
            this.context.error(e);
            return new InMemoryMetadataDomainRepository();
        }
    }

    public IMetadataDomainRepository getRepository() {
        return this.repository;
    }
}

