/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.s3csvinput;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.util.List;
import org.pentaho.di.trans.steps.s3csvinput.Messages;

public class S3ObjectsProvider {
    private AmazonS3 s3Client;

    public S3ObjectsProvider(AmazonS3 s3Client) {
        this.s3Client = s3Client;
    }

    private List<Bucket> getBuckets() throws SdkClientException {
        List result;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            result = this.s3Client.listBuckets();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        return result;
    }

    public String[] getBucketsNames() throws SdkClientException {
        return (String[])this.getBuckets().stream().map(b -> b.getName()).toArray(String[]::new);
    }

    public Bucket getBucket(String bucketName) throws SdkClientException {
        return this.getBuckets().stream().filter(x -> bucketName.equals(x.getName())).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectListing getS3Objects(Bucket bucket) throws SdkClientException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ObjectListing objectListing = this.s3Client.listObjects(bucket.getName());
            return objectListing;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public String[] getS3ObjectsNames(String bucketName) throws Exception {
        Bucket bucket = this.getBucket(bucketName);
        if (bucket == null) {
            throw new Exception(Messages.getString("S3DefaultService.Exception.UnableToFindBucket.Message", bucketName));
        }
        return (String[])this.getS3Objects(bucket).getObjectSummaries().stream().map(b -> b.getKey()).toArray(String[]::new);
    }

    public S3Object getS3Object(Bucket bucket, String objectKey, Long byteRangeStart, Long byteRangeEnd) throws SdkClientException {
        if (byteRangeStart != null && byteRangeEnd != null) {
            GetObjectRequest rangeObjectRequest = new GetObjectRequest(bucket.getName(), objectKey).withRange(byteRangeStart.longValue(), byteRangeEnd.longValue());
            return this.s3Client.getObject(rangeObjectRequest);
        }
        return this.s3Client.getObject(bucket.getName(), objectKey);
    }

    public S3Object getS3Object(Bucket bucket, String objectKey) throws SdkClientException {
        return this.getS3Object(bucket, objectKey, null, null);
    }

    private ObjectMetadata getS3ObjectDetails(Bucket bucket, String objectKey) throws SdkClientException {
        return this.s3Client.getObjectMetadata(bucket.getName(), objectKey);
    }

    public long getS3ObjectContentLenght(Bucket bucket, String objectKey) throws SdkClientException {
        return this.getS3ObjectDetails(bucket, objectKey).getContentLength();
    }
}

