/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DirectoryScanner
implements Runnable {
    private static final Log LOG = LogFactory.getLog(DirectoryScanner.class);
    private final FsDatasetSpi<?> dataset;
    private final ExecutorService reportCompileThreadPool;
    private final ScheduledExecutorService masterThread;
    private final long scanPeriodMsecs;
    private volatile boolean shouldRun = false;
    private boolean retainDiffs = false;
    private final DataNode datanode;
    final ScanInfoPerBlockPool diffs = new ScanInfoPerBlockPool();
    final Map<String, Stats> stats = new HashMap<String, Stats>();

    void setRetainDiffs(boolean b) {
        this.retainDiffs = b;
    }

    DirectoryScanner(DataNode datanode, FsDatasetSpi<?> dataset, Configuration conf) {
        this.datanode = datanode;
        this.dataset = dataset;
        int interval = conf.getInt("dfs.datanode.directoryscan.interval", 21600);
        this.scanPeriodMsecs = (long)interval * 1000L;
        int threads = conf.getInt("dfs.datanode.directoryscan.threads", 1);
        this.reportCompileThreadPool = Executors.newFixedThreadPool(threads, (ThreadFactory)new Daemon.DaemonFactory());
        this.masterThread = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new Daemon.DaemonFactory());
    }

    void start() {
        this.shouldRun = true;
        long offset = (long)DFSUtil.getRandom().nextInt((int)(this.scanPeriodMsecs / 1000L)) * 1000L;
        long firstScanTime = Time.now() + offset;
        LOG.info((Object)("Periodic Directory Tree Verification scan starting at " + firstScanTime + " with interval " + this.scanPeriodMsecs));
        this.masterThread.scheduleAtFixedRate(this, offset, this.scanPeriodMsecs, TimeUnit.MILLISECONDS);
    }

    boolean getRunStatus() {
        return this.shouldRun;
    }

    private void clear() {
        this.diffs.clear();
        this.stats.clear();
    }

    @Override
    public void run() {
        try {
            if (!this.shouldRun) {
                LOG.warn((Object)"this cycle terminating immediately because 'shouldRun' has been deactivated");
                return;
            }
            this.reconcile();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception during DirectoryScanner execution - will continue next cycle", (Throwable)e);
        }
        catch (Error er) {
            LOG.error((Object)"System Error during DirectoryScanner execution - permanently terminating periodic scanner", (Throwable)er);
            throw er;
        }
    }

    void shutdown() {
        if (!this.shouldRun) {
            LOG.warn((Object)"DirectoryScanner: shutdown has been called, but periodic scanner not started");
        } else {
            LOG.warn((Object)"DirectoryScanner: shutdown has been called");
        }
        this.shouldRun = false;
        if (this.masterThread != null) {
            this.masterThread.shutdown();
        }
        if (this.reportCompileThreadPool != null) {
            this.reportCompileThreadPool.shutdown();
        }
        if (this.masterThread != null) {
            try {
                this.masterThread.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"interrupted while waiting for masterThread to terminate", (Throwable)e);
            }
        }
        if (this.reportCompileThreadPool != null) {
            try {
                this.reportCompileThreadPool.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"interrupted while waiting for reportCompileThreadPool to terminate", (Throwable)e);
            }
        }
        if (!this.retainDiffs) {
            this.clear();
        }
    }

    void reconcile() throws IOException {
        this.scan();
        for (Map.Entry entry : this.diffs.entrySet()) {
            String bpid = (String)entry.getKey();
            LinkedList diff = (LinkedList)entry.getValue();
            for (ScanInfo info : diff) {
                this.dataset.checkAndUpdate(bpid, info.getBlockId(), info.getBlockFile(), info.getMetaFile(), info.getVolume());
            }
        }
        if (!this.retainDiffs) {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan() {
        this.clear();
        Map<String, ScanInfo[]> diskReport = this.getDiskReport();
        FsDatasetSpi<?> fsDatasetSpi = this.dataset;
        synchronized (fsDatasetSpi) {
            for (Map.Entry<String, ScanInfo[]> entry : diskReport.entrySet()) {
                String bpid = entry.getKey();
                ScanInfo[] blockpoolReport = entry.getValue();
                Stats statsRecord = new Stats(bpid);
                this.stats.put(bpid, statsRecord);
                LinkedList<ScanInfo> diffRecord = new LinkedList<ScanInfo>();
                this.diffs.put(bpid, diffRecord);
                statsRecord.totalBlocks = blockpoolReport.length;
                List<FinalizedReplica> bl = this.dataset.getFinalizedBlocks(bpid);
                Collections.sort(bl);
                int d = 0;
                int m = 0;
                while (m < bl.size() && d < blockpoolReport.length) {
                    FinalizedReplica memBlock = bl.get(m);
                    ScanInfo info = blockpoolReport[d];
                    if (info.getBlockId() < memBlock.getBlockId()) {
                        if (!this.dataset.isDeletingBlock(bpid, info.getBlockId())) {
                            ++statsRecord.missingMemoryBlocks;
                            this.addDifference(diffRecord, statsRecord, info);
                        }
                        ++d;
                        continue;
                    }
                    if (info.getBlockId() > memBlock.getBlockId()) {
                        this.addDifference(diffRecord, statsRecord, memBlock.getBlockId(), info.getVolume());
                        ++m;
                        continue;
                    }
                    if (info.getBlockFile() == null) {
                        this.addDifference(diffRecord, statsRecord, info);
                    } else if (info.getGenStamp() != memBlock.getGenerationStamp() || info.getBlockFileLength() != memBlock.getNumBytes()) {
                        ++statsRecord.mismatchBlocks;
                        this.addDifference(diffRecord, statsRecord, info);
                    } else if (info.getBlockFile().compareTo(memBlock.getBlockFile()) != 0) {
                        ++statsRecord.duplicateBlocks;
                        this.addDifference(diffRecord, statsRecord, info);
                    }
                    if (++d < blockpoolReport.length) {
                        ScanInfo nextInfo = blockpoolReport[Math.min(d, blockpoolReport.length - 1)];
                        if (nextInfo.getBlockId() == info.blockId) continue;
                        ++m;
                        continue;
                    }
                    ++m;
                }
                while (m < bl.size()) {
                    FinalizedReplica current = bl.get(m++);
                    this.addDifference(diffRecord, statsRecord, current.getBlockId(), current.getVolume());
                }
                while (d < blockpoolReport.length) {
                    if (!this.dataset.isDeletingBlock(bpid, blockpoolReport[d].getBlockId())) {
                        ++statsRecord.missingMemoryBlocks;
                        this.addDifference(diffRecord, statsRecord, blockpoolReport[d]);
                    }
                    ++d;
                }
                LOG.info((Object)statsRecord.toString());
            }
        }
    }

    private void addDifference(LinkedList<ScanInfo> diffRecord, Stats statsRecord, ScanInfo info) {
        statsRecord.missingMetaFile = statsRecord.missingMetaFile + (info.getMetaFile() == null ? 1L : 0L);
        statsRecord.missingBlockFile = statsRecord.missingBlockFile + (info.getBlockFile() == null ? 1L : 0L);
        diffRecord.add(info);
    }

    private void addDifference(LinkedList<ScanInfo> diffRecord, Stats statsRecord, long blockId, FsVolumeSpi vol) {
        ++statsRecord.missingBlockFile;
        ++statsRecord.missingMetaFile;
        diffRecord.add(new ScanInfo(blockId, null, null, vol));
    }

    /*
     * Exception decompiling
     */
    private Map<String, ScanInfo[]> getDiskReport() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isBlockMetaFile(String blockId, String metaFile) {
        return metaFile.startsWith(blockId) && metaFile.endsWith(".meta");
    }

    private static class ReportCompiler
    implements Callable<ScanInfoPerBlockPool> {
        private final FsVolumeSpi volume;
        private final DataNode datanode;

        public ReportCompiler(DataNode datanode, FsVolumeSpi volume) {
            this.datanode = datanode;
            this.volume = volume;
        }

        @Override
        public ScanInfoPerBlockPool call() throws Exception {
            String[] bpList = this.volume.getBlockPoolList();
            ScanInfoPerBlockPool result = new ScanInfoPerBlockPool(bpList.length);
            for (String bpid : bpList) {
                LinkedList<ScanInfo> report = new LinkedList<ScanInfo>();
                File bpFinalizedDir = this.volume.getFinalizedDir(bpid);
                result.put(bpid, this.compileReport(this.volume, bpFinalizedDir, bpFinalizedDir, report));
            }
            return result;
        }

        private LinkedList<ScanInfo> compileReport(FsVolumeSpi vol, File bpFinalizedDir, File dir, LinkedList<ScanInfo> report) {
            Object[] files;
            FileIoProvider fileIoProvider = this.datanode.getFileIoProvider();
            try {
                files = fileIoProvider.listFiles(this.volume, dir);
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Exception occured while compiling report: ", (Throwable)ioe);
                this.datanode.checkDiskErrorAsync(this.volume);
                return report;
            }
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                if (((File)files[i]).isDirectory()) {
                    this.compileReport(vol, bpFinalizedDir, (File)files[i], report);
                    continue;
                }
                if (!Block.isBlockFilename((File)files[i])) {
                    if (!DirectoryScanner.isBlockMetaFile("blk_", ((File)files[i]).getName())) continue;
                    long blockId = Block.getBlockId(((File)files[i]).getName());
                    this.verifyFileLocation(((File)files[i]).getParentFile(), bpFinalizedDir, blockId);
                    report.add(new ScanInfo(blockId, null, (File)files[i], vol));
                    continue;
                }
                Object blockFile = files[i];
                long blockId = Block.filename2id(((File)blockFile).getName());
                Object metaFile = null;
                while (i + 1 < files.length && ((File)files[i + 1]).isFile() && ((File)files[i + 1]).getName().startsWith(((File)blockFile).getName())) {
                    if (!DirectoryScanner.isBlockMetaFile(((File)blockFile).getName(), ((File)files[++i]).getName())) continue;
                    metaFile = files[i];
                    break;
                }
                this.verifyFileLocation((File)blockFile, bpFinalizedDir, blockId);
                report.add(new ScanInfo(blockId, (File)blockFile, (File)metaFile, vol));
            }
            return report;
        }

        private void verifyFileLocation(File actualBlockFile, File bpFinalizedDir, long blockId) {
            File blockDir = DatanodeUtil.idToBlockDir(bpFinalizedDir, blockId);
            if (actualBlockFile.getParentFile().compareTo(blockDir) != 0) {
                File expBlockFile = new File(blockDir, actualBlockFile.getName());
                LOG.warn((Object)("Block: " + blockId + " has to be upgraded to block ID-based layout. " + "Actual block file path: " + actualBlockFile + ", expected block file path: " + expBlockFile));
            }
        }
    }

    static class ScanInfo
    implements Comparable<ScanInfo> {
        private final long blockId;
        private final String blockSuffix;
        private final String metaSuffix;
        private final FsVolumeSpi volume;
        private final long blockFileLength;
        private static final Pattern CONDENSED_PATH_REGEX = Pattern.compile("(?<!^)(\\\\|/){2,}");
        private static final String QUOTED_FILE_SEPARATOR = Matcher.quoteReplacement(File.separator);

        private static String getCondensedPath(String path) {
            return CONDENSED_PATH_REGEX.matcher(path).replaceAll(QUOTED_FILE_SEPARATOR);
        }

        private static String getSuffix(File f, String prefix) {
            String fullPath = ScanInfo.getCondensedPath(f.getAbsolutePath());
            if (fullPath.startsWith(prefix)) {
                return fullPath.substring(prefix.length());
            }
            throw new RuntimeException(prefix + " is not a prefix of " + fullPath);
        }

        ScanInfo(long blockId, File blockFile, File metaFile, FsVolumeSpi vol) {
            this.blockId = blockId;
            String condensedVolPath = vol == null ? null : ScanInfo.getCondensedPath(vol.getBasePath());
            this.blockSuffix = blockFile == null ? null : ScanInfo.getSuffix(blockFile, condensedVolPath);
            long l = this.blockFileLength = blockFile != null ? blockFile.length() : 0L;
            this.metaSuffix = metaFile == null ? null : (blockFile == null ? ScanInfo.getSuffix(metaFile, condensedVolPath) : ScanInfo.getSuffix(metaFile, condensedVolPath + this.blockSuffix));
            this.volume = vol;
        }

        File getBlockFile() {
            return this.blockSuffix == null ? null : new File(this.volume.getBasePath(), this.blockSuffix);
        }

        long getBlockFileLength() {
            return this.blockFileLength;
        }

        File getMetaFile() {
            if (this.metaSuffix == null) {
                return null;
            }
            if (this.blockSuffix == null) {
                return new File(this.volume.getBasePath(), this.metaSuffix);
            }
            return new File(this.volume.getBasePath(), this.blockSuffix + this.metaSuffix);
        }

        long getBlockId() {
            return this.blockId;
        }

        FsVolumeSpi getVolume() {
            return this.volume;
        }

        @Override
        public int compareTo(ScanInfo b) {
            if (this.blockId < b.blockId) {
                return -1;
            }
            if (this.blockId == b.blockId) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScanInfo)) {
                return false;
            }
            return this.blockId == ((ScanInfo)o).blockId;
        }

        public int hashCode() {
            return (int)(this.blockId ^ this.blockId >>> 32);
        }

        public long getGenStamp() {
            return this.metaSuffix != null ? Block.getGenerationStamp(this.getMetaFile().getName()) : 0L;
        }
    }

    static class ScanInfoPerBlockPool
    extends HashMap<String, LinkedList<ScanInfo>> {
        private static final long serialVersionUID = 1L;

        ScanInfoPerBlockPool() {
        }

        ScanInfoPerBlockPool(int sz) {
            super(sz);
        }

        public void addAll(ScanInfoPerBlockPool that) {
            if (that == null) {
                return;
            }
            for (Map.Entry entry : that.entrySet()) {
                String bpid = (String)entry.getKey();
                LinkedList list = (LinkedList)entry.getValue();
                if (this.containsKey(bpid)) {
                    ((LinkedList)this.get(bpid)).addAll(list);
                    continue;
                }
                this.put(bpid, list);
            }
        }

        public Map<String, ScanInfo[]> toSortedArrays() {
            HashMap<String, ScanInfo[]> result = new HashMap<String, ScanInfo[]>(this.size());
            for (Map.Entry entry : this.entrySet()) {
                String bpid = (String)entry.getKey();
                LinkedList list = (LinkedList)entry.getValue();
                Object[] record = list.toArray(new ScanInfo[list.size()]);
                Arrays.sort(record);
                result.put(bpid, (ScanInfo[])record);
            }
            return result;
        }
    }

    static class Stats {
        final String bpid;
        long totalBlocks = 0L;
        long missingMetaFile = 0L;
        long missingBlockFile = 0L;
        long missingMemoryBlocks = 0L;
        long mismatchBlocks = 0L;
        long duplicateBlocks = 0L;

        public Stats(String bpid) {
            this.bpid = bpid;
        }

        public String toString() {
            return "BlockPool " + this.bpid + " Total blocks: " + this.totalBlocks + ", missing metadata files:" + this.missingMetaFile + ", missing block files:" + this.missingBlockFile + ", missing blocks in memory:" + this.missingMemoryBlocks + ", mismatched blocks:" + this.mismatchBlocks;
        }
    }
}

