/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.security.SaslPropertiesResolver;

@InterfaceAudience.Private
public class DNConf {
    final Configuration conf;
    final int socketTimeout;
    final int socketWriteTimeout;
    final int socketKeepaliveTimeout;
    private final int transferSocketSendBufferSize;
    private final int transferSocketRecvBufferSize;
    final boolean transferToAllowed;
    final boolean dropCacheBehindWrites;
    final boolean syncBehindWrites;
    final boolean syncBehindWritesInBackground;
    final boolean dropCacheBehindReads;
    final boolean syncOnClose;
    final boolean encryptDataTransfer;
    final boolean connectToDnViaHostname;
    final long readaheadLength;
    final long heartBeatInterval;
    private final long lifelineIntervalMs;
    final long blockReportInterval;
    final long blockReportSplitThreshold;
    final boolean peerStatsEnabled;
    final boolean diskStatsEnabled;
    final long outliersReportIntervalMs;
    final long ibrInterval;
    final long initialBlockReportDelayMs;
    final long cacheReportInterval;
    final long dfsclientSlowIoWarningThresholdMs;
    final long datanodeSlowIoWarningThresholdMs;
    final int writePacketSize;
    final String minimumNameNodeVersion;
    final String encryptionAlgorithm;
    final SaslPropertiesResolver saslPropsResolver;
    final TrustedChannelResolver trustedChannelResolver;
    private final boolean ignoreSecurePortsForTesting;
    final long xceiverStopTimeout;
    final long restartReplicaExpiry;
    final long maxLockedMemory;
    private final long bpReadyTimeout;
    private final int volFailuresTolerated;
    private final int volsConfigured;

    public DNConf(Configuration conf) {
        this.conf = conf;
        this.socketTimeout = conf.getInt("dfs.client.socket-timeout", 60000);
        this.socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.socketKeepaliveTimeout = conf.getInt("dfs.datanode.socket.reuse.keepalive", 4000);
        this.transferSocketSendBufferSize = conf.getInt("dfs.datanode.transfer.socket.send.buffer.size", 131072);
        this.transferSocketRecvBufferSize = conf.getInt("dfs.datanode.transfer.socket.recv.buffer.size", 131072);
        this.transferToAllowed = conf.getBoolean("dfs.datanode.transferTo.allowed", true);
        this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
        this.readaheadLength = conf.getLong("dfs.datanode.readahead.bytes", 0x400000L);
        this.dropCacheBehindWrites = conf.getBoolean("dfs.datanode.drop.cache.behind.writes", false);
        this.syncBehindWrites = conf.getBoolean("dfs.datanode.sync.behind.writes", false);
        this.syncBehindWritesInBackground = conf.getBoolean("dfs.datanode.sync.behind.writes.in.background", false);
        this.dropCacheBehindReads = conf.getBoolean("dfs.datanode.drop.cache.behind.reads", false);
        this.connectToDnViaHostname = conf.getBoolean("dfs.datanode.use.datanode.hostname", false);
        this.blockReportInterval = conf.getLong("dfs.blockreport.intervalMsec", 21600000L);
        this.peerStatsEnabled = conf.getBoolean("dfs.datanode.peer.stats.enabled", false);
        this.diskStatsEnabled = Util.isDiskStatsEnabled(this.getConf().getDouble("dfs.datanode.fileio.profiling.sampling.fraction", 0.0));
        this.outliersReportIntervalMs = this.getConf().getTimeDuration("dfs.datanode.outliers.report.interval", 1800000L, TimeUnit.MILLISECONDS);
        this.ibrInterval = conf.getLong("dfs.blockreport.incremental.intervalMsec", 0L);
        this.blockReportSplitThreshold = conf.getLong("dfs.blockreport.split.threshold", 1000000L);
        this.cacheReportInterval = conf.getLong("dfs.cachereport.intervalMsec", 10000L);
        this.dfsclientSlowIoWarningThresholdMs = conf.getLong("dfs.client.slow.io.warning.threshold.ms", 30000L);
        this.datanodeSlowIoWarningThresholdMs = conf.getLong("dfs.datanode.slow.io.warning.threshold.ms", 300L);
        long initBRDelay = conf.getLong("dfs.blockreport.initialDelay", 0L) * 1000L;
        if (initBRDelay >= this.blockReportInterval) {
            initBRDelay = 0L;
            DataNode.LOG.info("dfs.blockreport.initialDelay is greater than dfs.blockreport.intervalMsec. Setting initial delay to 0 msec:");
        }
        this.initialBlockReportDelayMs = initBRDelay;
        this.heartBeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        long confLifelineIntervalMs = conf.getLong("dfs.datanode.lifeline.interval.seconds", 3L * conf.getLong("dfs.heartbeat.interval", 3L)) * 1000L;
        if (confLifelineIntervalMs <= this.heartBeatInterval) {
            confLifelineIntervalMs = 3L * this.heartBeatInterval;
            DataNode.LOG.warn(String.format("%s must be set to a value greater than %s.  Resetting value to 3 * %s, which is %d milliseconds.", "dfs.datanode.lifeline.interval.seconds", "dfs.heartbeat.interval", "dfs.heartbeat.interval", confLifelineIntervalMs));
        }
        this.lifelineIntervalMs = confLifelineIntervalMs;
        this.syncOnClose = conf.getBoolean("dfs.datanode.synconclose", false);
        this.minimumNameNodeVersion = conf.get("dfs.datanode.min.supported.namenode.version", "2.1.0-beta");
        this.encryptDataTransfer = conf.getBoolean("dfs.encrypt.data.transfer", false);
        this.encryptionAlgorithm = conf.get("dfs.encrypt.data.transfer.algorithm");
        this.trustedChannelResolver = TrustedChannelResolver.getInstance(conf);
        this.saslPropsResolver = DataTransferSaslUtil.getSaslPropertiesResolver(conf);
        this.ignoreSecurePortsForTesting = conf.getBoolean("ignore.secure.ports.for.testing", false);
        this.xceiverStopTimeout = conf.getLong("dfs.datanode.xceiver.stop.timeout.millis", 60000L);
        this.maxLockedMemory = conf.getLong("dfs.datanode.max.locked.memory", 0L);
        this.restartReplicaExpiry = conf.getLong("dfs.datanode.restart.replica.expiration", 50L) * 1000L;
        this.bpReadyTimeout = conf.getLong("dfs.datanode.bp-ready.timeout", 20L);
        this.volFailuresTolerated = conf.getInt("dfs.datanode.failed.volumes.tolerated", 0);
        String[] dataDirs = conf.getTrimmedStrings("dfs.datanode.data.dir");
        this.volsConfigured = dataDirs == null ? 0 : dataDirs.length;
    }

    String getMinimumNameNodeVersion() {
        return this.minimumNameNodeVersion;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public boolean getEncryptDataTransfer() {
        return this.encryptDataTransfer;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public long getXceiverStopTimeout() {
        return this.xceiverStopTimeout;
    }

    public long getMaxLockedMemory() {
        return this.maxLockedMemory;
    }

    public SaslPropertiesResolver getSaslPropsResolver() {
        return this.saslPropsResolver;
    }

    public TrustedChannelResolver getTrustedChannelResolver() {
        return this.trustedChannelResolver;
    }

    public boolean getIgnoreSecurePortsForTesting() {
        return this.ignoreSecurePortsForTesting;
    }

    public int getTransferSocketRecvBufferSize() {
        return this.transferSocketRecvBufferSize;
    }

    public int getTransferSocketSendBufferSize() {
        return this.transferSocketSendBufferSize;
    }

    public long getBpReadyTimeout() {
        return this.bpReadyTimeout;
    }

    public long getLifelineIntervalMs() {
        return this.lifelineIntervalMs;
    }

    public long getSlowIoWarningThresholdMs() {
        return this.datanodeSlowIoWarningThresholdMs;
    }

    public int getVolFailuresTolerated() {
        return this.volFailuresTolerated;
    }

    public int getVolsConfigured() {
        return this.volsConfigured;
    }
}

