/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.fast;

import java.io.IOException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public abstract class DeserializeRead {
    protected TypeInfo[] typeInfos;
    protected boolean[] columnsToInclude;
    protected ObjectInspector.Category[] categories;
    protected PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories;
    public boolean currentBoolean;
    public byte currentByte;
    public short currentShort;
    public int currentInt;
    public long currentLong;
    public float currentFloat;
    public double currentDouble;
    public byte[] currentBytes;
    public int currentBytesStart;
    public int currentBytesLength;
    public DateWritable currentDateWritable;
    public TimestampWritable currentTimestampWritable;
    public HiveIntervalYearMonthWritable currentHiveIntervalYearMonthWritable;
    public HiveIntervalDayTimeWritable currentHiveIntervalDayTimeWritable;
    public HiveDecimalWritable currentHiveDecimalWritable;

    public DeserializeRead(TypeInfo[] typeInfos) {
        this.typeInfos = typeInfos;
        int count = typeInfos.length;
        this.categories = new ObjectInspector.Category[count];
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[count];
        block7: for (int i = 0; i < count; ++i) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
            ObjectInspector.Category category;
            TypeInfo typeInfo = typeInfos[i];
            this.categories[i] = category = typeInfo.getCategory();
            if (category != ObjectInspector.Category.PRIMITIVE) continue;
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
            this.primitiveCategories[i] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            switch (primitiveCategory) {
                case DATE: {
                    if (this.currentDateWritable != null) continue block7;
                    this.currentDateWritable = new DateWritable();
                    continue block7;
                }
                case TIMESTAMP: {
                    if (this.currentTimestampWritable != null) continue block7;
                    this.currentTimestampWritable = new TimestampWritable();
                    continue block7;
                }
                case INTERVAL_YEAR_MONTH: {
                    if (this.currentHiveIntervalYearMonthWritable != null) continue block7;
                    this.currentHiveIntervalYearMonthWritable = new HiveIntervalYearMonthWritable();
                    continue block7;
                }
                case INTERVAL_DAY_TIME: {
                    if (this.currentHiveIntervalDayTimeWritable != null) continue block7;
                    this.currentHiveIntervalDayTimeWritable = new HiveIntervalDayTimeWritable();
                    continue block7;
                }
                case DECIMAL: {
                    if (this.currentHiveDecimalWritable != null) continue block7;
                    this.currentHiveDecimalWritable = new HiveDecimalWritable();
                    continue block7;
                }
            }
        }
        this.columnsToInclude = null;
    }

    protected DeserializeRead() {
    }

    public TypeInfo[] typeInfos() {
        return this.typeInfos;
    }

    public void setColumnsToInclude(boolean[] columnsToInclude) {
        this.columnsToInclude = columnsToInclude;
    }

    public abstract void set(byte[] var1, int var2, int var3);

    public abstract boolean readCheckNull() throws IOException;

    public abstract void extraFieldsCheck();

    public abstract boolean readBeyondConfiguredFieldsWarned();

    public abstract boolean bufferRangeHasExtraDataWarned();

    public abstract String getDetailedReadPositionString();
}

