/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 739: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 740: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 799: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 742: {
                return new ExportSemanticAnalyzer(queryState);
            }
            case 768: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 651: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 660: 
                    case 661: 
                    case 662: 
                    case 663: 
                    case 667: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 681: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 682: 
                    case 683: 
                    case 684: 
                    case 685: 
                    case 686: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 860);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 643: 
            case 647: 
            case 648: 
            case 649: 
            case 650: 
            case 658: 
            case 693: 
            case 701: 
            case 703: 
            case 706: 
            case 723: 
            case 724: 
            case 725: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 753: 
            case 755: 
            case 800: 
            case 801: 
            case 805: 
            case 871: 
            case 872: 
            case 887: 
            case 888: 
            case 889: 
            case 890: 
            case 891: 
            case 892: 
            case 893: 
            case 894: 
            case 895: 
            case 896: 
            case 897: 
            case 898: 
            case 899: 
            case 900: 
            case 901: 
            case 902: 
            case 903: 
            case 904: 
            case 905: 
            case 906: 
            case 924: 
            case 966: 
            case 974: 
            case 975: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 702: 
            case 732: 
            case 864: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 687: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 705: 
            case 734: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 722: 
            case 976: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(739, HiveOperation.EXPLAIN);
        commandType.put(799, HiveOperation.LOAD);
        commandType.put(742, HiveOperation.EXPORT);
        commandType.put(768, HiveOperation.IMPORT);
        commandType.put(701, HiveOperation.CREATEDATABASE);
        commandType.put(731, HiveOperation.DROPDATABASE);
        commandType.put(924, HiveOperation.SWITCHDATABASE);
        commandType.put(707, HiveOperation.CREATETABLE);
        commandType.put(966, HiveOperation.TRUNCATETABLE);
        commandType.put(736, HiveOperation.DROPTABLE);
        commandType.put(725, HiveOperation.DESCTABLE);
        commandType.put(724, HiveOperation.DESCFUNCTION);
        commandType.put(805, HiveOperation.MSCK);
        commandType.put(652, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(672, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(670, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(669, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(661, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(654, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(677, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(655, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(678, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(668, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(662, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(663, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(660, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(653, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(889, HiveOperation.SHOWDATABASES);
        commandType.put(895, HiveOperation.SHOWTABLES);
        commandType.put(887, HiveOperation.SHOWCOLUMNS);
        commandType.put(904, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(905, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(897, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(898, HiveOperation.SHOW_CREATETABLE);
        commandType.put(891, HiveOperation.SHOWFUNCTIONS);
        commandType.put(892, HiveOperation.SHOWINDEXES);
        commandType.put(894, HiveOperation.SHOWPARTITIONS);
        commandType.put(893, HiveOperation.SHOWLOCKS);
        commandType.put(890, HiveOperation.SHOWLOCKS);
        commandType.put(888, HiveOperation.SHOWCONF);
        commandType.put(702, HiveOperation.CREATEFUNCTION);
        commandType.put(732, HiveOperation.DROPFUNCTION);
        commandType.put(864, HiveOperation.RELOADFUNCTION);
        commandType.put(705, HiveOperation.CREATEMACRO);
        commandType.put(734, HiveOperation.DROPMACRO);
        commandType.put(708, HiveOperation.CREATEVIEW);
        commandType.put(737, HiveOperation.DROPVIEW);
        commandType.put(703, HiveOperation.CREATEINDEX);
        commandType.put(733, HiveOperation.DROPINDEX);
        commandType.put(650, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(649, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(685, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(684, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(682, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(683, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(686, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(681, HiveOperation.ALTERVIEW_AS);
        commandType.put(860, HiveOperation.QUERY);
        commandType.put(801, HiveOperation.LOCKTABLE);
        commandType.put(975, HiveOperation.UNLOCKTABLE);
        commandType.put(800, HiveOperation.LOCKDB);
        commandType.put(974, HiveOperation.UNLOCKDB);
        commandType.put(706, HiveOperation.CREATEROLE);
        commandType.put(735, HiveOperation.DROPROLE);
        commandType.put(753, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(871, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(899, HiveOperation.SHOW_GRANT);
        commandType.put(755, HiveOperation.GRANT_ROLE);
        commandType.put(872, HiveOperation.REVOKE_ROLE);
        commandType.put(900, HiveOperation.SHOW_ROLES);
        commandType.put(903, HiveOperation.SHOW_ROLES);
        commandType.put(902, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(901, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(648, HiveOperation.ALTERDATABASE);
        commandType.put(647, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(723, HiveOperation.DESCDATABASE);
        commandType.put(675, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(687, HiveOperation.ANALYZE_TABLE);
        commandType.put(693, HiveOperation.CACHE_METADATA);
        commandType.put(667, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(896, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(906, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(643, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(912, HiveOperation.START_TRANSACTION);
        commandType.put(700, HiveOperation.COMMIT);
        commandType.put(875, HiveOperation.ROLLBACK);
        commandType.put(885, HiveOperation.SET_AUTOCOMMIT);
        tablePartitionCommandType.put(664, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(665, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(666, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(674, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(673, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(671, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(659, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(676, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(656, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(658, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(679, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(680, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

