/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.PrintStream;
import jline.TerminalFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.internal.CLibrary;

public class InPlaceUpdates {
    public static final int MIN_TERMINAL_WIDTH = 94;

    static boolean isUnixTerminal() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return false;
        }
        try {
            if (CLibrary.isatty((int)CLibrary.STDOUT_FILENO) == 0) {
                return false;
            }
            if (CLibrary.isatty((int)CLibrary.STDERR_FILENO) == 0) {
                return false;
            }
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
        catch (UnsatisfiedLinkError ignore) {
            return false;
        }
        return true;
    }

    public static boolean inPlaceEligible(HiveConf conf) {
        boolean inPlaceUpdates = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_EXEC_INPLACE_PROGRESS);
        return inPlaceUpdates && !SessionState.getConsole().getIsSilent() && InPlaceUpdates.isUnixTerminal() && TerminalFactory.get().getWidth() >= 94;
    }

    public static void reprintLine(PrintStream out, String line) {
        out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        out.flush();
    }

    public static void rePositionCursor(PrintStream ps) {
        ps.print(Ansi.ansi().cursorUp(0).toString());
        ps.flush();
    }
}

