/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeModuleNode;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeRootNode;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeSectionNode;
import org.pentaho.reporting.tools.configeditor.util.BugFixProxyGraphics2D;

public class ConfigTreeRenderer
extends DefaultTreeCellRenderer {
    public ConfigTreeRenderer() {
        this.setDoubleBuffered(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof ConfigTreeRootNode) {
            return super.getTreeCellRendererComponent(tree, "<Root>", sel, expanded, leaf, row, hasFocus);
        }
        if (value instanceof ConfigTreeSectionNode) {
            ConfigTreeSectionNode node = (ConfigTreeSectionNode)value;
            return super.getTreeCellRendererComponent(tree, node.getName(), sel, expanded, leaf, row, hasFocus);
        }
        if (value instanceof ConfigTreeModuleNode) {
            ConfigTreeModuleNode node = (ConfigTreeModuleNode)value;
            StringBuilder text = new StringBuilder(100);
            text.append(node.getModule().getName());
            return super.getTreeCellRendererComponent(tree, text.toString(), sel, expanded, leaf, row, hasFocus);
        }
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(new BugFixProxyGraphics2D((Graphics2D)g));
    }
}

