/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.tools.configeditor.Messages;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeModuleNode;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeRootNode;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeSectionNode;
import org.pentaho.reporting.tools.configeditor.model.ModuleNodeFactory;

public class ConfigTreeModel
implements TreeModel {
    private final Messages messages = Messages.getInstance();
    private final ConfigTreeRootNode root = new ConfigTreeRootNode("<root>");
    private final ConfigTreeSectionNode globalSection = new ConfigTreeSectionNode(this.messages.getString("ConfigTreeModel.GLOBAL_CONFIGURATION"));
    private final ConfigTreeSectionNode localSection = new ConfigTreeSectionNode(this.messages.getString("ConfigTreeModel.LOCAL_CONFIGURATION"));
    private ModuleNodeFactory nodeFactory;
    private final ArrayList<TreeModelListener> listeners = new ArrayList();

    public ConfigTreeModel(AbstractBoot packageManager, boolean includeGlobals) {
        if (includeGlobals) {
            this.root.add(this.globalSection);
        }
        this.root.add(this.localSection);
        this.nodeFactory = new ModuleNodeFactory(packageManager);
    }

    public void load(InputStream in, boolean append) throws IOException {
        this.nodeFactory.load(in, append);
    }

    public void load(boolean append) throws IOException {
        this.nodeFactory.load(append);
    }

    public void updateConfiguration() {
        this.updateConfiguration(true);
    }

    public void updateConfiguration(boolean includeGlobals) {
        this.globalSection.reset();
        this.localSection.reset();
        this.nodeFactory.init();
        ConfigTreeModuleNode[] globalList = this.nodeFactory.getGlobalNodes();
        for (int i = 0; i < globalList.length; ++i) {
            this.globalSection.add(globalList[0]);
        }
        ConfigTreeModuleNode[] localList = this.nodeFactory.getLocalNodes();
        for (int i = 0; i < localList.length; ++i) {
            this.localSection.add(localList[i]);
        }
        this.fireTreeModelChanged();
    }

    private void fireTreeModelChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeModelListener l = this.listeners.get(i);
            l.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.root)));
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeNode node = (TreeNode)parent;
        return node.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        TreeNode node = (TreeNode)parent;
        return node.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        TreeNode tnode = (TreeNode)node;
        return tnode.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeNode node = (TreeNode)parent;
        TreeNode childNode = (TreeNode)child;
        return node.getIndex(childNode);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public ConfigDescriptionEntry getEntryForKey(String key) {
        return this.nodeFactory.getEntryForKey(key);
    }
}

