/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;
import org.pentaho.reporting.tools.configeditor.Messages;
import org.pentaho.reporting.tools.configeditor.model.ClassConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.EnumConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.TextConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.util.DOMUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigDescriptionModel
extends AbstractListModel {
    private static final Log logger = LogFactory.getLog(ConfigDescriptionModel.class);
    private final ArrayList<ConfigDescriptionEntry> content;
    private Messages messages = Messages.getInstance();

    public ConfigDescriptionModel() {
        this.content = new ArrayList();
    }

    public void add(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException(this.messages.getString("ConfigDescriptionModel.ERROR_0001_ENTRY_IS_NULL"));
        }
        int index = this.findEntry(entry.getKeyName());
        if (index == -1) {
            this.content.add(entry);
            this.updated();
        } else {
            this.content.set(index, entry);
        }
    }

    private int findEntry(String key) {
        for (int i = 0; i < this.content.size(); ++i) {
            ConfigDescriptionEntry configDescriptionEntry = this.content.get(i);
            if (!key.equals(configDescriptionEntry.getKeyName())) continue;
            return i;
        }
        return -1;
    }

    public void remove(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException(this.messages.getString("ConfigDescriptionModel.ERROR_0002_ENTRY_IS_NULL"));
        }
        int index = this.findEntry(entry.getKeyName());
        if (index != -1) {
            this.content.remove(index);
            this.updated();
        }
    }

    public void removeAll(int[] indices) {
        int i;
        if (indices.length == 0) {
            return;
        }
        Object[] entries = new Object[indices.length];
        for (i = indices.length - 1; i >= 0; --i) {
            entries[i] = this.content.get(indices[i]);
        }
        for (i = 0; i < entries.length; ++i) {
            this.content.remove(entries[i]);
        }
        this.updated();
    }

    public ConfigDescriptionEntry get(int pos) {
        return this.content.get(pos);
    }

    public void updated() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public int indexOf(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException(this.messages.getString("ConfigDescriptionModel.ERROR_0003_ENTRY_IS_NULL"));
        }
        return this.findEntry(entry.getKeyName());
    }

    public boolean contains(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException(this.messages.getString("ConfigDescriptionModel.ERROR_0004_ENTRY_IS_NULL"));
        }
        return this.findEntry(entry.getKeyName()) > -1;
    }

    public void sort() {
        Collections.sort(this.content, new ConfigEntryComparator());
        this.updated();
    }

    public ConfigDescriptionEntry[] toArray() {
        return this.content.toArray(new ConfigDescriptionEntry[this.content.size()]);
    }

    @Override
    public int getSize() {
        return this.content.size();
    }

    @Override
    public Object getElementAt(int index) {
        ConfigDescriptionEntry entry = this.get(index);
        if (entry == null) {
            return null;
        }
        return entry.getKeyName();
    }

    public void importFromConfig(Configuration config) {
        Iterator it = config.findPropertyKeys("");
        while (it.hasNext()) {
            TextConfigDescriptionEntry entry;
            String keyname = (String)it.next();
            if (System.getProperties().containsKey(keyname) || this.contains(entry = new TextConfigDescriptionEntry(keyname))) continue;
            this.add(entry);
        }
    }

    public void load(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.content.clear();
        Document doc = DOMUtilities.parseInputStream(in);
        Element e = doc.getDocumentElement();
        NodeList list = e.getElementsByTagName("key");
        for (int i = 0; i < list.getLength(); ++i) {
            Element keyElement = (Element)list.item(i);
            String keyName = keyElement.getAttribute("name");
            boolean keyGlobal = "true".equals(keyElement.getAttribute("global"));
            boolean keyHidden = "true".equals(keyElement.getAttribute("hidden"));
            String descr = this.getDescription(keyElement).trim();
            NodeList enumNodes = keyElement.getElementsByTagName("enum");
            if (enumNodes.getLength() != 0) {
                String[] alteratives = this.collectEnumEntries((Element)enumNodes.item(0));
                EnumConfigDescriptionEntry en = new EnumConfigDescriptionEntry(keyName);
                en.setDescription(descr);
                en.setGlobal(keyGlobal);
                en.setHidden(keyHidden);
                en.setOptions(alteratives);
                this.add(en);
                continue;
            }
            NodeList classNodes = keyElement.getElementsByTagName("class");
            if (classNodes.getLength() != 0) {
                Element classElement = (Element)classNodes.item(0);
                String className = classElement.getAttribute("instanceof");
                if (className == null) {
                    throw new ParseException(this.messages.getString("ConfigDescriptionModel.ERROR_0005_MISSING_INSTANCEOF"));
                }
                try {
                    ClassLoader classLoader = ObjectUtilities.getClassLoader(this.getClass());
                    Class<?> baseClass = Class.forName(className, false, classLoader);
                    ClassConfigDescriptionEntry ce = new ClassConfigDescriptionEntry(keyName);
                    ce.setBaseClass(baseClass);
                    ce.setDescription(descr);
                    ce.setGlobal(keyGlobal);
                    ce.setHidden(keyHidden);
                    this.add(ce);
                }
                catch (Exception ex) {
                    String message = this.messages.getString("ConfigDescriptionModel.ERROR_0006_BASE_CLASS_LOAD_FAILED");
                    logger.error((Object)message, (Throwable)ex);
                }
                continue;
            }
            NodeList textNodes = keyElement.getElementsByTagName("text");
            if (textNodes.getLength() == 0) continue;
            TextConfigDescriptionEntry textEntry = new TextConfigDescriptionEntry(keyName);
            textEntry.setDescription(descr);
            textEntry.setGlobal(keyGlobal);
            textEntry.setHidden(keyHidden);
            this.add(textEntry);
        }
    }

    private String[] collectEnumEntries(Element element) {
        NodeList nl = element.getElementsByTagName("text");
        String[] retval = new String[nl.getLength()];
        for (int i = 0; i < nl.getLength(); ++i) {
            retval[i] = DOMUtilities.getText((Element)nl.item(i)).trim();
        }
        return retval;
    }

    private String getDescription(Element e) {
        NodeList descr = e.getElementsByTagName("description");
        if (descr.getLength() == 0) {
            return "";
        }
        return DOMUtilities.getText((Element)descr.item(0));
    }

    public void save(OutputStream out, String encoding) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, encoding));
        AttributeList attList = new AttributeList();
        attList.addNamespaceDeclaration("", "http://jfreereport.sourceforge.net/namespaces/config-description");
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.setDefaultNamespace("http://jfreereport.sourceforge.net/namespaces/config-description");
        tagDescription.setNamespaceHasCData("http://jfreereport.sourceforge.net/namespaces/config-description", false);
        tagDescription.setElementHasCData("http://jfreereport.sourceforge.net/namespaces/config-description", "text", true);
        tagDescription.setElementHasCData("http://jfreereport.sourceforge.net/namespaces/config-description", "description", true);
        XmlWriter dwriter = new XmlWriter((Writer)writer, (TagDescription)tagDescription);
        dwriter.writeXmlDeclaration(encoding);
        dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "config-description", attList, false);
        CharacterEntityParser parser = CharacterEntityParser.createXMLEntityParser();
        for (int i = 0; i < this.getSize(); ++i) {
            ConfigDescriptionEntry entry = this.get(i);
            AttributeList p = new AttributeList();
            p.setAttribute("http://jfreereport.sourceforge.net/namespaces/config-description", "name", entry.getKeyName());
            p.setAttribute("http://jfreereport.sourceforge.net/namespaces/config-description", "global", String.valueOf(entry.isGlobal()));
            p.setAttribute("http://jfreereport.sourceforge.net/namespaces/config-description", "hidden", String.valueOf(entry.isHidden()));
            dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "key", p, false);
            if (entry.getDescription() != null) {
                dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "description", false);
                writer.write(parser.encodeEntities(entry.getDescription()));
                dwriter.writeCloseTag();
            }
            if (entry instanceof ClassConfigDescriptionEntry) {
                ClassConfigDescriptionEntry ce = (ClassConfigDescriptionEntry)entry;
                if (ce.getBaseClass() != null) {
                    dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "class", "instanceof", ce.getBaseClass().getName(), true);
                } else {
                    dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "class", "instanceof", "java.lang.Object", true);
                }
            } else if (entry instanceof TextConfigDescriptionEntry) {
                dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "text", new AttributeList(), true);
            } else if (entry instanceof EnumConfigDescriptionEntry) {
                EnumConfigDescriptionEntry en = (EnumConfigDescriptionEntry)entry;
                dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "enum", false);
                String[] alts = en.getOptions();
                if (alts != null) {
                    for (int optCount = 0; optCount < alts.length; ++optCount) {
                        dwriter.writeTag("http://jfreereport.sourceforge.net/namespaces/config-description", "text", false);
                        dwriter.writeTextNormalized(alts[optCount], false);
                        dwriter.writeCloseTag();
                    }
                }
                dwriter.writeCloseTag();
            }
            dwriter.writeCloseTag();
        }
        dwriter.writeCloseTag();
        writer.flush();
    }

    private static class ConfigEntryComparator
    implements Comparator<ConfigDescriptionEntry>,
    Serializable {
        protected ConfigEntryComparator() {
        }

        @Override
        public int compare(ConfigDescriptionEntry o1, ConfigDescriptionEntry o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getKeyName().compareTo(o2.getKeyName());
        }
    }
}

