/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.editor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.tools.configeditor.editor.TextKeyEditor;
import org.pentaho.reporting.tools.configeditor.model.ClassConfigDescriptionEntry;

public class ClassKeyEditor
extends TextKeyEditor {
    private static final Log logger = LogFactory.getLog(ClassKeyEditor.class);
    private Class baseClass;

    public ClassKeyEditor(HierarchicalConfiguration config, ClassConfigDescriptionEntry entry, String displayName) {
        super(config, entry, displayName);
        this.baseClass = entry.getBaseClass();
        if (this.baseClass == null) {
            logger.warn((Object)"Base class undefined, defaulting to java.lang.Object");
            this.baseClass = Object.class;
        }
        this.validateContent();
    }

    @Override
    public void validateContent() {
        if (this.baseClass == null) {
            return;
        }
        try {
            String className = this.getContent();
            if (className == null) {
                this.setValidInput(false);
            } else {
                ClassLoader classLoader = ObjectUtilities.getClassLoader(this.getClass());
                Class<?> c = Class.forName(className, false, classLoader);
                this.setValidInput(this.baseClass.isAssignableFrom(c));
            }
        }
        catch (Exception e) {
            this.setValidInput(false);
        }
    }
}

