/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.tools.configeditor.ConfigEditorBoot;
import org.pentaho.reporting.tools.configeditor.Messages;
import org.pentaho.reporting.tools.configeditor.model.ClassConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionModel;
import org.pentaho.reporting.tools.configeditor.model.EnumConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.TextConfigDescriptionEntry;

public class ConfigDescriptionEditor
extends JFrame {
    private static final Log logger = LogFactory.getLog(ConfigDescriptionEditor.class);
    protected static final String EDITOR_FONT_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.config.EditorFont";
    protected static final String EDITOR_FONT_SIZE_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.config.EditorFontSize";
    private static final String CLASS_DETAIL_EDITOR_NAME = "Class";
    private static final String ENUM_DETAIL_EDITOR_NAME = "Enum";
    private static final String TEXT_DETAIL_EDITOR_NAME = "Text";
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_CLASS = 1;
    private static final int TYPE_ENUM = 2;
    private JRadioButton rbText;
    private JRadioButton rbClass;
    private JRadioButton rbEnum;
    private ConfigDescriptionModel model;
    private JTextField keyNameField;
    private JTextArea descriptionField;
    private JCheckBox globalField;
    private JCheckBox hiddenField;
    private JTextField baseClassField;
    private JTextField enumEntryEditField;
    private DefaultListModel enumEntryListModel;
    private ResourceBundleSupport resources;
    private CardLayout detailManager;
    private JPanel detailManagerPanel;
    private JPanel detailEditorPane;
    private JList entryList;
    private JList enumEntryList;
    private ConfigDescriptionEntry selectedEntry;
    private JFileChooser fileChooser;
    private JLabel statusHolder;
    private int type;
    private Configuration configurationToEdit;

    public ConfigDescriptionEditor() {
        this(ConfigEditorBoot.class.getName());
    }

    public ConfigDescriptionEditor(AbstractBoot boot) {
        if (boot != null) {
            boot.start();
            this.configurationToEdit = boot.getGlobalConfig();
        }
        this.init();
    }

    public ConfigDescriptionEditor(String booterClass) {
        AbstractBoot boot = (AbstractBoot)ObjectUtilities.loadAndInstantiate((String)booterClass, ConfigDescriptionEditor.class, AbstractBoot.class);
        if (boot != null) {
            boot.start();
            this.configurationToEdit = boot.getGlobalConfig();
        }
        this.init();
    }

    private void init() {
        this.resources = Messages.getInstance();
        this.setTitle(this.resources.getString("config-description-editor.title"));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.detailEditorPane = this.createEditPane();
        JSplitPane splitPane = new JSplitPane(1, this.createEntryList(), this.detailEditorPane);
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)this.createButtonPane(), "South");
        JPanel cPaneStatus = new JPanel();
        cPaneStatus.setLayout(new BorderLayout());
        cPaneStatus.add((Component)contentPane, "Center");
        cPaneStatus.add((Component)this.createStatusBar(), "South");
        this.setContentPane(cPaneStatus);
        this.setEntryType(0);
        this.setSelectedEntry(null);
        this.fileChooser = new JFileChooser();
        this.fileChooser.addChoosableFileFilter((FileFilter)new FilesystemFilter(".xml", this.resources.getString("config-description-editor.xml-files")));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.setStatusText(this.resources.getString("config-description-editor.welcome"));
        this.addWindowListener(new CloseHandler());
    }

    private JPanel createEntryList() {
        AddEntryAction addEntryAction = new AddEntryAction();
        RemoveEntryAction removeEntryAction = new RemoveEntryAction();
        this.model = new ConfigDescriptionModel();
        this.entryList = new JList(this.model);
        this.entryList.addListSelectionListener(new ConfigListSelectionListener());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(addEntryAction);
        toolbar.add(removeEntryAction);
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(200, 0));
        panel.setLayout(new BorderLayout());
        panel.add((Component)toolbar, "North");
        panel.add((Component)new JScrollPane(this.entryList, 20, 30), "Center");
        return panel;
    }

    protected JList getEnumEntryList() {
        return this.enumEntryList;
    }

    protected JTextField getEnumEntryEditField() {
        return this.enumEntryEditField;
    }

    protected DefaultListModel getEnumEntryListModel() {
        return this.enumEntryListModel;
    }

    protected JList getEntryList() {
        return this.entryList;
    }

    private JPanel createButtonPane() {
        CloseAction closeAction = new CloseAction();
        SaveAction saveAction = new SaveAction();
        LoadAction loadAction = new LoadAction();
        ImportAction importAction = new ImportAction();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel buttonHolder = new JPanel();
        buttonHolder.setLayout(new GridLayout(1, 4, 5, 5));
        buttonHolder.add(new JButton(importAction));
        buttonHolder.add(new JButton(loadAction));
        buttonHolder.add(new JButton(saveAction));
        buttonHolder.add(new JButton(closeAction));
        panel.add(buttonHolder);
        return panel;
    }

    private JPanel createEditPane() {
        JPanel buttonHolder = new JPanel();
        buttonHolder.setLayout(new GridLayout(1, 4, 5, 5));
        buttonHolder.add(new JButton(new CancelAction()));
        buttonHolder.add(new JButton(new UpdateAction()));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonPanel.add(buttonHolder);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createDetailEditorPanel(), "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JPanel createEnumerationEditor() {
        this.enumEntryEditField = new JTextField();
        this.enumEntryListModel = new DefaultListModel();
        this.enumEntryList = new JList(this.enumEntryListModel);
        this.enumEntryList.addListSelectionListener(new EnumerationListSelectionHandler());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)this.enumEntryEditField, "North");
        listPanel.add((Component)new JScrollPane(this.enumEntryList), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(5, 1));
        buttonPanel.add(new JButton(new AddEnumEntryAction()));
        buttonPanel.add(new JButton(new RemoveEnumEntryAction()));
        buttonPanel.add(new JButton(new UpdateEnumEntryAction()));
        buttonPanel.add(new JPanel());
        buttonPanel.add(new JButton(new SetBooleanEnumEntryAction()));
        JPanel buttonCarrier = new JPanel();
        buttonCarrier.setLayout(new FlowLayout(1, 0, 0));
        buttonCarrier.add(buttonPanel);
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        editorPanel.add((Component)listPanel, "Center");
        editorPanel.add((Component)buttonCarrier, "East");
        return editorPanel;
    }

    private JPanel createClassEditor() {
        this.baseClassField = new JTextField();
        JLabel baseClassValidateMessage = new JLabel(" ");
        JLabel textLabel = new JLabel(this.resources.getString("config-description-editor.baseclass"));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)textLabel, "West");
        panel.add((Component)this.baseClassField, "Center");
        panel.add((Component)baseClassValidateMessage, "South");
        JPanel carrier = new JPanel();
        carrier.setLayout(new BorderLayout());
        carrier.add((Component)panel, "North");
        return carrier;
    }

    private JPanel createTextEditor() {
        JLabel textLabel = new JLabel(this.resources.getString("config-description-editor.text-editor-message"));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(textLabel);
        return panel;
    }

    private JPanel createDetailEditorPanel() {
        JLabel keyNameLabel = new JLabel(this.resources.getString("config-description-editor.keyname"));
        JLabel descriptionLabel = new JLabel(this.resources.getString("config-description-editor.description"));
        JLabel typeLabel = new JLabel(this.resources.getString("config-description-editor.type"));
        JLabel globalLabel = new JLabel(this.resources.getString("config-description-editor.global"));
        JLabel hiddenLabel = new JLabel(this.resources.getString("config-description-editor.hidden"));
        this.hiddenField = new JCheckBox();
        this.globalField = new JCheckBox();
        String font = ConfigEditorBoot.getInstance().getGlobalConfig().getConfigProperty(EDITOR_FONT_KEY, "Monospaced");
        int fontSize = ParserUtil.parseInt((String)ConfigEditorBoot.getInstance().getGlobalConfig().getConfigProperty(EDITOR_FONT_SIZE_KEY), (int)12);
        this.descriptionField = new JTextArea();
        this.descriptionField.setFont(new Font(font, 0, fontSize));
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setWrapStyleWord(true);
        this.keyNameField = new JTextField();
        JPanel enumerationEditor = this.createEnumerationEditor();
        JPanel textEditor = this.createTextEditor();
        JPanel classEditor = this.createClassEditor();
        this.detailManagerPanel = new JPanel();
        this.detailManager = new CardLayout();
        this.detailManagerPanel.setLayout(this.detailManager);
        this.detailManagerPanel.add((Component)classEditor, CLASS_DETAIL_EDITOR_NAME);
        this.detailManagerPanel.add((Component)textEditor, TEXT_DETAIL_EDITOR_NAME);
        this.detailManagerPanel.add((Component)enumerationEditor, ENUM_DETAIL_EDITOR_NAME);
        JPanel commonEntryEditorPanel = new JPanel();
        commonEntryEditorPanel.setLayout(new GridBagLayout());
        commonEntryEditorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)keyNameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.keyNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)descriptionLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        gbc.ipady = 120;
        commonEntryEditorPanel.add((Component)new JScrollPane(this.descriptionField, 22, 31), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)globalLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.globalField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)hiddenLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.hiddenField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)typeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.createTypeSelectionPane(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.detailManagerPanel, gbc);
        return commonEntryEditorPanel;
    }

    private JPanel createTypeSelectionPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 1));
        this.rbText = new JRadioButton(new SelectTypeAction(this.resources.getString("config-description-editor.type-text"), 0));
        this.rbClass = new JRadioButton(new SelectTypeAction(this.resources.getString("config-description-editor.type-class"), 1));
        this.rbEnum = new JRadioButton(new SelectTypeAction(this.resources.getString("config-description-editor.type-enum"), 2));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbText);
        bg.add(this.rbClass);
        bg.add(this.rbEnum);
        panel.add(this.rbText);
        panel.add(this.rbClass);
        panel.add(this.rbEnum);
        return panel;
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        statusPane.setMinimumSize(this.statusHolder.getPreferredSize());
        statusPane.add((Component)this.statusHolder, "West");
        return statusPane;
    }

    protected void setStatusText(String text) {
        this.statusHolder.setText(text);
    }

    protected String getStatusText() {
        return this.statusHolder.getText();
    }

    protected void setEntryType(int type) {
        this.type = type;
        if (type == 1) {
            this.detailManager.show(this.detailManagerPanel, CLASS_DETAIL_EDITOR_NAME);
            this.rbClass.setSelected(true);
        } else if (type == 2) {
            this.detailManager.show(this.detailManagerPanel, ENUM_DETAIL_EDITOR_NAME);
            this.rbEnum.setSelected(true);
        } else {
            this.detailManager.show(this.detailManagerPanel, TEXT_DETAIL_EDITOR_NAME);
            this.rbText.setSelected(true);
        }
        this.invalidate();
    }

    protected int getEntryType() {
        return this.type;
    }

    protected ConfigDescriptionEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    protected void setSelectedEntry(ConfigDescriptionEntry selectedEntry) {
        this.selectedEntry = selectedEntry;
        this.enumEntryEditField.setText("");
        this.enumEntryListModel.clear();
        this.baseClassField.setText("");
        if (this.selectedEntry == null) {
            this.deepEnable(this.detailEditorPane, false);
        } else {
            this.deepEnable(this.detailEditorPane, true);
            this.keyNameField.setText(selectedEntry.getKeyName());
            this.globalField.setSelected(selectedEntry.isGlobal());
            this.hiddenField.setSelected(selectedEntry.isHidden());
            this.descriptionField.setText(selectedEntry.getDescription());
            if (selectedEntry instanceof ClassConfigDescriptionEntry) {
                ClassConfigDescriptionEntry ce = (ClassConfigDescriptionEntry)selectedEntry;
                this.setEntryType(1);
                if (ce.getBaseClass() != null) {
                    this.baseClassField.setText(ce.getBaseClass().getName());
                }
            } else if (selectedEntry instanceof EnumConfigDescriptionEntry) {
                EnumConfigDescriptionEntry en = (EnumConfigDescriptionEntry)selectedEntry;
                String[] enums = en.getOptions();
                for (int i = 0; i < enums.length; ++i) {
                    this.enumEntryListModel.addElement(enums[i]);
                }
                this.setEntryType(2);
            } else {
                this.setEntryType(0);
            }
        }
    }

    private void deepEnable(Component comp, boolean state) {
        comp.setEnabled(state);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] childs = cont.getComponents();
            for (int i = 0; i < childs.length; ++i) {
                this.deepEnable(childs[i], state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        this.fileChooser.setVisible(true);
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            OutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.fileChooser.getSelectedFile()));
                this.model.save(out, "UTF-8");
                out.close();
                this.setStatusText(this.resources.getString("config-description-editor.save-complete"));
            }
            catch (Exception ioe) {
                logger.debug((Object)"Failed", (Throwable)ioe);
                String message = MessageFormat.format(this.resources.getString("config-description-editor.save-failed"), ioe.getMessage());
                this.setStatusText(message);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        this.fileChooser.setVisible(true);
        int option = this.fileChooser.showOpenDialog(this);
        if (option == 0) {
            InputStream in = null;
            try {
                FileInputStream fileIn = new FileInputStream(this.fileChooser.getSelectedFile());
                in = new BufferedInputStream(fileIn);
                this.model.load(in);
                this.model.sort();
                this.setStatusText(this.resources.getString("config-description-editor.load-complete"));
            }
            catch (Exception ioe) {
                logger.debug((Object)"Load Failed", (Throwable)ioe);
                String message = MessageFormat.format(this.resources.getString("config-description-editor.load-failed"), ioe.getMessage());
                this.setStatusText(message);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void writeSelectedEntry() {
        ConfigDescriptionEntry entry;
        switch (this.getEntryType()) {
            case 1: {
                ClassConfigDescriptionEntry ce = new ClassConfigDescriptionEntry(this.keyNameField.getText());
                ce.setDescription(this.descriptionField.getText());
                ce.setGlobal(this.globalField.isSelected());
                ce.setHidden(this.hiddenField.isSelected());
                try {
                    String className = this.baseClassField.getText();
                    if (className == null) {
                        ce.setBaseClass(Object.class);
                    } else {
                        ClassLoader classLoader = ObjectUtilities.getClassLoader(this.getClass());
                        Class<?> c = Class.forName(className, false, classLoader);
                        ce.setBaseClass(c);
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)"Class is invalid; defaulting to Object.class");
                    ce.setBaseClass(Object.class);
                }
                entry = ce;
                break;
            }
            case 2: {
                EnumConfigDescriptionEntry ece = new EnumConfigDescriptionEntry(this.keyNameField.getText());
                ece.setDescription(this.descriptionField.getText());
                ece.setGlobal(this.globalField.isSelected());
                ece.setHidden(this.hiddenField.isSelected());
                String[] enumEntries = new String[this.enumEntryListModel.getSize()];
                for (int i = 0; i < this.enumEntryListModel.getSize(); ++i) {
                    enumEntries[i] = String.valueOf(this.enumEntryListModel.get(i));
                }
                ece.setOptions(enumEntries);
                entry = ece;
                break;
            }
            default: {
                TextConfigDescriptionEntry te = new TextConfigDescriptionEntry(this.keyNameField.getText());
                te.setDescription(this.descriptionField.getText());
                te.setGlobal(this.globalField.isSelected());
                te.setHidden(this.hiddenField.isSelected());
                entry = te;
                break;
            }
        }
        ConfigDescriptionEntry selectedEntry = this.getSelectedEntry();
        if (selectedEntry == null) {
            this.model.add(entry);
            return;
        }
        if (!ObjectUtilities.equal((Object)selectedEntry.getKeyName(), (Object)entry.getKeyName())) {
            this.model.remove(selectedEntry);
        }
        this.model.add(entry);
    }

    protected ConfigDescriptionModel getModel() {
        return this.model;
    }

    protected void attempExit() {
        System.exit(0);
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public static void main(String[] args) {
        ConfigEditorBoot.getInstance().start();
        if (args.length == 0) {
            ConfigDescriptionEditor ed = new ConfigDescriptionEditor();
            ed.pack();
            ed.setVisible(true);
        } else {
            AbstractBoot boot = AbstractBoot.loadBooter((String)args[0], ConfigDescriptionEditor.class);
            if (boot == null) {
                System.out.println("Error: Unable to load the specified booter class: " + args[0]);
                System.exit(-1);
            }
            ConfigDescriptionEditor ed = new ConfigDescriptionEditor(boot);
            ed.pack();
            ed.setVisible(true);
        }
    }

    private class UpdateEnumEntryAction
    extends AbstractAction {
        private UpdateEnumEntryAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.update-enum-entry.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx = ConfigDescriptionEditor.this.getEnumEntryList().getSelectedIndex();
            if (idx == -1) {
                ConfigDescriptionEditor.this.getEnumEntryListModel().addElement(ConfigDescriptionEditor.this.getEnumEntryEditField().getText());
            } else {
                ConfigDescriptionEditor.this.getEnumEntryListModel().setElementAt(ConfigDescriptionEditor.this.getEnumEntryEditField().getText(), idx);
            }
        }
    }

    private class RemoveEnumEntryAction
    extends AbstractAction {
        private RemoveEnumEntryAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.remove-enum-entry.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList enumEntryList = ConfigDescriptionEditor.this.getEnumEntryList();
            DefaultListModel enumEntryListModel = ConfigDescriptionEditor.this.getEnumEntryListModel();
            int[] selectedEntries = enumEntryList.getSelectedIndices();
            for (int i = selectedEntries.length - 1; i >= 0; --i) {
                enumEntryListModel.remove(selectedEntries[i]);
            }
            enumEntryList.clearSelection();
        }
    }

    private class AddEnumEntryAction
    extends AbstractAction {
        private AddEnumEntryAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.add-enum-entry.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.getEnumEntryListModel().addElement(ConfigDescriptionEditor.this.getEnumEntryEditField().getText());
        }
    }

    private class SetBooleanEnumEntryAction
    extends AbstractAction {
        private SetBooleanEnumEntryAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.boolean.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel enumEntryListModel = ConfigDescriptionEditor.this.getEnumEntryListModel();
            enumEntryListModel.clear();
            ConfigDescriptionEditor.this.getEnumEntryEditField().setText("");
            enumEntryListModel.addElement("true");
            enumEntryListModel.addElement("false");
        }
    }

    private class EnumerationListSelectionHandler
    implements ListSelectionListener {
        private EnumerationListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ConfigDescriptionEditor.this.getEnumEntryList().getSelectedIndex() == -1) {
                ConfigDescriptionEditor.this.getEnumEntryEditField().setText("");
            } else {
                ConfigDescriptionEditor.this.getEnumEntryEditField().setText((String)ConfigDescriptionEditor.this.getEnumEntryListModel().get(ConfigDescriptionEditor.this.getEnumEntryList().getSelectedIndex()));
            }
        }
    }

    private class ConfigListSelectionListener
    implements ListSelectionListener {
        private boolean inUpdate;

        private ConfigListSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.inUpdate) {
                return;
            }
            this.inUpdate = true;
            try {
                int selectedIndex = ConfigDescriptionEditor.this.getEntryList().getSelectedIndex();
                ConfigDescriptionEntry newEntry = selectedIndex == -1 ? null : ConfigDescriptionEditor.this.getModel().get(selectedIndex);
                ConfigDescriptionEntry oldEntry = ConfigDescriptionEditor.this.getSelectedEntry();
                if (oldEntry != null) {
                    ConfigDescriptionEditor.this.writeSelectedEntry();
                }
                if (newEntry != null) {
                    int index = ConfigDescriptionEditor.this.getModel().indexOf(newEntry);
                    if (ConfigDescriptionEditor.this.getEntryList().getSelectedIndex() != index) {
                        ConfigDescriptionEditor.this.getEntryList().setSelectedIndex(index);
                    }
                    ConfigDescriptionEditor.this.setSelectedEntry(newEntry);
                } else {
                    ConfigDescriptionEditor.this.getEntryList().setSelectedIndex(-1);
                    ConfigDescriptionEditor.this.setSelectedEntry(null);
                }
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    private class SelectTypeAction
    extends AbstractAction {
        private final int type;

        private SelectTypeAction(String name, int type) {
            this.putValue("Name", name);
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.setEntryType(this.type);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.cancel.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEntry ce = ConfigDescriptionEditor.this.getSelectedEntry();
            ConfigDescriptionEditor.this.setSelectedEntry(null);
            ConfigDescriptionEditor.this.setSelectedEntry(ce);
        }
    }

    private class UpdateAction
    extends AbstractAction {
        private UpdateAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.update.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.writeSelectedEntry();
        }
    }

    private class LoadAction
    extends AbstractAction {
        private LoadAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.load.name"));
            this.putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.load.small-icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.load();
        }
    }

    private class RemoveEntryAction
    extends AbstractAction {
        private RemoveEntryAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.remove-entry.name"));
            this.putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.remove-entry.small-icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedEntries = ConfigDescriptionEditor.this.getEntryList().getSelectedIndices();
            ConfigDescriptionEditor.this.setSelectedEntry(null);
            ConfigDescriptionModel model = ConfigDescriptionEditor.this.getModel();
            model.removeAll(selectedEntries);
            ConfigDescriptionEditor.this.getEntryList().clearSelection();
        }
    }

    private class AddEntryAction
    extends AbstractAction {
        private AddEntryAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.add-entry.name"));
            this.putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.add-entry.small-icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextConfigDescriptionEntry te = new TextConfigDescriptionEntry(ConfigDescriptionEditor.this.getResources().getString("config-description-editor.unnamed-entry"));
            ConfigDescriptionModel model = ConfigDescriptionEditor.this.getModel();
            model.add(te);
            ConfigDescriptionEditor.this.getEntryList().setSelectedIndex(model.getSize() - 1);
        }
    }

    private class ImportAction
    extends AbstractAction {
        private ImportAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.import.name"));
            this.putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.import.small-icon"));
            this.setEnabled(ConfigDescriptionEditor.this.configurationToEdit != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ConfigDescriptionEditor.this.configurationToEdit == null) {
                return;
            }
            ConfigDescriptionModel model = ConfigDescriptionEditor.this.getModel();
            model.importFromConfig(ConfigDescriptionEditor.this.configurationToEdit);
            model.sort();
            ConfigDescriptionEditor.this.setStatusText(ConfigDescriptionEditor.this.getResources().getString("config-description-editor.import-complete"));
        }
    }

    private class SaveAction
    extends AbstractAction {
        private SaveAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.save.name"));
            this.putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.save.small-icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.save();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
            this.putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.exit.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.attempExit();
        }
    }

    private class CloseHandler
    extends WindowAdapter {
        private CloseHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ConfigDescriptionEditor.this.attempExit();
        }
    }
}

